@php 
use App\Models\Job;
@endphp

<div class="" id="table">
    <table class="table stock-detail">
        <thead>
        <tr>
            <th>{{ __('content.select') }}</th>
            <th class="cus-w-1">@sortablelink('item_code', __('content.jo') ) </th>
            <th>{{ __('content.image') }}</th>
            <th style="width:310px;">{{ __('content.description') }}</th>
            <th> @sortablelink('estimate_completion', __('content.completion_date'))</th>
            <th> @sortablelink('job_type.name', __('content.type'))</th>
            <th> @sortablelink('job_status', __('content.status'))</th>
            <th>{{ __('content.worksmith') }}</th>
            @canany(['job-duplicate','job-quotation','job-print','job-update','job-delete'])
            <th>{{ __('content.action') }}</th>
            @endcanany
        </tr>
        </thead>
        <tbody>
        @if(!empty($records) && $records->count())
            @foreach($records as $record)
                <tr>
                    <td>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                        </div>
                    </td>
                    <td><strong>{{ $record->item_code }}</strong></td>
                    <td><a data-fancybox="gallery" href="{{ $record->first_image ? $record->first_image->image_url : Job::defaultImage() }}"><img width="70" src="{{ $record->first_image ? $record->first_image->image_url : Job::defaultImage() }}"></a>
                    </td>
                    <td class="description">
                        <div>{{ ($record->description) ? \Illuminate\Support\Str::limit($record->description, 112, $end='...') : "-"}}</div>
                    </td>
                    <td>{{ ($record->estimate_completion) ? date('d/m/y', strtotime($record->estimate_completion)) : "-"}}</td>
                    <td>{{ !empty($record->job_type->name) ? $record->job_type->name: '-' }}</td>
                    <td>
                        @php
                            $job_status =  Job::job_status();
                            $dynamicColor =  Job::dynamicColor($record->job_status);
                        @endphp
                        <div class="dropdown job_status {{ $dynamicColor }} {{ ($dynamicColor ==  Job::MINT) ? 'not_allowed' : '' }} worksmith_new" id="job_status_div-{{ $record->id }}">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuJobStatus-{{ $record->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                {{ old('job_status',$record->job_status ) }}
                            </button>

                            <ul class="dropdown-menu status_dropdown-{{ $record->id }}" aria-labelledby="dropdownMenuButton1">
                                <!-- <li><a class="dropdown-item status_change {{-- ($record->job_status == ' ') ? 'active' : '' --}}" value=" " data-id="{{-- $record->id --}}">Select Option</a></li> -->
                                @foreach($job_status as $key=>$value)
                                    <li>
                                        <a class="dropdown-item status_change {{ ($record->job_status == $key) ? 'active' : '' }}" id="{{ str_replace(' ', '_', $key).'-'.$record->id }}" data-id="{{ $record->id }}" value="{{ $key }}">{{ $value }}</a>
                                    </li>
                                @endforeach
                                <input id="job_status" type="hidden" name="job_status" value="">
                            </ul>
                        </div>
                    </td>
                    <td>
                        <div class="dropdown worksmith worksmith_new {{ (  $record->job_status == Job::RECEIVED) ? 'not_allowed' : '' }}">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="worksmith" data-bs-toggle="dropdown" aria-expanded="false">
                                {{ (!empty( $record->worksmith->fullname) ?  $record->worksmith->fullname: "Select Option"  )  }}
                            </button>

                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <li><a class="dropdown-item worksmith_change {{ (($record->worksmith_id == ' ') || empty($record->worksmith_id)) ? 'active' : '' }}" value=" " data-id="{{ $record->id }}" data-name="Select Option">Select Option</a></li>
                                @php  
                                $worksmiths  = \App\Models\Worksmith::getWorksmithsList();
                                @endphp
                                @foreach($worksmiths as $key=>$value)
                                    <li><a class="dropdown-item worksmith_change {{ ($record->worksmith_id == $key) ? 'active' : '' }}" value="{{ $key }}" data-id="{{ $record->id }}" data-name="{{ $value }}">{{ strtoupper($value) }}</a></li>
                                @endforeach
                                <input type="hidden" name="worksmith_id" value="{{ $record->worksmith_id ?? ''}}" id="worksmith_id">
                            </ul>
                        </div>
                    </td>
                    @canany(['job-duplicate','job-quotation','job-print','job-update','job-delete'])
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-secondary down" type="button"
                            id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                @if(empty($record->deleted_at))
                                    @can('job-duplicate')
                                        <li>
                                            <a class="dropdown-item duplicate" href="{{ route('admin.jobs.duplicate',$record->id) }}"><img src="{{ asset('public/img/duplicate.png') }}">Duplicate</a>
                                        </li>
                                    @endcan
                                @endif

                                @if(empty($record->deleted_at))
                                    @can('job-update') 
                                        <li>
                                            <a class="dropdown-item" href="{{ route('admin.jobs.edit',$record->id) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a>
                                        </li>
                                    @endcan
                                @endif

                                @if(empty($record->deleted_at))
                                    @can('job-print')
                                        <li>
                                            <a class="dropdown-item btn btn_prn btnprn" href="{{ route('admin.jobs.print',$record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print</a>
                                        </li> 
                                    @endcan
                                @endif

                                @if(empty($record->deleted_at))
                                    @can('job-delete')
                                        <li>
                                            <a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.jobs.destroy',$record->id) }}"><img src="{{ asset('public/img/archive.png') }} ">Archive</a>
                                        </li>
                                    @endcan
                                @else    
                                    @can('job-restore')
                                        <li>
                                            <a class="dropdown-item confirmRestore" href="javascript:void(0);" data-action="{{ route('admin.jobs.restore',$record->id) }}"><img src="{{ asset('public/img/restore.png') }} ">Restore</a>
                                        </li>
                                     @endcan
                                @endif
                            </ul>
                        </div>
                    </td>
                    @endcanany
                </tr>
            @endforeach
        @else
            <tr>
                <td class="text-center" colspan="9">No Record Found!</td>
            </tr>
        @endif
        </tbody>
    </table>
</div>
    