@extends('layouts.admin.default')

@section('title',"Jobs")

@section('header', "Jobs")
@section('content')
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">Job Orders</h4>
            <p>This section displays the job orders in Sancy’s ERP</p>
        </div>
        <div class="card-body">
            @php
                $placeholder = "Search Jewellry Based on Code or Description";
                $jobFilter = true;

            $create = [
                    'route' => route('admin.jobs.create'),
                    'name' => "Create Job"
                      ];
            @endphp
            @include('admin.elements.search.common')

            <div class=" earring-table table-responsive" id="myTabContent">
                <div class="" id="table">
                    <table class="table stock-detail">
                        <thead>
                        <tr>
                            <th>Select</th>
                            <th class="cus-w-1">@sortablelink('item_code','STOCK #')</th>
                            <th>IMAGE</th>
                            <th style="width:310px;">DESCRIPTION</th>
                            <th> @sortablelink('estimate_completion','Estimate Completion')</th>
                            <th> @sortablelink('job_type.name','TYPE')</th>
                            <th> @sortablelink('job_status','Status')</th>
                            <th>WORKSMITH</th>
                            <th>ACTION</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if(!empty($records) && $records->count())
                            @foreach($records as $record)
                                <tr>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value=""
                                                   id="flexCheckDefault">
                                        </div>
                                    </td>
                                    <td><strong>{{ $record->item_code }}</strong></td>
                                    <td><a data-fancybox="gallery"
                                           href="{{ $record->first_image ? $record->first_image->image_url : \App\Models\Job::defaultImage() }}"><img
                                                width="70"
                                                src="{{ $record->first_image ? $record->first_image->image_url : \App\Models\Job::defaultImage() }}"></a>
                                    </td>
                                    <td class="description">{{\Illuminate\Support\Str::limit($record->description, 112, $end='...')}}</td>
                                    <td>{{ date('d/m/y', strtotime($record->estimate_completion))}}</td>
                                    <td>{{ !empty($record->job_type->name) ? $record->job_type->name: '-' }}</td>
                                    <td>
                                        @php
                                            $job_status =  App\Models\Job::job_status();
                                            $dynamicColor =  App\Models\Job::dynamicColor($record->job_status);

                                        @endphp
                                        <div class="dropdown job_status {{ $dynamicColor }}">
                                            <button class="btn btn-secondary dropdown-toggle" type="button"
                                                    id="dropdownMenuJobStatus" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                {{ old('job_status',$record->job_status ) }}
                                            </button>

                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                @foreach($job_status as $key=>$value)
                                                    <li><a class="dropdown-item status_change"
                                                           data-id="{{ $record->id }}"
                                                           value="{{ $key }}">{{ $value }}</a></li>
                                                @endforeach

                                                <input id="job_status" type="hidden" name="job_status" value="">

                                            </ul>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="dropdown worksmith">
                                            <button class="btn btn-secondary dropdown-toggle" type="button"
                                                    id="worksmith" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                {{ (!empty( $record->worksmith->fullname) ?  $record->worksmith->fullname: "Select Option"  )  }}
                                            </button>

                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                @php  $worksmiths  = \App\Models\Admin::getWorksmiths();@endphp
                                                @foreach($worksmiths as $key=>$value)
                                                    <li><a class="dropdown-item worksmith_change" value="{{ $key }}" data-id="{{ $record->id }}" data-name="{{ $value }}">{{ $value }}</a></li>
                                                @endforeach
                                                <input type="hidden" name="worksmith_id" value=""
                                                       id="worksmith_id">
                                            </ul>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button"
                                                    id="dropdownMenuButton1"
                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                <li>
                                                    <a class="dropdown-item duplicate" href="{{route('admin.jobs.duplicate',$record->id)}}"><img src="{{ asset('public/img/duplicate.png') }}">Duplicate</a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="#"><img src="{{ asset('public/img/quotation.png') }}">Quotations</a>
                                                </li>
                                                @can('job-update')
                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('admin.jobs.edit',$record->id) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a>
                                                    </li>
                                                @endcan
                                                <li>
                                                    <a class="dropdown-item btnprn btn" href="{{ route('admin.jobs.print',$record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print</a>
                                                </li>
                                                @can('job-delete')
                                                    <li>
                                                        <a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.jobs.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a>
                                                    </li>
                                                @endcan
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td class="text-center" colspan="13">No Record Found!</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
                <div id="calendar">
                    <!--  Calendar View Starts Here -->
                    <div class="cardnew">
                        <div class="bg-white job_oder_main card-custom-body p-4">
                            <h2 class="h2_title">Calendar</h2>
                            <div class="bg-white job_oder_main mt-3">
                                <div class="row">
                                    <div class="col-md-3 pe-0">
                                        <div class="job_order">
                                            <p>Job Order <span id="jobCount"></span></p> <!-- Total: 4 -->
                                            <div id="legendDiv" class="myCalenderDiv" style="padding-top:40px !important;">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-9 ps-0"  >
                                        <!-- <div id="blankDiv" class="blank_div"></div> -->
                                        <div id="chartContainer" class="myCalenderDiv" ></div>  <!-- style="min-height:300px;" style="min-height:1440px;" -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--  Calendar View Ends Here -->
                </div>
            </div>
            @if($tab == \App\Models\Job::TABLE)
                @include('admin.elements.pagination.common')
            @endif
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body filter-options">
                    <form method="get" class="ajaxForm" action="{{ url()->current() }}" id="AjaxFilter"
                          autocomplete="off">
                        <input type="hidden" class="form-control" name="search" value="{{ request('search') }}">
                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Date</label>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" name="start_date" class=" datePicker cus_form_control "
                                           value="">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" name="end_date" class=" datePicker cus_form_control "
                                           value="">
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Price</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1"
                                           placeholder="$" name="price_min" value="">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1"
                                           placeholder="$" name="price_max" value="">
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Worksmith</label>
                                    <select class="form-select" aria-label="Default select example"
                                            name="worksmith_id">
                                        <option value="" selected>Select One Option</option>
                                        @php $worksmiths = \App\Models\Admin::getWorksmiths(); @endphp
                                        @foreach($worksmiths as $key=>$value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Type</label>
                                    <select class="form-select" aria-label="Default select example"
                                            name="job_type_id">
                                        <option value="" selected>Select One Option</option>
                                        @php $types = \App\Models\JobType::getJobTypesList(); @endphp
                                        @foreach($types as $key=>$value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Status</label>
                                    <select class="form-select" aria-label="Default select example"
                                            name="job_status">
                                        <option value="" selected>Select One Option</option>
                                        @php  $job_status =  App\Models\Job::job_status(); @endphp
                                        @foreach($job_status as $key=>$value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>


                            <div class="col-lg-12 col-md-12 mt-3">
                                <div class="filter-modal-btn m-0">
                                    <button type="submit" id="AjaxFilterButton" class="btn btn-filter"
                                            data-bs-dismiss="modal"><i class="icofont-filter"></i>Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
    </div>

    @include('admin.jobs.script')


    <!-- amchart -->
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <script src="https://www.amcharts.com/lib/4/themes/amcharts.js"></script>
    @include('admin.jobs.calender_view_script')

@endsection
