@php
 $year  = (request()->year) ?? date('Y');
 $month = (request()->month) ?? date('F');
@endphp

<div id="calendar">
    <div class="bg-white job_oder_main mt-3">
        <div> <h2 class="h2_title">Calendar</h2></div>
        <div class="row">
           <div class="col-md-12">
            <div class="card card-custom">
                <div class="card-header">
                    <h6 class="job_amount d-flex align-items-center mb-0"><span class="d-block">Job Order :</span> <span class="d-block total_count ms-2" id="jobCount">Total: {{ count($newJobsItem) }}</span></h6>
                    <div class="d-flex align-items-center">
                        <div class="dropdown date_dropdown me-3">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                             {{ $year  }}
                            </button>
                            @php $years = range(2027, 2000);  @endphp
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                            @foreach ($years as $val)
                            <a class="dropdown-item" href="{{ route('admin.jobs.index',[ 'tab'=>request()->tab,'job_status'=> \App\Models\Job::ACTIVE , 'year'=> $val ,'month'=> $month  ]) }}">{{ $val }}</a>
                            @endforeach
                            </ul>
                        </div>
                        <div class="dropdown date_dropdown">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                             {{  $month  }}
                            </button>
                            @php $month_names = App\Models\Job::MONTH_ARR; @endphp
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                            @foreach ($month_names as $key=>$val)
                            <a class="dropdown-item" href="{{ route('admin.jobs.index',[ 'tab'=>request()->tab,'job_status'=> \App\Models\Job::ACTIVE ,'year'=> $year ,'month'=> $val ]) }}">{{ $val }}</a>
                            @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if(count($newJobsItem))
                        <figure class="highcharts-figure position relative">
                            <div id="calendarChart">
                            <p class="highcharts-description">
                            </p>
                        </figure>
                    @else
                        <h1 class="no_record mb-0">NO Job Order Found!</h1>
                    @endif

                </div>
              </div>
           </div>
        </div>
    </div>
</div>


<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/xrange.js"></script>


<script>
    var job_item = {!! json_encode($newJobsItem) !!};
    var data = {!! json_encode($newJobsList) !!};

    Highcharts.chart('calendarChart', {
        chart: {
          type: 'xrange'
        },
        title: {
          text: 'Highcharts X-range'
        },
        accessibility: {
          point: {
            descriptionFormatter: function (point) {
              var ix = point.index + 1,
                category = point.yCategory,
                from = new Date(point.x),
                to = new Date(point.x2);
              return ix + '. ' + category + ', ' + from.toDateString() +
                ' to ' + to.toDateString() + '.';
            }
          }
        },
        xAxis: {
          type: 'datetime'
        },
        yAxis: {
          title: {
            text: ''
          },
          categories: job_item,
          reversed: true
        },
        series: [{
          name: 'Job Order',
          borderColor: 'gray',
          pointWidth: 20,
          data: data ,
          dataLabels: {
            enabled: true
          }
        }]

      });
</script>



