@extends('layouts.admin.default')

@section('title',"Jobs")

@section('header', "Jobs")

@section('content')
    <div class="card mb-4">
        {{-- <div class="card-header"> --}}
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <h4 class="mb-0">{{ __('content.job_orders') }}</h4>
                <p>This section displays the job orders in Sancy’s ERP</p>
            </div>

            @if($tab == \App\Models\Job::TABLE)
            <div class="custom_filter">
                <ul class="nav">
                    <li class="nav-item">
                        <a href="{{ route('admin.jobs.index', [ 'tab'=> $tab,'job_status' => \App\Models\Job::ACTIVE ]) }}" class="nav-link {{ ( request()->job_status  == \App\Models\Job::ACTIVE ) ? 'active' : '' }}"  >Active</a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('admin.jobs.index', [ 'tab'=> $tab,'job_status' => \App\Models\Job::ARCHIVED ]) }}" class="nav-link {{ ( request()->job_status  == \App\Models\Job::ARCHIVED) ? 'active' : '' }}" >Archived</a>
                    </li>
                </ul>
            </div>
            @endif

        </div>
        <div class="card-body">
            @php
                $placeholder = "Search Jewellry Based on Code or Description";
                $jobFilter = true;
            @endphp
                @can('job-create')
                @php
                $create = [
                    'route' => route('admin.jobs.create'),
                    'name' => "Create Job"
                ];
                @endphp
             @endcan
                @include('admin.elements.search.common')

            @if($tab == \App\Models\Job::TABLE)
                <div class=" earring-table table-responsive" id="myTabContent">
                    @include('admin.jobs.index_table')
                </div>
                @include('admin.elements.pagination.common')
            @elseif($tab == \App\Models\Job::CALENDAR)
                @include('admin.jobs.index_calendar')
            @endif
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body filter-options">
                    <form method="get" class="ajaxForm" action="{{ url()->current() }}" id="AjaxFilter"
                          autocomplete="off">
                        <input type="hidden" class="form-control" name="search" value="{{ request('search') }}">
                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Date</label>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" name="start_date" class=" datePicker cus_form_control" value="" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" name="end_date" class=" datePicker cus_form_control" value="" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Price</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1" placeholder="$" name="price_min" value="">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1" placeholder="$" name="price_max" value="">
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">{{ __('content.worksmith') }}</label>
                                    @php $worksmiths  = \App\Models\Worksmith::getWorksmithsList(); @endphp
                                    <select class="form-select" aria-label="Default select example" name="worksmith_id">
                                        <option value="" selected>Select One Option</option>
                                        @foreach($worksmiths as $key=>$value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Type</label>
                                    <select class="form-select" aria-label="Default select example" name="job_type_id">
                                        <option value="" selected>Select One Option</option>
                                        @php $types = \App\Models\JobType::getJobTypesList(); @endphp
                                        @foreach($types as $key=>$value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Status</label>
                                    <select class="form-select" aria-label="Default select example" name="job_status">
                                        <option value="" selected>Select One Option</option>
                                        @php  $job_status =  App\Models\Job::job_status(); @endphp
                                        @foreach($job_status as $key=>$value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>


                            <div class="col-lg-12 col-md-12 mt-3">
                                <div class="filter-modal-btn m-0">
                                    <button type="submit" id="AjaxFilterButton" class="btn btn-filter" data-bs-dismiss="modal"><i class="icofont-filter"></i>Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
    </div>

    @include('admin.jobs.script')

@endsection

