@extends('layouts.admin.default')

@section('title',"Duplicate Jobs")

@section('header', "Duplicate Jobs")
<style>
    #drawingCanvas {
        position: absolute;
        left: 0;
        right: 0;
        border: none;
        color: #FFF;
        overflow: hidden;
        background-color: transparent;
        /*display: none;*/

    }

    #tempCanvas {
        position: absolute;
        left: 0;
        right: 0;
        overflow: hidden;
        border: none;
        /*display: none;*/
    }

    .kbw-signature {
        width: 100%;
        height: 82px;
    }

    #signatureCustomer canvas {
        width: 100% !important;
        height: 100%;
        /*height: auto;*/
    }
</style>

@section('content')

    <form action="{{ route('admin.jobs.addDuplicate') }}" method="post" autocomplete="off">
        @csrf
        @php

            $is_error = $errors->any() ? 1 : 0;

            $x = $is_error ? old('jewelleries') ? count(old('jewelleries')) : '1' : 1;
        @endphp

        <input type="hidden" name="item_code" value="{{$record->item_code}}"/>
        <input type="hidden" name="job_id" value="{{$record->id}}"/>
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Duplicate Jewellery <span>( Quantity: 1)</span></h4>
            </div>
            <div class="card-body">
                <div class="row">
                    {{--  <div class="col-lg-6 col-md-6 mb-4">
                        <div class="form-group cus_form_group">
                            <label  class="form-label cus_label">{{ __('content.item_code') }}</label>
                            <input type="text" class="cus_form_control" name="item_code"
                                   value="{{ old('item_code',$record->item_code) }}" readonly>
                        </div>
                    </div>  --}}
                    <div class="col-lg-6 mb-4">
                        <div class="form-group cus_form_group label_with">
                            <label  class="form-label cus_label">{{ __('content.date_created') }}</label>
                            <input type="text" name="date" class="cus_form_control datePicker"
                                   value="{{ old('date',date('d-m-Y', strtotime($record->date))) }}" readonly>
                        </div>
                        @if ($errors->has('date'))
                            <span class="error-message">
                                    <strong>{{ $errors->first('date') }}</strong>
                                </span>
                        @endif
                    </div>

                    <div class="col-lg-6 mb-4">
                        <div class="form-group cus_form_group label_with">
                            <label class="form-label cus_label">{{ __('content.estimate_completion') }}</label>
                            <input type="text" name="estimate_completion" class="cus_form_control datePicker" value="{{ old('estimate_completion', (!empty($record->estimate_completion)) ? date('d-m-Y', strtotime($record->estimate_completion)) : " ") }}" readonly>
                        </div>
                        @if ($errors->has('estimate_completion'))
                            <span class="error-message">
                                    <strong>{{ $errors->first('estimate_completion') }}</strong>
                                </span>
                        @endif
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group cus_form_group pt-2">
                            <label  class="form-label cus_label pe-5">Item Type</label>
                            <div class="form-group d-flex">
                                @php $types = \App\Models\JobType::getJobTypesList(); @endphp
                                @foreach($types as $key=>$value)
                                    <div class="form-check">
                                        <input class="form-check-input job_type jewellery_type cus-form-check-input" type="radio" name="type_id" value="{{ $key }}" {{ old('type_id',$record->job_type_id) == $key ? "checked": " "}} id="type_id-{{$key}}">
                                        <label class="form-check-label cus_form_check_label" for="type_id-{{$key}}">
                                            {{ __('content.'.trim(lcfirst($value))) }}
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">Details</h4>
            </div>
            <div class="card-body">
                <div class="row">

                    <div class="col-lg-12">
                        <div class="category jobs_edit">
                            <div class="form-group">
                                <label  class="form-label">Category</label>
                            </div>
                            <ul class="">
                                @php $categories = \App\Models\Category::getCategories(); @endphp
                                @foreach($categories as $key=>$value)
                                    <li class="{{ old('category_id',$record->category_id) == $value->id   ?  "active_category" : "" }}">
                                        <a class="category_id" data-id="{{ $value->id }}"><img src="{{ $value->image }}" height="60" width="60"/>{{ __('sidebar.'.strtolower($value->name)) }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                            <input id="category_id" type="hidden" name="category_id"
                                   value="{{ old('category_id', $record->category_id) }}"/>
                            @if ($errors->has('category_id'))
                                <span class="error-message">
                                   <strong>{{ $errors->first('category_id') }}</strong>
                                </span>
                            @endif
                        </div>

                    </div>

                    <div class="col-lg-6 repair_hide">
                        <div class="form-group">
                            <label  class="form-label">{{ __('content.gold_colour') }}</label>
                            <select class="form-select" name="gold_color_id" aria-label="Default select example">
                                <option value=" ">Select One Option</option>
                                @php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); @endphp
                                @foreach($gold_colors as $key=>$value)
                                    <option value="{{ $key }}" {{ old('gold_color_id',$record->gold_color_id) ==  $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                        @if ($errors->has('gold_color_id'))
                            <span class="error-message">
                                <strong>{{ $errors->first('gold_color_id') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="col-lg-6 repair_hide">
                        <div class="form-group">
                            <label  class="form-label">{{ __('content.size') }}</label>
                            <input type="text" name="size" class="form-control" value="{{ old('size',isset($record->size) ? (float)$record->size: "" ) }}">
                        </div>
                        @if ($errors->has('size'))
                            <span class="error-message">
                                <strong>{{ $errors->first('size') }}</strong>
                            </span>
                        @endif
                    </div>

                    <div class="col-lg-12">
                        <div class="form-group">
                            <label class="form-label">{{ __('content.description') }}</label>
                            <textarea class="form-control" name="description" placeholder="Description" rows="2" value="">{{ old('description',$record->description) }}</textarea>
                            @if ($errors->has('description'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('description') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-lg-12 mt-3">
                        <label class="form-label">{{ __('content.draw_upload') }}<img src="{{ asset('public/img/folder.png') }}" class="folder"></label>
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-group pt-0">
                                    <div class="drop-zone">

                                        <div class="dropzone" id="dropZoneimageUpload">
                                            <span class="drop-zone__prompt dz-default dz-message text-start">Drop Photo here <br>{{ __('content.drop_photo_only') }}
                                            <p style="text-align: left;margin-top: 10px;">Photo Requiement:</p>
                                            <ul>
                                                <li>File type PNG or JPG</li>
                                                <li>Maximum Size: 2 MB</li>
                                            </ul>
                                                {{--<input type="file" name="file" class="fileimage drop-zone__input">--}}
                                                {{--<input type="hidden" class="imageFile" name="images[]">--}}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-8">
                                <div class="form-group pt-0">
                                    <div class="start-drawing" id="blackboardPlaceholder">
                                        <p id="drawing-place-holder">{{ __('content.start_drawing') }}</p>
                                        <canvas id="drawingCanvas" width="500" height="230"></canvas>
                                        <div class="pen-eraser">
                                            <span class="pen" onclick="togglePenPointer();"><img
                                                        src="{{ asset('public/img/pen.png') }}"/></span>
                                            <span class="erase" onclick="eraserHandler();"><img
                                                        src="{{ asset('public/img/eraser.png') }}"/></span>
                                        </div>
                                    </div>
                                    <input type="hidden" id="drawing_textarea_base64" name="drawing_textarea_base64">
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="preview-droped-images">

                                    @foreach($record->images as  $key=>$value)
                                        <div class="dz-preview dz-processing dz-image-preview dz-complete">

                                            <div class="dz-image">
                                                <img data-dz-thumbnail="" height="60" alt="bracelet.png"
                                                     src="{{ $value->image_url  }}">
                                            </div>
                                            <a class="dz-remove remove_button" href="javascript:undefined;"
                                               data-dz-remove="">X</a>
                                            <input type="hidden" value="{{ $value->image }}" name="images[]">
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="repair_hide">
                        <div class="col-lg-12">
                            <div class="sample">
                                <div class="col-lg-12">
                                    <div class="form-group d-flex align-items-center pt-0">
                                        <label  class="form-label mb-0 pe-5">{{ __('content.sample_provided') }}</label>
                                        <div class="form-check">
                                            <input class="form-check-input cus-form-check-input" type="radio"
                                                   name="is_sample_provided" id="flexRadioDefault1"
                                                   value="1" {{ old("is_sample_provided",$record->is_sample_provided) == 1 ? 'checked' : '' }} >
                                            <label class="form-check-label cus_form_check_label"
                                                   for="flexRadioDefault1">
                                                {{ __('content.yes') }}
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input cus-form-check-input" type="radio"
                                                   name="is_sample_provided"
                                                   value="0" {{ old("is_sample_provided",$record->is_sample_provided) == 0 ? 'checked' : '' }}>
                                            <label class="form-check-label cus_form_check_label"
                                                   for="flexRadioDefault1">
                                                {{ __('content.no_') }}
                                            </label>
                                        </div>
                                    </div>
                                    @if ($errors->has('is_sample_provided'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('is_sample_provided') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.sample_description') }}</label>
                                        <textarea class="form-control"  name="sample_description" placeholder="{{ __('content.description') }}" rows="2">{{ old('sample_description',$record->sample_description) }}</textarea>
                                    </div>
                                    @if ($errors->has('sample_description'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('sample_description') }}</strong>
                                </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.gold_weight') }}</label>
                                        <input type="text" class="form-control" name="gold_weight" value="{{ old('gold_weight',isset($record->gold_weight)? (float)$record->gold_weight :"") }}">
                                    </div>
                                    @if ($errors->has('gold_weight'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('gold_weight') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.gold_cost') }}</label>
                                        <input type="text" class="form-control" name="gold_cost" value="{{ old('gold_cost',isset($record->gold_cost)? (float)$record->gold_cost :"") }}">
                                    </div>
                                    @if ($errors->has('gold_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('gold_cost') }}</strong>
                                </span>
                                    @endif
                                </div>

                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.workmanship_cost') }}</label>
                                        <input type="text" class="form-control" name="workmanship_cost" value="{{ old('workmanship_cost',isset($record->craftsmanship_cost)? (float)$record->craftsmanship_cost :"") }}">
                                    </div>
                                    @if ($errors->has('workmanship_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('workmanship_cost') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.polishing_cost') }}</label>
                                        <input type="text" class="form-control" name="pollising_cost" value="{{ old('pollising_cost',isset($record->polishing)? (float)$record->polishing :"") }}">
                                    </div>
                                    @if ($errors->has('pollising_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('pollising_cost') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('content.setting_cost') }}</label>
                                        <input type="text" class="form-control" name="setting_cost" value="{{ old('setting_cost',isset($record->setting_cost)? (float)$record->setting_cost :"") }}">
                                    </div>
                                    @if ($errors->has('setting_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('setting_cost') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.earing_pin') }}</label>
                                        <input type="text" class="form-control" name="earing_pin" value="{{ old('earing_pin',isset($record->earing_pin) ? (float)$record->earing_pin : " ") }}">
                                    </div>
                                    @if ($errors->has('earing_pin'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('earing_pin') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_type') }}</label>
                                        <select class="form-select" aria-label="Default select example"
                                                name="backing_type">
                                            <option value=" ">Select One Option</option>
                                            @php $backing_types = \App\Models\Jewellery::backingTypeArray(); @endphp
                                            @foreach($backing_types as $key=>$value)
                                                <option value="{{ $key }}" {{ old('backing_type',$record->backing_type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if ($errors->has('backing_type'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_type') }}</strong>
                                </span>
                                    @endif
                                </div>

                                <div class="col-lg-6 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_cost') }}</label>
                                        <input type="text" class="form-control" name="backing_cost" value="{{ old('backing_cost',isset($record->backing_cost) ? (float)$record->backing_cost : "") }}">
                                    </div>
                                    @if ($errors->has('backing_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_cost') }}</strong>
                                </span>
                                    @endif
                                </div>

                                <div class="col-lg-3 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_size') }}</label>
                                        <input type="text" class="form-control"  name="backing_size" value="{{ old('backing_size',isset($record->backing_size) ? (float)$record->backing_size : "") }}">
                                    </div>
                                    @if ($errors->has('backing_size'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_size') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-3 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_quantity') }}</label>
                                        <input type="text" class="form-control" name="backing_quantity" value="{{ old('backing_quantity',isset($record->backing_quantity) ? (float)$record->backing_quantity : "") }}">
                                    </div>
                                    @if ($errors->has('backing_quantity'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_quantity') }}</strong>
                                </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.claw') }}</label>
                                        <select class="form-select" aria-label="Default select example" name="claw">
                                            <option value=" ">Select One Option</option>
                                            @php $claw = \App\Models\Jewellery::clawArray(); @endphp
                                            @foreach($claw as $key=>$value)
                                                <option value="{{ $key }}" {{ old('claw',$record->claw) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if ($errors->has('claw'))
                                        <span class="error-message"><strong>{{ $errors->first('claw') }}</strong></span>
                                    @endif
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">Worksmith</label>
                                        @php $worksmiths = \App\Models\Worksmith::getWorksmithsList();@endphp
                                        <select class="form-select" aria-label="Default select example" name="worksmith_id">
                                            <option value=" ">Select One Option</option>
                                            @foreach($worksmiths as $key=>$value)
                                                <option value="{{ $key }}" {{ old('worksmith_id',$record->worksmith_id) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if ($errors->has('worksmith_id'))
                                        <span class="error-message"><strong>{{ $errors->first('worksmith_id') }}</strong></span>
                                    @endif
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="sample">
                        <div class="row">

                            @if(old('jewelleries',!empty($record->loose_pieces->toArray())))

                                @php
                                    $oldJewelleries = old('jewelleries',@$record->loose_pieces->toArray());
                                    $oldCount = count($oldJewelleries);
                                @endphp
                                @foreach(old('jewelleries',@$record->loose_pieces->toArray()) as $key => $value)
                                    @php $x=$key+1; @endphp
                                    <div class="row indexes" id="row{{$key}}">
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label  class="form-label">{{ __('content.item_code') }}</label>
                                                <input type="text" class="form-control jewellery_item_code" id="jewelleries-{{$key}}-stock_no" data-id="{{$key}}" name="jewelleries[{{$key}}][stock_no]" value="{{ old('jewelleries.'.$key.'.stock_no',@$value['stock_no']) }}">
                                            </div>
                                            @if ($errors->has('jewelleries.'.$key.'.stock_no'))
                                                <span class="error-message">
                                                    <strong>{{ $errors->first('jewelleries.'.$key.'.stock_no') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label  class="form-label">{{ __('content.weight') }}</label>
                                                <input type="text" class="form-control" data-id="{{$key}}" id="jewelleries-{{$key}}-weight" name="jewelleries[{{$key}}][weight]" value="{{ old('jewelleries.'.$key.'.weight',isset($value['weight']) ? (float)$value['weight'] : "") }}" oninput="onInputweight()">
                                            </div>
                                            @if ($errors->has('jewelleries.'.$key.'.weight'))
                                                <span class="error-message">
                                                    <strong>{{ $errors->first('jewelleries.'.$key.'.weight') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label  class="form-label">{{ __('content.unit_price') }}</label>
                                                <input type="text" class="form-control" data-id="{{$key}}" id="jewelleries-{{$key}}-unit_price"  name="jewelleries[{{$key}}][unit_price]" value="{{ old('jewelleries.'.$key.'.unit_price',isset($value['unit_price']) ? (float)$value['unit_price'] : "") }}" oninput="onInputUnitPrice()">
                                            </div>
                                            @if ($errors->has('jewelleries.'.$key.'.unit_price'))
                                                <span class="error-message">
                                                    <strong>{{ $errors->first('jewelleries.'.$key.'.unit_price') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group pt-0">
                                                <label  class="form-label">{{ __('content.price') }}</label>
                                                <input type="text" class="form-control price-{{ $key }}" name="jewelleries[{{ $key }}][price]" id="jewelleries-{{$key}}-price"  value="{{ old('jewelleries.'.$key.'.price',isset($value['price']) ? (float)$value['price'] : "" ) }}" >
                                            </div>
                                            @if ($errors->has('jewelleries.'.$key.'.price'))
                                                <span class="error-message">
                                                    <strong>{{ $errors->first('jewelleries.'.$key.'.price') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        @if($key>0)
                                            <div class="col-lg-1">
                                                <button type="button" name="remove" id="{{ $key }}"
                                                        class="btn btn-danger plus_btn_remove">X
                                                </button>
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            @else
                                <div class="col-lg-3">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.item_code') }}</label>
                                        <input type="text" class="form-control jewellery_item_code" id="jewelleries-0-stock_no" data-id="0"  name="jewelleries[0][stock_no]" value="{{ old('jewelleries.0.stock_no') }}">
                                    </div>
                                    @if ($errors->has('jewelleries.0.stock_no'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('jewelleries.0.stock_no') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.weight') }}</label>
                                        <input type="text" class="form-control" data-id="0" name="jewelleries[0][weight]" id="jewelleries-0-weight" value="{{ old('jewelleries.0.weight') }}" oninput="onInputweight()">
                                    </div>
                                    @if ($errors->has('jewelleries.0.weight'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('jewelleries.0.weight') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.unit_price') }}</label>
                                        <input type="text" class="form-control" data-id="0" name="jewelleries[0][unit_price]"  id="jewelleries-0-unit_price" value="{{ old('jewelleries.0.unit_price') }}" oninput="onInputUnitPrice()">
                                    </div>
                                    @if ($errors->has('jewelleries.0.unit_price'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('jewelleries.0.unit_price') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-2">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.price') }}</label>
                                        <input type="text" class="form-control price-0" name="jewelleries[0][price]" id="jewelleries-0-price" value="{{ old('jewelleries.0.price') }} ">
                                    </div>
                                    @if ($errors->has('jewelleries.0.price'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('jewelleries.0.price') }}</strong>
                                </span>
                                    @endif
                                </div>
                            @endif
                            <div id="append_fields">

                            </div>
                            <div class="col-lg-12">
                                <div class="form-group plus pt-0">
                                    <a id="addPlus"><i class="icofont-plus"></i></a>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="sample">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group pt-0">
                                    <label  class="form-label">{{ __('content.handle_by') }}</label>
                                    @php $handledBy = \App\Models\Admin::handleBYArray();@endphp
                                    <select class="form-select" aria-label="Default select example" name="staff_id">
                                        <option value="">Select One Option</option>
                                        @foreach($handledBy as $key=>$value)
                                            <option value="{{ $value->id }}" {{ old('staff_id',$record->staff_id) == $value->id ? 'selected' : '' }}>{{ ucwords($value->fullname) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @if ($errors->has('staff_id'))
                                    <span class="error-message">
                                    <strong>{{ $errors->first('staff_id') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group pt-0 position-relative">
                                    <label  class="form-label">{{ __('content.customer_phone_no') }}</label>
                                    <div class="search">
                                        <img src="{{ asset('public/img/search.png') }}"/>
                                        <input type="text" class="form-control" id="customer_phone"
                                               placeholder="Enter or Search Phone Number" name="customer_phone"
                                               value="{{ old('customer_phone',@$record->customer->country_code." ".@$record->customer->phone) }}">
                                    </div>
                                    @if ($errors->has('customer_phone'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('customer_phone') }}</strong>
                                </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label  class="form-label">{{ __('content.customer_name') }}</label>
                                    <input type="text" class="form-control" name="customer_name" value="{{ old('customer_name',@$record->customer->fullname) }}">
                                </div>
                                @if ($errors->has('customer_name'))
                                    <span class="error-message">
                                    <strong>{{ $errors->first('customer_name') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label  class="form-label">{{ __('content.customer_email') }}</label>
                                    <input type="text" class="form-control" name="customer_email" value="{{ old('customer_email',@$record->customer->email) }}">
                                </div>
                                @if ($errors->has('customer_email'))
                                    <span class="error-message">
                                    <strong>{{ $errors->first('customer_email') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="sample repair_show">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group pt-0">
                                    <label  class="form-label">Customer Signature</label>
                                    <div id="signatureCustomer"></div>
                                    <textarea id="signature164" class="form-control signature" name="customer_signature"
                                              style="display: none" rows="2"></textarea>
                                    <div class="buttons buttons_1 sale-sig mt-2">
                                        <span id="customer_signature_clear" class="btn btn-primary btn-create"
                                              type="submit">CLEAR</span>
                                    </div>
                                </div>
                                @if ($errors->has('customer_signature'))
                                    <span class="error-message">
                                    <strong>{{ $errors->first('customer_signature') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group pt-0">
                                    <label  class="form-label">Sales Representative
                                        Signature</label>
                                    <div id="signatureSaleRepresentive"></div>
                                    <textarea id="sale_representive_signature_64" class="form-control signature"
                                              name="sales_representative_signature" style="display: none"
                                              rows="2"></textarea>
                                    <div class="buttons buttons_1 sale-sig mt-2">
                                        <span id="sale_signature_clear" class="btn btn-primary btn-create"
                                              type="submit">CLEAR</span>
                                    </div>
                                </div>
                                @if ($errors->has('sales_representative_signature'))
                                    <span class="error-message">
                                    <strong>{{ $errors->first('sales_representative_signature') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons">
                    <button class="btn btn-primary btn-create" type="submit">Duplicate</button>
                    <a href="{{ route('admin.jobs.index') }}" class="btn btn-primary btn-reset-form w-auto ps-3 pe-3"
                       type="button">Cancel {{-- __('content.reset_form') --}}</a>
                </div>
                <div class="col-lg-5 note pt-2">
                    {{--<p>Note:--}}
                    {{--<span class="d-block">Upon creating a jewellery successfully, a job order for a worksmith will be automatically created. Go to Job Order to assign a worksmith to the newly job order.</span>--}}
                    {{--</p>--}}
                </div>
            </div>
        </div>
    </form>
    @include('admin.elements.scripts.jewellery_itemcode_autocomplete_js')
    @include('admin.jewelleries.script')
@endsection
