@extends('layouts.admin.default')

@section('title',"Jobs Dashboard")

@section('header', "Jobs Dashboard")
@section('content')


<div class="card mb-4">
	<div class="card-header Job-dash">
		<h4 class="mb-0">Job Dashboard</h4>
		<p>This section shows an overview of the job orders in Sancy ERP system. The numbers are refreshed monthly.</p>
	</div>
</div>

<div class="card mb-4 report">
	<div class="row">
		<div class="col-lg-3 col-md-3 mb-4">
			<div class="form-group custom-form-group">
				<div class="d-flex align-items-center justify-content-between detailing">
					<label for="exampleFormControlInput1" class="form-label cus_label">Total Jobs</label>
					<a href="javascript:void(0);" class="{{ (calculateJobReportVariation('total') < 0) ? 'text-red' : '' }}"><img src="{{ (calculateJobReportVariation('total') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png') }}" />
						{{ (calculateJobReportVariation('total') >= 0) ? '+'.calculateJobReportVariation('total') : calculateJobReportVariation('total') }}%
					</a>
				</div>
				<h4>{{ getMonthlyTotalJobsCount() }}</h4>
				<button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.jobs.exportTotal') }}" data-heading="All Jobs">Report</button>
				<!-- <a href="export-csv" target="_blank" class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal">Report</a> -->
			</div>
		</div>
		<div class="col-lg-3 col-md-3 mb-4">
			<div class="form-group custom-form-group">
				<div class="d-flex align-items-center justify-content-between detailing">
					<label for="exampleFormControlInput1" class="form-label cus_label">Bespoke Jobs</label>
					<a href="javascript:void(0);" class="{{ (calculateJobReportVariation('bespoke') < 0) ? 'text-red' : '' }}"><img src="{{ (calculateJobReportVariation('bespoke') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png') }}" />
						{{ (calculateJobReportVariation('bespoke') >= 0) ? '+'.calculateJobReportVariation('bespoke') : calculateJobReportVariation('bespoke') }}%
					</a>
				</div>
				<h4>{{ getMonthlyBespokeJobsCount() }}</h4>
				<!-- <button class="btn cus_btn">Report</button> -->
				<button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.jobs.exportBespoke') }}" data-heading="Bespoke Jobs">Report</button>
			</div>
		</div>
		<div class="col-lg-3 col-md-3 mb-4">
			<div class="form-group custom-form-group">
				<div class="d-flex align-items-center justify-content-between detailing">
					<label for="exampleFormControlInput1" class="form-label cus_label">Repair Job</label>
					<a href="javascript:void(0);" class="{{ (calculateJobReportVariation('repair') < 0) ? 'text-red' : '' }}"><img src="{{ (calculateJobReportVariation('repair') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png') }}" />
						{{ (calculateJobReportVariation('repair') >= 0) ? '+'.calculateJobReportVariation('repair') : calculateJobReportVariation('repair') }}%
					</a>
				</div>
				<h4>{{ getMonthlyRepairJobsCount() }}</h4>
				<button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.jobs.exportRepair') }}" data-heading="Repair Jobs">Report</button>
			</div>
		</div>
		<div class="col-lg-3 col-md-3 mb-4">
			<div class="form-group custom-form-group">
				<div class="d-flex align-items-center justify-content-between detailing">
					<label for="exampleFormControlInput1" class="form-label cus_label">Delayed Job</label>
					<a href="javascript:void(0);" class="{{ (calculateJobReportVariation('delayed') < 0) ? 'text-red' : '' }}"><img src="{{ (calculateJobReportVariation('delayed') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png') }}" />
						{{ (calculateJobReportVariation('delayed') >= 0) ? '+'.calculateJobReportVariation('delayed') : calculateJobReportVariation('delayed') }}%
					</a>
				</div>
				<h4>{{ getMonthlyDelayedJobsCount() }}</h4>
				<button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.jobs.exportDelayed') }}" data-heading="Delayed Jobs">Report</button>
			</div>
		</div>

	</div>
</div>

<div class="card details mb-4 report">
	<div class="row">
		<div class="col-lg-6">
			<div class="Updating">
				<h3>Job Status Breakdown</h3>
				<div class="job-status pie_chart d-flex align-items-center">
					<div id="legend" class="chart_desc" style="width:250px;"></div>
					<div id="pieChartContainer" style="height: 160px;">
						<!-- <img src="{{-- asset('public/img/Pie Chart.png') --}}" class="w-100" /> -->
					</div>
				</div>
			</div>
		</div>
		<div class="col-lg-3">
			<div class="Updating">
				<h3>Worksmith</h3>
				@if(count($worksmiths))
				<div class="job-status work-with">
					<ul>
						@foreach($worksmiths as $key=>$worksmith)
						<li class="list-unstyled">
							<div class="d-flex align-items-center justify-content-between">
								<div class="color_code">
									<a href="javascript:void(0);" class="">
										<img src="{{ $worksmith->thumbImageUrl }}" style="width: 32px; height: 32px; object-fit: cover;">
									</a> {{ ucwords($worksmith->fullname) }}
								</div>
								<div class="persentage">
									{{ $worksmith->worksmith_job_count }}
								</div>
								<div class="persentage">
									Jobs
								</div>
							</div>
						</li>
						@endforeach
					</ul>
				</div>
				@else
				<p>No record found!</p>
				@endif
			</div>
		</div>
		<div class="col-lg-3">
			<div class="Updating">
				<h3>Recent Update</h3>
				@if(count($recentUpdates))
				<div class="d-flex job-status work-with justify-content-between">
					<ul class="update">
						@foreach($recentUpdates as $key=>$recentUpdate)
						<li class="list-unstyled d-flex align-items-start">
							<div class="number"><em></em></div>
							<div>
								<h4>{{ date('d/m/Y', strtotime($recentUpdate->created_at)) }}</h4>
								<p>{{ $recentUpdate->item_code }} is {{  (date('Y-m-d', strtotime($recentUpdate->created_at)) ==  date('Y-m-d', strtotime($recentUpdate->updated_at)) && empty($recentUpdate->worksmith_id)) ? 'created' : $recentUpdate->job_status }}</p>
							</div>
						</li>
						@endforeach
					</ul>
				</div>
				@else
				<p>No record found!</p>
				@endif
			</div>
		</div>
	</div>
</div>

<div class="cardnew">
	<div class="bg-white job_oder_main card-custom-body p-4">
		<h2 class="h2_title">Calendar</h2>
		<div class="bg-white job_oder_main mt-3">
			<div class="row">
			    <div class="col-md-3 pe-0">
				    <div class="job_order">
				    	<p>Job Order <span id="jobCount"></span></p> <!-- Total: 4 -->
				    	<div id="legendDiv" class="myCalenderDiv" style="padding-top:40px !important;">
				    	</div>
				    </div>
				</div>
			    <div class="col-md-9 ps-0"  >
			    	<!-- <div id="blankDiv" class="blank_div"></div> -->
			    	<div id="chartContainer" class="myCalenderDiv" ></div>  <!-- style="min-height:300px;" style="min-height:1440px;" -->
			    </div>
			</div>
		</div>
	</div>
</div>

@include('admin.elements.exports.common_report_modal')

@include('admin.elements.exports.common_reports_script')

<!-- <div class="d-flex justify-content-start mt-4" style="border:2px solid red;width:100%; height:300px;background:#fff;">
	<div class="col-md-3" id="legendDiv" style="height:10px;max-width:100%; margin-left:15px;">
	</div>
	<div class="col-md-9" id="chartContainer" style="border:2px solid orange;background:#fff;"></div>
</div> -->


<!-- google chart -->
<!-- <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script> -->


<!-- amchart -->
<script src="https://cdn.amcharts.com/lib/4/core.js"></script>
<script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
<script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
<script src="https://www.amcharts.com/lib/4/themes/amcharts.js"></script>


@include('admin.jobs.dashboard.pie_chart_script')
@include('admin.jobs.dashboard.calender_view_script')

@endsection

