<script>
$(document).ready(function(){

  	//---------------------- Floating Chart starts here -----------------------
  		 
  		var timeLineData = {!! json_encode($jobsList) !!};
  		// console.log('timeLineData : '+JSON.stringify(timeLineData)); 

  		const timeColorsArr = ['#cbd5e1', '#3F4254', '#e4a061', '#3CC13B', '#37b981', '#f77171'];

		const timeColorsObj = {'Not Assigned':'#cbd5e1', 'Not Started':'#3F4254', 'Crafting':'#e4a061', 'Completed':'#3CC13B', 'Received':'#37b981', 'Delayed':'#f77171'};


	  	// https://www.amcharts.com/docs/v4/tutorials/freeze-horizontal-axis/
	  	am4core.ready(function() {
			am4core.useTheme(am4themes_animated);
			// https://www.amcharts.com/docs/v4/tutorials/chart-was-not-disposed/
			am4core.options.autoDispose = true;

			var timeLineChart = am4core.create("timelineChartContainer", am4charts.XYChart);
			timeLineChart.colors.saturation = 0.4;

			// Add data
			// timeLineChart.data = timeLineData;
			timeLineChart.data = timeLineData.set1;
			// console.log('timeLineData set1 : '+JSON.stringify(timeLineData.set1));
			// console.log('timeLineData set2 : '+JSON.stringify(timeLineData.set2));
			// console.log('timeLineData set3 : '+JSON.stringify(timeLineData.set3));
			// console.log('timeLineData set4 : '+JSON.stringify(timeLineData.set4)); 
			// console.log('timeLineData set5 : '+JSON.stringify(timeLineData.set5));


			var categoryAxis = timeLineChart.yAxes.push(new am4charts.CategoryAxis());
			categoryAxis.renderer.grid.template.location = 0; // 0 to 1., 0-> start of the cell, 1 -> end of the cell.
			categoryAxis.dataFields.category = "worksmithName";
			categoryAxis.renderer.inversed = true;
			// https://codepen.io/team/amcharts/pen/KLYrww
  			categoryAxis.renderer.grid.template.disabled = true; // Disable the horizontal axis lines
			categoryAxis.renderer.minGridDistance = 2;
			categoryAxis.renderer.labels.template.horizontalCenter = "right";
			categoryAxis.renderer.labels.template.verticalCenter = "middle";
			categoryAxis.renderer.minWidth = 35;
			categoryAxis.renderer.minHeight = 35;
			// categoryAxis.renderer.labels.template.rotation = 270;
			// categoryAxis.renderer.grid.template.disabled = true;
			categoryAxis.tooltip.disabled = true;
			// categoryAxis.tooltip.getFillFromObject = false;
			// categoryAxis.tooltip.background.fill = am4core.color("#fff");
			// categoryAxis.tooltip.label.fill = am4core.color("color");
			categoryAxis.renderer.baseGrid.disabled = true;
			categoryAxis.renderer.labels.truncate = true;
			// categoryAxis.disabled = true;

			// Disable Category Axis Label
			categoryAxis.renderer.labels.template.disabled = true; 


			// // Add events
			// categoryAxis.renderer.labels.template.events.on("hit", highlighColumn);
			// categoryAxis.renderer.labels.template.cursorOverStyle = am4core.MouseCursorStyle.pointer;


			// ------------------------------- Image ----------------------------
			// https://www.amcharts.com/docs/v4/concepts/legend/
			/* Create legend and enable default markers */
			timeLineChart.legend = new am4charts.Legend();
			timeLineChart.legend.useDefaultMarker = true;
			timeLineChart.legend.reverseOrder = true;
			// timeLineChart.LegendPosition = "top";
			// timeLineChart.legend.labels.template.truncate = true;

			// timeLineSeries.legendSettings.labelText="";
			// timeLineChart.legend.labels.template.text = ""; // Series: [bold {color}]{name}[/]
			


			/* Create a separate container to put legend in */
			var legendContainer = am4core.create("legendDiv", am4core.Container);
			legendContainer.width = am4core.percent(40);
			legendContainer.height = am4core.percent(50);
			timeLineChart.legend.parent = legendContainer;


			/* Remove square from marker template */
			var marker = timeLineChart.legend.markers.template;
			marker.disposeChildren();
			marker.width = 24;
			marker.height = 24;


			/* Add custom image instead */
			// let dollar = marker.createChild(am4core.Image);
			// dollar.width = 24;
			// dollar.height = 20;
			// dollar.verticalCenter = "top";
			// dollar.horizontalCenter = "left";
			// dollar.href = "{{ asset('public/img/default-placeholder.jpg') }}";

			// var workSmithImage = marker.createChild(am4core.Image);
			// workSmithImage.width = 50;
			// workSmithImage.height = 50;
			// workSmithImage.verticalCenter = "top";
			// workSmithImage.horizontalCenter = "left";
			// workSmithImage.adapter.add("href", function(href, target) {
			//   if (target.dataItem && target.dataItem.dataContext && target.dataItem.dataContext.dummyData) {
			//     return target.dataItem.dataContext.dummyData.workSmithImage;
			//   }
			//   else {
			//     return href;
			//   }
			// });
			//-----------------------------------------------

			// var valueAxis = timeLineChart.xAxes.push(new am4charts.ValueAxis()); 
			// valueAxis.renderer.maxLabelPosition = 0.98; 

			const weekday = ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
			// let day = weekday[e];

			var dateAxis = timeLineChart.xAxes.push(new am4charts.DateAxis());
			dateAxis.renderer.minGridDistance = 30;
			dateAxis.renderer.grid.template.location = 0.0001;  // To make DateAxis distinguish from user-set zero from default zero, set it to a value that is very close to zero, say, 0.0001

			// dateAxis.startLocation = 0.5; //minimize stroke verical gap
			// dateAxis.endLocation = 0.5;//minimize stroke verical gap
			// https://www.amcharts.com/docs/v4/concepts/formatters/formatting-date-time/
			dateAxis.dateFormats.setKey("day", "[bold]eee \ndd");
			// dateAxis.periodChangeDateFormats.setKey("day", "[bold]MMM");

			dateAxis.renderer.minLabelPosition = 0; // 0.05;
			dateAxis.renderer.maxLabelPosition = 1; // 0.95;

			dateAxis.renderer.inside = false; 
			dateAxis.renderer.labels.template.horizontalCenter = "middle";
			dateAxis.renderer.labels.template.verticalCenter = "middle";
			dateAxis.tooltip.disabled = true;

			dateAxis.renderer.labels.template.fontWeight = "bold"; //font weight
			dateAxis.renderer.labels.template.fontSize = 12; //font size
			dateAxis.renderer.ticks.template.length = 14; // No. of ticks

			// dateAxis.renderer.grid.template.strokeWidth = 35;
			dateAxis.renderer.grid.template.stroke = am4core.color("light grey");
			dateAxis.renderer.grid.template.stroke.fill = '#fff';
			// dateAxis.renderer.grid.template.minWidth = 20;
			// dateAxis.renderer.grid.template.maxHeight = 20;




			var timeLineSeries = timeLineChart.series.push(new am4charts.ColumnSeries());
			timeLineSeries.dataFields.categoryY = "worksmithName";
			timeLineSeries.dataFields.dateX = "endDateTime";
			timeLineSeries.dataFields.openDateX = "startDateTime";
			timeLineSeries.columns.template.strokeWidth = 2;
			timeLineSeries.columns.template.column.fillOpacity = 0.9;
			timeLineSeries.columns.template.column.propertyFields.fill = "color"; 
			// timeLineSeries.columns.template.column.propertyFields.stroke = am4core.color("color");
			timeLineSeries.columns.template.column.propertyFields.stroke ="color";
			// timeLineSeries.stacked = true;

			// Background Color Gradient
			var fillModifier = new am4core.LinearGradientModifier();
			fillModifier.brightnesses = [1, 1, 0, 0]; // [0, 1, 1, 0]
			// fillModifier.brightnesses.push(-0.8, -0.8, -0.5, 0, - 0.5);
			fillModifier.opacities = [1, 0];
			fillModifier.offsets = [0, 1];
			fillModifier.gradient.rotation = 90;
			timeLineSeries.columns.template.column.fillModifier = fillModifier;
			// timeLineSeries.columns.template.column.strokeModifier = fillModifier;
			timeLineSeries.columns.template.column.strokeOpacity = 0.9;


			// Rounded borders
			timeLineSeries.columns.template.column.cornerRadiusTopLeft = 10;
			timeLineSeries.columns.template.column.cornerRadiusTopRight = 10;
			timeLineSeries.columns.template.column.cornerRadiusBottomLeft = 10;
			timeLineSeries.columns.template.column.cornerRadiusBottomRight = 10;


			// Create a range
			var range = dateAxis.createSeriesRange(timeLineSeries);
			range.date = new Date(2022, 7, 25);
			range.endDate = new Date(2022, 8, 20)


			// Data set
			// https://codepen.io/team/amcharts/pen/XOPoMN
			$('#dataSetSelect').on('change', function(){
				var selectedSet = $(this).val();
				// console.log('selectedSet Data ARRAY: '+JSON.stringify(timeLineData[selectedSet]));
				timeLineChart.data = timeLineData[selectedSet];
			});

			// // Add hit event to pull out slice on click
			// timeLineChart.legend.itemContainers.template.events.on("hit", function(ev) {
			// 	alert('hit');
			//   var seriesColumn = ev.target.dataItem.dataContext.columns.template;
			//   seriesColumn.isActive = !seriesColumn.isActive;
			// });



			// var timeLineHS = timeLineSeries.columns.template.states.create("active");
			// timeLineHS.properties.fillOpacity = 1;
			// timeLineHS.propertyFields.fill = "#37b981"; 
			// timeLineSeries.propertyFields.stroke = am4core.color("#37b981");
			// // timeLineHS.propertyFields.fill = "#f77171";
			// // timeLineHS.propertyFields.stroke = am4core.color("#f77171");
			// timeLineSeries.columns.template.events.on("hit", highlighColumn);

			// // https://codepen.io/team/amcharts/pen/KjjPzP
			// function highlighColumn(ev) {
			// 	alert('highlight');
			//     timeLineChart.series.each(function(series) {
			// 	    if (series instanceof am4charts.ColumnSeries) {
			// 	        series.columns.each(function(column) {
			// 		        if (column.dataItem.categoryX == ev.target.dataItem.category) {
			// 		            column.isActive = true;
			// 		        }else {
			// 		            column.isActive = false;
			// 		        }
			// 	        })
			// 	    }
			//     })
			// }


			// Set up tooltip
			timeLineSeries.columns.template.tooltipText = "{worksmithName}: {openDateX} - {dateX}";
			timeLineSeries.columns.template.showTooltipOn = "hit"; //  "hit", "always" "hover"
			timeLineSeries.tooltip.getFillFromObject = false;
			timeLineSeries.tooltip.label.propertyFields.fill = "color";
			timeLineSeries.tooltip.background.propertyFields.stroke = "color";
			timeLineSeries.tooltip.pointerOrientation = "down";
			// timeLineSeries.fillOpacity = 1;

			// // as by default columns of the same series are of the same color, we add adapter which takes colors from chart.colors color set
			// timeLineSeries.columns.template.adapter.add("fill", (fill, target) => {
			//   return target.dataItem ? timeLineChart.colors.getIndex(target.dataItem.index) : fill;
			// });

			// var fillModifier = new am4core.LinearGradientModifier();
			// fillModifier.brightnesses = [0, 1, 1, 0];
			// fillModifier.offsets = [0, 0.45, 0.55, 1];
			// fillModifier.gradient.rotation = 90;
			// series.columns.template.fillModifier = fillModifier;






			// Create custom legend
			timeLineChart.events.on("ready", function(event) {
			  // populate our custom legend when chart renders
			  timeLineChart.customLegend = document.getElementById('legendDiv');
			  	var legendArr = [];
			    timeLineSeries.dataItems.each(function(row, i) {
			    	var timeColor = '#fff';
				    // var timeColor =  row._dataContext.color;  //actual

				    if(!legendArr.includes(timeLineChart.data[i]['worksmithId'])){
				    	// console.log(legendArr.includes(timeLineChart.data[i]['worksmithId']));
					    legendArr.push(timeLineChart.data[i]['worksmithId']);

					    // timeColorsObj[row._dataContext.jobStatus];  
					    // timeColorsArr[i];
					    // console.log(timeColor);
					    // console.log(row._dataContext.jobStatus);
					    // var value = row.value;
					    
					    legendDiv.innerHTML += `
					      <div id="time-legend-item-${i}" class="row time-legend-item" style="background-color:${timeColor};">
					      	<div class="col-md-3 time-legend-marker">
					      		<img src="${timeLineChart.data[i]['image']}" class="mt-2 mb-2" width="30" height="30" />
					      	</div>
					      	<div class="col-md-9 time-legend-marker">
					      		<div class="time-legend-value">${timeLineChart.data[i]['jobDesc']}</div>
					      		<div class="time-legend-value">${timeLineChart.data[i]['worksmithName']}</div>
					      	</div>
					      </div>
					    `;
					}
					
				});

			});



			
			//----------------------------------------------------------------------

		}); // end am4core.ready()

		
    
});
</script>