<script>
// Themes
am4core.useTheme(am4themes_animated);
// https://www.amcharts.com/docs/v4/tutorials/chart-was-not-disposed/
am4core.options.autoDispose = true;
// Create chart instance
var chart = am4core.create("chartContainer", am4charts.XYChart);
// Set input format for the dates
chart.dateFormatter.inputDateFormat = "yyyy-MM-dd";

// var timeLineData = {{-- {!! json_encode($jobsList) !!} --}};



var data = {!! json_encode($newJobsList) !!};
console.log(data);
// console.log('timeLineData : '+JSON.stringify(timeLineData));

var firstYear;
var firstMonth;
var lastYear;
var lastMonth;
var currentYear;
var currentMonth;
function getMonthData() {
	var monthData = [];
	for(var i = 0; i < data.length; i++) {
	    var startDateTime = chart.dateFormatter.parse(data[i].startDateTime);
	    var y = startDateTime.getFullYear();
	    var m = startDateTime.getMonth();
	    lastYear = y;
	    lastMonth = m;
	    if (!currentYear  ) {
	        currentYear = y;
	        currentMonth = m;
	        firstYear = y;
	        firstMonth = m;
	    }

	    if (currentYear == y && currentMonth == m) {
	        monthData.push(data[i]);
	    }
	}
	title.text = chart.dateFormatter.format(new Date(currentYear, currentMonth, 1), "MMMM yy"); // MMMM yyyy
	isFirstPage();
	isLastPage();
	isLeagent(monthData);
	isChartContainer(monthData);

	return monthData;
}

function prevPage() {
    if (!isLastPage()) {
	    currentMonth--;
	    if (currentMonth < 0) {
	        currentYear--;
	        currentMonth = 11;
	    }
	    chart.data = getMonthData();
        //console.log(chart.data);
	}
}

function nextPage() {
	if (!isFirstPage()) {
	    currentMonth++;
	    if (currentMonth > 11) {
	        currentYear++;
	        currentMonth = 0;
	    }
	    chart.data = getMonthData();
	}
}

function isLeagent(monthData) {
	legendDiv.innerHTML="";

	// legendDiv.innerHTML += `<div class="job_order"><p>Job Order <span id="jobCount"></span></p><div id="legendDiv" class="myCalenderDiv" style="padding-top:100px !important;"></div></div>`;

	// console.log(monthData);
	chart.customLegend = document.getElementById('legendDiv');
	var legendArr = [];
	// series.dataItems.each(function(row, i) {
	for (var key in monthData) {
	    // console.log('date=',monthData[key].worksmithId);
	    var timeColor = 'transparent'; //#fff

		if(!legendArr.includes(monthData[key].worksmithId)){
		    legendArr.push(monthData[key].worksmithId);

		    legendDiv.innerHTML += `
		        <div id="time-legend-item-${key}" class="row time-legend-item" style="background-color:${timeColor};">
			      	<div class="col-md-3 time-legend-marker">
			      		<img src="${monthData[key].image}" class="mt-2 mb-2" width="30" height="30" />
			      	</div>
			      	<div class="col-md-9 time-legend-marker">
			      		<div class="time-legend-value">${monthData[key].jobDesc}</div>
			      		<div class="time-legend-value worksmith_name">${monthData[key].worksmithName}</div>
			      	</div>
		        </div>
		    `;
		}
	}
    if(monthData.length == 0){
        const jobCountSpan = document.getElementById('jobCount');
        jobCountSpan.innerHTML = "Total: 0";
        getMonthData();
    }
	//});


	// dateAxisDiv.innerHTML="";
	// // console.log(monthData);
	// chart.customLegend = document.getElementById('blankDiv');
	// var dateAxisArr = [];
	// // series.dataItems.each(function(row, i) {
	// for (var key in monthData) {
	//     // console.log('date=',monthData[key].worksmithId);
	//     var timeColor = '#fff';

	// 	if(!dateAxisArr.includes(monthData[key].worksmithId)){
	// 	    dateAxisArr.push(monthData[key].worksmithId);

	// 	    dateAxisDiv.innerHTML += `
	// 	        <div id="date-axis-item-${monthData[key].startDateTime}" class="row date-axis-item" style="background-color:${timeColor};">

	// 	        </div>
	// 	    `;
	// 	}
	// }
}

function isChartContainer(monthData){
	// Set the total job counts
	var jobCount = monthData.length;
	const jobCountSpan = document.getElementById('jobCount');
    jobCountSpan.innerHTML = "Total: "+jobCount;

    // Dynamically manage the height of the chart
	var uniqueObj = [...new Set(monthData.map(item => item.worksmithId))];
	var monthDataCount = uniqueObj.length;
	if(monthDataCount <= 1){
		var leftContainerHeight = monthDataCount * 170; // 170 250
	}else if((monthDataCount > 1) && monthDataCount <= 3){
		var leftContainerHeight = monthDataCount * 100; // 110 170 250
	}else{
		var leftContainerHeight = monthDataCount * 80; // 80 120
	}
	let finalHeight = leftContainerHeight+"px";
	// console.log('finalHeight : '+finalHeight);

	// document.getElementsByClassName('myCalenderDiv').style.height = leftContainerHeight;
	// var note = document.querySelector('.myCalenderDiv');
	// note.style.border = '3px solid red';
	var note = document.querySelector('#legendDiv');
	note.style.height = finalHeight;
	var no = document.querySelector('#chartContainer');
	no.style.height = finalHeight;

	// Set it on chart's container
    chart.svgContainer.htmlElement.style.height = finalHeight;

    // For More Details visit the link given below
    // https://www.amcharts.com/docs/v4/tutorials/auto-adjusting-chart-height-based-on-a-number-of-data-items/
}


function isFirstPage() {
	if ((currentYear < firstYear) || (currentMonth < firstMonth)) {
	    //prev.disabled = false;
        next.disabled = false;
	    return false;
	}else {
	    //prev.disabled = true;
        next.disabled = true;
	    return true;
	}
}

function isLastPage() {
	if ((currentYear > lastYear) || (currentMonth > lastMonth)) {
	    prev.disabled = false;
	    return false;
	}else {
	    prev.disabled = true;
	    return true;
	}
}

// Themes
am4core.useTheme(am4themes_animated);

if (chart) {
  chart.dispose();
}

// Create chart instance
var chart = am4core.create("chartContainer", am4charts.XYChart);

// Set input format for the dates
chart.dateFormatter.inputDateFormat = "yyyy-MM-dd";

// Title
var title = chart.titles.create();
title.fontSize = 30;
title.marginTop = -10; //10
title.fill = am4core.color('#475569'); // Title(Month Name) Color

// // Create axes
// var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
// var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

// // Create series
// var series = chart.series.push(new am4charts.ColumnSeries());
// series.dataFields.valueY = "worksmithName";
// series.dataFields.dateX = "startDateTime";
// series.tooltipText = "{worksmithName}"
// series.strokeWidth = 2;
// series.minBulletDistance = 15;

// // Drop-shaped tooltips
// series.tooltip.pointerOrientation = "vertical";

// // Make bullets grow on hover
// var bullet = series.bullets.push(new am4charts.CircleBullet());
// bullet.circle.strokeWidth = 2;
// bullet.circle.radius = 4;
// bullet.circle.fill = am4core.color("#fff");

// var bullethover = bullet.states.create("hover");
// bullethover.properties.scale = 1.3;

// // Make a panning cursor
// chart.cursor = new am4charts.XYCursor();
// chart.cursor.behavior = "panXY";
// chart.cursor.xAxis = dateAxis;
// chart.cursor.snapToSeries = series;


//----------------------------------------------------------------------------
chart.colors.saturation = 0.4;

var categoryAxis = chart.yAxes.push(new am4charts.CategoryAxis());
categoryAxis.renderer.grid.template.location = 0; // 0 to 1., 0-> start of the cell, 1 -> end of the cell.
categoryAxis.dataFields.category = "worksmithId";
categoryAxis.renderer.inversed = true; // Reverse the order of worksmithName
// https://codepen.io/team/amcharts/pen/KLYrww
categoryAxis.renderer.grid.template.disabled = true; // Disable the horizontal axis lines
categoryAxis.renderer.minGridDistance = 2;
categoryAxis.renderer.labels.template.horizontalCenter = "right";
categoryAxis.renderer.labels.template.verticalCenter = "middle";
categoryAxis.renderer.minWidth = 35;
categoryAxis.renderer.minHeight = 35;
categoryAxis.tooltip.disabled = true;
categoryAxis.renderer.baseGrid.disabled = true; // Disable grid line
categoryAxis.renderer.labels.truncate = true;
// Disable Category Axis Label
categoryAxis.renderer.labels.template.disabled = true;

// // Add events
// categoryAxis.renderer.labels.template.events.on("hit", highlighColumn);
// categoryAxis.renderer.labels.template.cursorOverStyle = am4core.MouseCursorStyle.pointer;


// ------------------------------- Image ----------------------------
// https://www.amcharts.com/docs/v4/concepts/legend/
/* Create legend and enable default markers */
chart.legend = new am4charts.Legend();
chart.legend.useDefaultMarker = true;
chart.legend.reverseOrder = true;
// chart.LegendPosition = "top";
// chart.legend.labels.template.truncate = true;

// series.legendSettings.labelText="";
// chart.legend.labels.template.text = ""; // Series: [bold {color}]{name}[/]


/* Create a separate container to put legend in */
var legendContainer = am4core.create("legendDiv", am4core.Container);
legendContainer.width = am4core.percent(40);
legendContainer.height = am4core.percent(50);
chart.legend.parent = legendContainer;

// /* Create a separate container to put legend in */
// var dateAxisContainer = am4core.create("dateAxisDiv", am4core.Container);
// dateAxisContainer.width = am4core.percent(60);
// dateAxisContainer.height = am4core.percent(50);
// chart.legend.parent = dateAxisContainer;


/* Remove square from marker template */
var marker = chart.legend.markers.template;
marker.disposeChildren();
marker.width = 24;
marker.height = 24;


/* Add custom image instead */
// let dollar = marker.createChild(am4core.Image);
// dollar.width = 24;
// dollar.height = 20;
// dollar.verticalCenter = "top";
// dollar.horizontalCenter = "left";
// dollar.href = "{{ asset('public/img/default-placeholder.jpg') }}";

// var workSmithImage = marker.createChild(am4core.Image);
// workSmithImage.width = 50;
// workSmithImage.height = 50;
// workSmithImage.verticalCenter = "top";
// workSmithImage.horizontalCenter = "left";
// workSmithImage.adapter.add("href", function(href, target) {
//   if (target.dataItem && target.dataItem.dataContext && target.dataItem.dataContext.dummyData) {
//     return target.dataItem.dataContext.dummyData.workSmithImage;
//   }
//   else {
//     return href;
//   }
// });
//-----------------------------------------------

const weekday = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];

var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
dateAxis.renderer.minGridDistance = 31;
dateAxis.renderer.grid.template.location = 0.0001;  // To make DateAxis distinguish from user-set zero from default zero, set it to a value that is very close to zero, say, 0.0001
dateAxis.renderer.opposite = true; // Shifts horizontal axis upward
// https://www.amcharts.com/docs/v4/concepts/formatters/formatting-date-time/
dateAxis.dateFormats.setKey("day", "[bold]eee \ndd");
// #Period change format: https://www.amcharts.com/docs/v4/concepts/axes/date-axis/
dateAxis.periodChangeDateFormats.setKey("day", "[bold]eee \ndd"); // "MMMM dt"
dateAxis.renderer.inside = false;
dateAxis.tooltip.disabled = true;
dateAxis.renderer.minLabelPosition = 0; // 0,  0.05;
dateAxis.renderer.maxLabelPosition = 1; // 1,   0.95;
dateAxis.renderer.ticks.template.length = 14; // No. of ticks(verical lines showing day)
dateAxis.renderer.labels.template.fontWeight = "bold"; //font weight
dateAxis.renderer.labels.template.fontSize = 12; //font size
dateAxis.renderer.labels.template.verticalCenter = "middle";
dateAxis.renderer.labels.template.horizontalCenter = "middle";
dateAxis.renderer.grid.template.stroke.fill = 'pink'; //'#BE1E2D';
dateAxis.renderer.grid.template.stroke = am4core.color("red"); // light grey
// dateAxis.renderer.labels.template.fill = "color";

// dateAxis.renderer.labels.template.cornerRadiusTopLeft = 4;
// dateAxis.renderer.labels.template.cornerRadiusTopRight = 6;
// dateAxis.renderer.grid.template.cornerRadiusBottomLeft = 8;
// dateAxis.renderer.grid.template.cornerRadiusBottomRight = 10;

dateAxis.renderer.labels.template.dx = 20; // 15 // slightly shift the date labels right side so as to appear in the middle of the two grid(axis) lines
// dateAxis.renderer.labels.template.properties.align = "right";

// Change date lable background to somthing like pink
// https://www.amcharts.com/docs/v4/concepts/event-listeners/
function labelOnHitFunction(ev) {
    // console.log("clicked on ", ev.target);
    ev.target.isActive = true;
    // https://www.amcharts.com/docs/v4/reference/axislabel/
    ev.target.fill  = am4core.color("#fff");
    ev.target.background.fill  = am4core.color("#BE1E2D");

    // ev.target.stroke = am4core.color("cyan");

    // ev.target.dispose(); //Disappear the label

    // var labelRect = container.createChild(am4core.Rectangle);
	// labelRect.width = am4core.percent(100);
	// labelRect.height = 100;



    // ev.target.strokeLinecap = "round";
    // ev.target.strokeLinejoin = "round";

    // ev.target.cornerRadiusTopLeft = 10;
	// ev.target.cornerRadiusTopRight = 10;
	// ev.target.cornerRadiusBottomLeft = 10;
	// ev.target.cornerRadiusBottomRight = 10;

    ev.target.preventShow = false;
}
function labelOffHitFunction(ev) {
    // console.log("clicked on ", ev.target);
    ev.target.isActive = false;
    // https://www.amcharts.com/docs/v4/reference/axislabel/
    ev.target.fill  = am4core.color("#000");
    ev.target.background.fill  = am4core.color("#fff");
}
dateAxis.renderer.labels.template.events.on("hit", labelOnHitFunction, this);
dateAxis.renderer.labels.template.events.on("doublehit", labelOffHitFunction, this);
// dateAxis.renderer.labels.template.events.off("hit", labelOffHitFunction, this);


var series = chart.series.push(new am4charts.ColumnSeries());
series.dataFields.categoryY = "worksmithId";
series.dataFields.dateX = "endDateTime";
series.dataFields.openDateX = "startDateTime";
series.columns.template.strokeWidth = 1; // 2
series.columns.template.column.fillOpacity = 0.5; // 0.9
series.columns.template.column.propertyFields.fill = "color";
series.columns.template.column.propertyFields.stroke = "color";
series.columns.template.height = am4core.percent(40); // Column template height


// Show JobStatus On column Template
var columnTemplate = series.columns.template;
columnTemplate.strokeOpacity = 0;
// columnTemplate.height = 20;
// columnTemplate.dy = 10;
columnTemplate.propertyFields.fill = "color";
// https://www.amcharts.com/docs/v4/concepts/axes/#Labels
var label = columnTemplate.createChild(am4core.Label);
//Set text color
// https://www.amcharts.com/docs/v4/concepts/formatters/formatting-strings/
label.text = "[{color}]{jobStatus}[/]";
label.dx = 10;  // margin
label.align = "left"; // middle
label.valign = "middle";
label.fontSize = 14;
// Set font weight //https://www.amcharts.com/docs/v4/reference/fontweight/
label.fontWeight = 600; // 600: semi-bold
// Set the label Formatting https://www.amcharts.com/docs/v4/reference/label/
label.truncate = true;  // NOT ASSIGNED -> N...





// Background Color Gradient
var fillModifier = new am4core.LinearGradientModifier();
fillModifier.brightnesses = [1, 1, 0, 0]; // [0, 1, 1, 0]
fillModifier.opacities = [1, 0];
fillModifier.offsets = [0, 1];
fillModifier.gradient.rotation = 90;
series.columns.template.column.fillModifier = fillModifier;
series.columns.template.column.strokeOpacity = 0.9;

// Rounded borders
series.columns.template.column.cornerRadiusTopLeft = 4;
series.columns.template.column.cornerRadiusTopRight = 4;
series.columns.template.column.cornerRadiusBottomLeft = 4;
series.columns.template.column.cornerRadiusBottomRight = 4;

// // Create a range
// var range = dateAxis.createSeriesRange(series);
// range.date = new Date(2022, 7, 25);
// range.endDate = new Date(2022, 8, 20);


// var segment = series.segments.columnTemplate;
// segment.interactionsEnabled = true;

// var hs = segment.states.create("hover");
// hs.properties.strokeWidth = 30;


// Set up tooltip
// series.columns.template.tooltipText = "{worksmithName}: {openDateX} - {dateX}";
series.columns.template.showTooltipOn = "hit"; //  "hit", "always" "hover"
series.tooltip.getFillFromObject = false;
series.tooltip.label.propertyFields.fill = "color";
series.tooltip.background.propertyFields.stroke = "color";
series.tooltip.pointerOrientation = "down";


/* Add a single HTML-based tooltip to first series */ // Part of new feedback
series.columns.template.tooltipText = `[bold]Worksmith: {worksmithName}[/]
----
Job Status: {jobStatus}
Duration: {openDateX.formatDate('dd-MMM-YYYY')} - {dateX.formatDate('dd-MMM-YYYY')}`;
// series.tooltip.pointerOrientation = "vertical";



// Set up Cursor: Date axis Cursor with pink-grey background
// chart.cursor = new am4charts.XYCursor();
// chart.cursor.lineX.stroke = am4core.color("#475569");
// chart.cursor.lineX.strokeOpacity = 0.2;
// chart.cursor.lineX.strokeWidth = 30;
// chart.cursor.fullWidthLineX = true;
// chart.cursor.lineX.strokeDasharray = "";
// chart.cursor.lineY.disabled = true;

chart.legend.itemContainers.template.events.on("over", function(ev) {
  toggleSeries(ev.target.dataItem.dataContext, true);
});

chart.legend.itemContainers.template.events.on("out", function(ev) {
  toggleSeries(ev.target.dataItem.dataContext, false);
});

function toggleSeries(series, over) {
    series.segments.each(function(segment) {
    	segment.isHover = over;
	});
}


// Create custom legend
/*chart.events.on("ready", function(event) {
  // populate our custom legend when chart renders
  chart.customLegend = document.getElementById('legendDiv');
  	var legendArr = [];
    series.dataItems.each(function(row, i) {
    	var timeColor = '#fff';
	    // var timeColor =  row._dataContext.color;  //actual

	    if(!legendArr.includes(chart.data[i]['worksmithId'])){
	    	// console.log(legendArr.includes(chart.data[i]['worksmithId']));
		    legendArr.push(chart.data[i]['worksmithId']);

		    // timeColorsObj[row._dataContext.jobStatus];
		    // timeColorsArr[i];
		    // console.log(timeColor);
		    // console.log(row._dataContext.jobStatus);
		    // var value = row.value;

		    legendDiv.innerHTML += `
		      <div id="time-legend-item-${i}" class="row time-legend-item" style="background-color:${timeColor};">
		      	<div class="col-md-3 time-legend-marker">
		      		<img src="${chart.data[i]['image']}" class="mt-2 mb-2" width="30" height="30" />
		      	</div>
		      	<div class="col-md-9 time-legend-marker">
		      		<div class="time-legend-value">${chart.data[i]['jobDesc']}</div>
		      		<div class="time-legend-value">${chart.data[i]['worksmithName']}</div>
		      	</div>
		      </div>
		    `;
		}

	});

});*/

//----------------------------------------------------------------------------------


// Add pagination buttons
var arrow = "M26,14H10l5.17-6.79A2,2,0,0,0,12,4.79l-7.62,10a2,2,0,0,0,0,2.42l7.62,10a2,2,0,0,0,3.18-2.42L10,18H26a2,2,0,0,0,0-4Z";
var prev = chart.plotContainer.createChild(am4core.Button);
prev.dy = -105;
prev.background.fill = am4core.color("#fff"); // Set prev button background white
// https://www.amcharts.com/docs/v4/reference/sprite/
prev.icon = new am4core.Sprite();
prev.icon.fill = am4core.color("#000"); // Arrow color
prev.icon.path = arrow;
prev.events.on("hit", prevPage);

var next = chart.plotContainer.createChild(am4core.Button);
next.dy = -105;
next.align = "right";
next.background.fill = am4core.color("#fff"); // Set next button background white
next.icon = new am4core.Sprite();
next.icon.fill = am4core.color("#000"); // #6183e4// Arrow color
next.icon.rotation = 180;
next.icon.path = arrow;
next.events.on("hit", nextPage);

// Set data
chart.data = getMonthData();
</script>
