<script>
$(document).ready(function(){
	//------------------------- Pie Chart starts here -------------------------
	// https://codepen.io/team/amcharts/pen/aevJEw
	am4core.useTheme(am4themes_animated);

	// Create chart instance
	var pieChart = am4core.create("pieChartContainer", am4charts.PieChart);

	// Add data
	pieChart.data = [
	{
	  "status": "Dummy",
	  "job_counts": 100,
	  "disabled": true,
	  "color": am4core.color("#fff"), // #dadada -> lightgrey background
	  "opacity": 0.3,
	  // "strokeDasharray": "4,4",
	  "tooltip": ""
	},
	{
	  "status": "Not Assigned",
	  "job_counts": "{{ getMonthlyNotAssignedJobsCount() }}"
	}, {
	  "status": "Not Started",
	  "job_counts": "{{ getMonthlyNotStartedJobsCount() }}"
	}, {
	  "status": "Crafting",
	  "job_counts": "{{ getMonthlyCraftingJobsCount() }}"
	}, {
	  "status": "Completed",
	  "job_counts": "{{ getMonthlyCompletedJobsCount() }}"
	}, {
	  "status": "Received",
	  "job_counts": "{{ getMonthlyReceivedJobsCount() }}"
	}, {
	  "status": "Delayed",
	  "job_counts": "{{ getMonthlyDelayedJobsCount() }}"
	}];

	// Add and configure Series
	var pieSeries = pieChart.series.push(new am4charts.PieSeries());
	pieSeries.dataFields.value = "job_counts";
	pieSeries.dataFields.category = "status";
	pieSeries.labels.template.disabled = true;


	//--------------------- Placeholder Starts Here --------------------
	/* Set up slice1 appearance */
	var slice = pieSeries.slices.template;
	slice.propertyFields.fill = "color"; // am4core.color("#dadada");
	slice.propertyFields.fillOpacity = "opacity"; // 0.3;
	slice.propertyFields.stroke = "color";
	slice.propertyFields.strokeDasharray = "strokeDasharray"; // "4,4";
	slice.propertyFields.tooltipText = "tooltip";

	// pieSeries.labels.template.propertyFields.disabled = "disabled";
	// pieSeries.ticks.template.propertyFields.disabled = "disabled";

	// Disable hover & active behavior
	// https://www.amcharts.com/docs/v4/tutorials/disabling-default-hover-and-click-effects-on-pie-chart/
    slice.states.getKey("hover").properties.scale = 1;
    slice.states.getKey("active").properties.shiftRadius = 0;

	// Hiding dummy slice from legend
	pieSeries.dataFields.hiddenInLegend = "disabled";
	// ---------------------- Placeholder Ends Here --------------------

	// var hoverState = pieSeries.slice.template.states.create("hover");
	// hoverState.properties.fill = am4core.color("pink");
	// hoverState.properties.fillOpacity = 0.8;

	//----------------- Color Settings Starts Here ----------------------
	// chart.legend = new am4charts.Legend();
	const pieColorsArr = ['fff', '#cbd5e1', '#000', '#e4a061', '#6183e4', '#37b981', '#ff0000']; // #ff0000 -> #f77171

	pieSeries.colors.list = [
		am4core.color("#fff"), // For Placeholder(dummy Data)
	    am4core.color("#cbd5e1"),
	    am4core.color("#000"),
	    am4core.color("#e4a061"),
	    am4core.color("#6183e4"),
	    am4core.color("#37b981"),
	    am4core.color("#ff0000"),
	];

	// colorsArr.each(function(k, v) {
	// 	am4core.color(v)
	// });	
	//--------------------- Color Settings Ends Here --------------------

	pieChart.radius = am4core.percent(100); // 95

	// Create custom legend
	chart.legend = new am4charts.Legend();
	pieChart.events.on("ready", function(event) {
	  // populate our custom legend when chart renders
	  pieChart.customLegend = document.getElementById('legend');

	  	pieSeries.dataItems.each(function(row, i) {
		  	// console.log('i : '+i);
		  	// console.log('row : '+row);

		  	// if (i !== 0){
			    // var color = chart.colors.getIndex(i);
			    var color = pieColorsArr[i];

			    // if(i == 5){
			  	// 	console.log('6_color: '+color);
			  	// }

			    var percent = Math.round(row.values.value.percent * 100) / 100;
			    var value = row.value;
			    // legend.innerHTML += '<div class="legend-item" id="legend-item-' + i + '" onclick="toggleSlice(' + i + ');" onmouseover="hoverSlice(' + i + ');" onmouseout="blurSlice(' + i + ');" style="color: ' + color + ';"><div class="legend-marker" style="background: ' + color + '"></div>' + row.category + '<div class="legend-value">' + value + '     ' + percent + '%</div></div>';

			    var isDisplay = (i == 0) ? 'd-none' : '';

			    legend.innerHTML += `
			      <div id="legend-item-${i}" class="legend-item ${isDisplay}">
			      	<span class="clr" id="color-${i}" style="background-color:${color};"></span>
			      	<div class="legend-marker">${row.category}</div>
			      	<div class="legend-value">${value}</div>
			      	<div class="legend-value">${percent}%</div>
			      </div>
			    `;
			// }
		});
	});

	// function toggleSlice(item) {
	//   var slice = pieSeries.dataItems.getIndex(item);
	//   if (slice.visible) {
	//     slice.hide();
	//   }
	//   else {
	//     slice.show();
	//   }
	// }

	// function hoverSlice(item) {
	//   var slice = pieSeries.slices.getIndex(item);
	//   slice.isHover = true;
	// }

	// function blurSlice(item) {
	//   var slice = pieSeries.slices.getIndex(item);
	//   slice.isHover = false;
	// }
	//------------------------- Pie Chart ends here ------------------------- 
});
</script>