@extends('layouts.admin.default')

@section('title',"Cost Summary")

@section('header', "Cost Summary")


@section('content')
    <form action="{{ route('admin.jobs.updateCost') }}" method="post" autocomplete="off" id="cost-form">
        @csrf
        @method('PUT')
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">{{ __('content.cost_summery') }}</h4>
            </div>
            <input type="hidden" class="" name="job_id" value="{{ $record->id}}">

            <div class="card-body">
                <div class="row">
                    <div class="col-lg-6 col-md-6 mb-4">
                        <div class="form-group cus_form_group">
                            <label  class="form-label cus_label">{{ __('content.item_code') }}</label>
                            <input type="text" class="cus_form_control"  name="item_code"  value="{{ old('item_code',$record->item_code) }}">
                        </div>
                        @if ($errors->has('item_code'))
                                <span class="error-message new_error_message">{{ $errors->first('item_code') }}</span>
                        @endif
                    </div>
                    <div class="col-lg-6 mb-4">
                        <div class="form-group cus_form_group label_with">
                            <label class="form-label cus_label">{{ __('content.date_created') }}</label>
                            <input type="text" name="date" class="cus_form_control datePicker" value="{{ old('date',date('d-m-Y', strtotime($record->date))) }}" readonly>
                            @if ($errors->has('date'))
                                <span class="error-message new_error_message">{{ $errors->first('date') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group cus_form_group pt-2">
                            <label  class="form-label cus_label pe-5">Item Type</label>
                            <div class="form-group d-flex">
                                @php $types = \App\Models\JobType::getJobTypesList(); @endphp
                                @foreach($types as $key=>$value)
                                    @if($value == \App\Models\JobType::BESPOKE)
                                        <div class="form-check">
                                            <input class="form-check-input jewellery_type cus-form-check-input"
                                                   type="radio" name="type_id" value="{{ $key }}"
                                                   {{ old('type_id',$record->job_type_id) == $key ? "checked": " "}} id="type_id-{{$key}}">
                                            <label class="form-check-label cus_form_check_label" for="type_id-{{$key}}">
                                                {{ $value }}
                                            </label>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-4">
                        <div class="form-group cus_form_group label_with">
                            <label class="form-label cus_label">{{ __('content.estimate_completion') }}</label>
                            <input type="text" name="estimate_completion" class="cus_form_control datePicker" value="{{ old('estimate_completion',!empty($record->estimate_completion) ?  date('d-m-Y', strtotime($record->estimate_completion)) : '') }}" readonly>
                        </div>
                        @if ($errors->has('estimate_completion'))
                        <span class="error-message new_error_message">{{ $errors->first('estimate_completion') }}</span>
                    @endif
                    </div>

                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">{{ __('content.total_cost') }}</h4>
            </div>
            <div class="card-body">
                <div class="total_cost">
                    <ul class="d-flex flex-wrap">
                        <li><span>{{ __('content.gold') }}</span>
                            <div class="inpur_form">
                                <span class="cost_unit">SGD</span> <input type="text" id="gold_cost" class="from-control" placeholder="" name="gold_cost" value="{{ old('gold_cost',isset($record->gold_cost) ? (float)$record->gold_cost : '') }}"/>
                                @if ($errors->has('gold_cost'))
                                    <span class="error-message new_error_message">{{ $errors->first('gold_cost') }}</span>
                                @endif
                            </div>
                        </li>
                        <li><span>{{ __('content.workmanship') }}</span>
                            <div class="inpur_form">
                                <span class="cost_unit">SGD</span> <input type="text" id="workmanship_cost" class="from-control" placeholder="" name="craftsmanship_cost" value="{{  old('craftsmanship_cost',isset($record->craftsmanship_cost) ? (float)$record->craftsmanship_cost  : '') }}"/>
                                @if ($errors->has('craftsmanship_cost'))
                                    <span class="error-message new_error_message">{{ $errors->first('craftsmanship_cost') }}</span>
                                @endif
                            </div>
                        </li>
                        <li><span>{{ __('content.polishing') }}</span>
                            <div class="inpur_form">
                                <span class="cost_unit">SGD</span> <input type="text" id="polishing_cost" class="from-control" placeholder="" name="polishing" value="{{  old('polishing',isset($record->polishing) ? (float)$record->polishing : '') }}"/>
                                @if ($errors->has('polishing'))
                                    <span class="error-message new_error_message">{{ $errors->first('polishing') }}</span>
                                @endif
                            </div>
                        </li>
                        <li><span>{{ __('content.setting') }}</span>
                            <div class="inpur_form">
                                <span class="cost_unit">SGD</span>
                                <input type="text" id="setting_cost" class="from-control" placeholder="" name="setting_cost" value="{{  old('setting_cost',isset($record->setting_cost) ? (float)$record->setting_cost : '') }}"/>
                                @if ($errors->has('setting_cost'))
                                    <span class="error-message new_error_message">{{ $errors->first('setting_cost') }}</span>
                                @endif
                            </div>
                        </li>
                    </ul>
                    <hr>
                    <ul class="d-flex flex-wrap">
                        <li>
                            <span>{{ __('content.backing') }} <span class="d-block">Teacup</span></span>
                            <div class="inpur_form">
                                <span class="cost_unit">SGD</span>
                                <input type="text" id="backing_cost" class="from-control" placeholder="" name="backing_cost" value="{{  old('backing_cost',isset($record->backing_cost) ? (float)$record->backing_cost : '') }}"/>
                                @if ($errors->has('backing_cost'))
                                    <span class="error-message new_error_message">{{ $errors->first('backing_cost') }}</span>
                                @endif
                            </div>
                        </li>
                    </ul>
                    <hr>
                    <ul class="d-flex flex-wrap">
                        @foreach($record->loose_pieces as $key=>$value)
                            <li><span>Stock {{ $value->stock_no }}</span>
                                <div class="inpur_form">
                                    <span class="cost_unit">SGD</span>
                                    <input type="text" class="from-control" name="jewelleries[{{ $key }}][price]" value="{{ old('jewelleries.'.$key.'.price',isset($value->price) ? (float)$value->price : '') }}" id="stock_price-{{$key}}">
                                    @if ($errors->has('jewelleries.'.$key.'.price'))
                                        <span class="error-message new_error_message">
                                        <strong>{{ $errors->first('jewelleries.'.$key.'.price') }}</strong>
                                    </span>
                                    @endif
                                </div>
                                <input type="hidden" name="jewelleries[{{$key}}][stock_no]"
                                       value="{{ old('jewelleries.'.$key.'.stock_no',$value->stock_no) }}">
                                <input type="hidden" name="jewelleries[{{$key}}][weight]"
                                       value="{{ old('jewelleries.'.$key.'.weight',$value->weight) }}">
                                <input type="hidden" name="jewelleries[{{$key}}][unit_price]"
                                       value="{{ old('jewelleries.'.$key.'.unit_price',$value->unit_price) }}">
                            </li>
                        @endforeach
                    </ul>
                    <hr>
                    <ul class="d-flex flex-wrap">
                        <li><span>{{ __('content.subtotal') }}</span>
                            @php
                                $setting =   \App\Models\Setting::price_settings();
                                $total_stock_prices = $record->loose_pieces->sum('price');
                                $subtotal =  $record->gold_cost +  $record->craftsmanship_cost + $record->polishing + $record->setting_cost +$record->backing_cost + $total_stock_prices ;
                                $gst = $subtotal * $setting['gst_percent']/100;
                                $total = $subtotal+$gst;
                            @endphp
                            <div>
                                <span class="cost_unit">SGD</span>
                                <label id="subtotal"> {{ (!empty($record->review_cost->sub_total) ? $record->review_cost->sub_total : $subtotal) }}</label>
                            </div>
                        </li>
                        <li>
                            <div class="gst_div"><span>GST</span> <input type="text" class="from-control ms-5" value="{{ old('gst_percent',isset($record->review_cost->gst_percent) ? (float)$record->review_cost->gst_percent : $setting['gst_percent']) }}" name="gst_percent" id="gst_cost" placeholder=""/><span class="cost_unit">%</span>
                                @if ($errors->has('gst_percent'))
                                <span class="error-message new_error_message">
                                    {{ $errors->first('gst_percent') }}
                                </span>
                                @endif
                            </div>
                            <div>
                                <span class="cost_unit">SGD</span>
                                <label id="gst_value"> {{ (!empty($record->review_cost->gst_amount) ? (float)$record->review_cost->gst_amount  : 0) }}</label>
                            </div>
                        </li>
                    </ul>
                    <ul class="d-flex flex-wrap total_final_cost">
                        <li><span>{{ __('content.total') }}</span>
                            <div>
                                <span class="cost_unit">S$</span>
                                <label id="total_cost"> {{ (!empty($record->review_cost->total) ?  $record->review_cost->total  : $total) }}</label>
                            </div>
                        </li>
                        <li><span>{{ __('content.mark_up') }}</span>
                            <div class="inpur_form">
                                <span class="cost_unit">S$</span> <input type="text" name="mark_up" value="{{ old('mark_up',@$record->review_cost->mark_up) }}" class="from-control" id="mark_cost" placeholder=""/>
                                @if ($errors->has('mark_up'))
                                    <span class="error-message new_error_message">
                                        {{ $errors->first('mark_up') }}
                                    </span>
                                @endif
                            </div>
                        </li>
                        <li><span>{{ __('content.mark_up_forex') }}</span></li>
                    </ul>
                    <ul class="d-flex flex-wrap mark_up">
                        <li>
                            <div class="gst_div"><span>1 USD</span> =<input type="text" class="from-control mx-2" id="usd_cost" name="usd_exchange_rate" value="{{ old('usd_exchange_rate',isset($record->review_cost->usd_exchange_rate) ? $record->review_cost->usd_exchange_rate : $setting['usd_unit']) }}" placeholder=""/>
                                <span>SGD</span>
                                @if ($errors->has('usd_exchange_rate'))
                                    <span class="error-message new_error_message">{{ $errors->first('usd_exchange_rate') }}</span>
                                @endif
                            </div>
                            <div class="inpur_form">
                                <span class="cost_unit">USD</span>
                                <input type="text" name="mark_up_usd" class="from-control mark_up-input" id="usd_price" value="{{ old('mark_up_usd',@$record->review_cost->mark_up_usd) }}" placeholder=""/>
                                @if ($errors->has('mark_up_usd'))
                                    <span class="error-message new_error_message">{{ $errors->first('mark_up_usd') }}</span>
                                @endif
                            </div>
                        </li>
                    </ul>
                    <ul class="d-flex flex-wrap mark_up">
                        <li>
                            <div class="gst_div"><span>1 HKD</span> =<input type="text" class="from-control mx-2" name="hkd_exchange_rate" value="{{ old('hkd_exchange_rate',isset($record->review_cost->hkd_exchange_rate) ? $record->review_cost->hkd_exchange_rate : $setting['hkd_unit']) }}" id="hkd_cost" placeholder=""/>
                                <span>SGD</span>
                                @if ($errors->has('hkd_exchange_rate'))
                                    <span class="error-message new_error_message">{{ $errors->first('hkd_exchange_rate') }}</span>
                                @endif
                            </div>
                            <div class="inpur_form">
                                <span class="cost_unit">HKD</span> <input type="text" name="mark_up_hkd" class="from-control mark_up-input" value="{{ old('mark_up_hkd',@$record->review_cost->mark_up_hkd) }}" id="hkd_price" placeholder=""/>
                                @if ($errors->has('mark_up_hkd'))
                                    <span class="error-message new_error_message">{{ $errors->first('mark_up_hkd') }}</span>
                                @endif
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        {{--Hidden Fields --}}
        <input type="hidden" id="subtotal_hidden" class="from-control" name="sub_total" value="{{ $subtotal }}">
        <input type="hidden" id="gst_hidden" name="gst_amount" value="{{ $gst }}">
        <input type="hidden" id="total_hidden" name="total" value="{{ $total }}">
        {{--End Hidden Fields --}}

        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons buttons_1">
                    <button class="btn btn-primary btn-create" type="submit">{{ __('content.create') }}</button>
                    <button class="btn btn-primary btn-reset-form" type="submit">{{ __('content.reset_form') }}</button>
                </div>
                <div class="col-lg-8 note pt-2">
                    <p>Note:
                        <span class="d-block">
                            Upon creating a bespoke jewellery successfully, a job order for a worksmith will be automatically created. Go to Job Order to assign a worksmith to the newly job order.<br/>
                            {{ __('content.note_only') }}
                        </span>
                    </p>
                </div>
            </div>
        </div>
    </form>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.min.js"></script>

    <script>
        $('body').on('keydown', 'input, select', function (e) {
            if (e.key === "Enter") {
                var self = $(this), form = self.parents('form:eq(0)'), focusable, next;
                focusable = form.find('input,select,button,textarea').filter(':visible');
                next = focusable.eq(focusable.index(this) + 1);
                if (next.length) {
                    next.focus();
                } else {
                    form.submit();
                }
                return false;
            }
        });
    </script>

    <script>
        $(document).ready(function () {

            var gold_cost = {!! !empty($record->gold_cost) ?  json_encode($record->gold_cost) : 0 !!};
            var workmanship_cost = {!! !empty($record->craftsmanship_cost) ?  json_encode($record->craftsmanship_cost) : 0 !!}
            var polishing_cost =  {!! !empty($record->polishing) ?  json_encode($record->polishing) : 0 !!};
            var setting_cost =  {!! !empty($record->setting_cost) ?  json_encode($record->setting_cost) : 0 !!};
            var backing_cost =  {!! !empty($record->backing_cost) ?  json_encode($record->backing_cost) : 0 !!};
            var loose_pieces =  {!! !empty($record->loose_pieces) ?  json_encode($record->loose_pieces) : 0 !!};
            var total_stock_prices = {!! !empty($total_stock_prices) ?  json_encode($total_stock_prices) : 0 !!};
            var gst_cost = {!! !empty($gst) ?  json_encode($gst) : 0 !!};
            var total = {!! !empty($total) ?  json_encode($total) : 0 !!};
            var gst_new = 0;

            $('#gold_cost').on('input', function () {
                gold_cost = ($(this).val()) ? $(this).val() : 0;
                calculate();
            });

            $('#workmanship_cost').on('input', function () {
                workmanship_cost = ($(this).val() ? $(this).val() : 0);
                calculate();
            });

            $('#polishing_cost').on('input', function () {
                polishing_cost = ($(this).val()) ? $(this).val() : 0;
                calculate();
            });

            $('#setting_cost').on('input', function () {
                setting_cost = ($(this).val()) ? $(this).val() : 0;
                calculate();
            });
            $('#backing_cost').on('input', function () {
                backing_cost = ($(this).val()) ? $(this).val() : 0;
                calculate();
            });

            loose_pieces.forEach((item, index) => {
                var old_price = []
                old_price[index] = $("#stock_price-" + index).val();

                $("#stock_price-" + index).on('input', function () {
                    var new_price = parseFloat(total_stock_prices) - parseFloat(old_price[index]);
                    var currentValue = ($(this).val() ? $(this).val() : 0);
                    total_stock_prices = new_price + parseFloat(currentValue);
                    old_price[index] = currentValue;
                    // $("#stock_price-" + index).val(currentValue)
                    calculate();
                });
            });

            $('#gst_cost').on('input', function () {
                gst_new = ($(this).val()) ? $(this).val() : 0;
                calculate();
            });

            function calculate() {
                var sub_totals = parseFloat(gold_cost) + parseFloat(workmanship_cost) + parseFloat(polishing_cost) + parseFloat(setting_cost) + parseFloat(backing_cost) + parseFloat(total_stock_prices);

                $('#subtotal').html(sub_totals);
                $('#subtotal_hidden').val(sub_totals);

                if (gst_new) {
                    gst_cost = sub_totals * gst_new / 100;
                    $("#gst_value").html(gst_cost);
                    $("#gst_hidden").val(gst_cost);
                } else {
                    var gst = $("#gst_cost").val();
                    gst_cost = sub_totals * gst / 100;
                    $("#gst_value").html(gst_cost);
                    $("#gst_hidden").val(gst_cost);
                }
                total = sub_totals + gst_cost;

                $("#total_cost").html(total);
                $("#total_hidden").val(total);
            }
        });

        $('#mark_cost').on('input', function () {
            let mark_cost = $('#mark_cost').val();
            mark_cost = parseFloat(mark_cost)
            if (mark_cost) {
                let usd = $('#usd_cost').val();
                let hkd = $('#hkd_cost').val();
                usd = parseFloat(usd);
                hkd = parseFloat(hkd);
                if (usd) {
                    let usd_price = mark_cost / usd;
                    usd_price = usd_price.toFixed(3)
                    if (usd_price) {
                        $('#usd_price').val(usd_price);
                    }
                }
                if (hkd) {
                    let hkd_price = mark_cost / hkd;
                    hkd_price = hkd_price.toFixed(3)
                    if (hkd_price) {
                        $('#hkd_price').val(hkd_price);
                    }
                }


            } else {
                $('#usd_price').val(' ');
                $('#hkd_price').val(' ');
            }


        });

        $('#usd_cost').on('input', function () {
            let mark_cost = $('#mark_cost').val();
            mark_cost = parseFloat(mark_cost);
            if (mark_cost) {
                let usd = $(this).val();
                usd = parseFloat(usd)
                if (usd) {
                    let usd_price = mark_cost / usd;
                    usd_price = usd_price.toFixed(3)
                    $('#usd_price').val(usd_price);
                } else {
                    $('#usd_price').val('');
                }
            }else{
                $('#usd_price').val(' ');
            }

        });

        $('#hkd_cost').on('input', function () {
            let mark_cost = $('#mark_cost').val();
            mark_cost = parseFloat(mark_cost);
            if(mark_cost){
                let hkd = $(this).val();
                hkd = parseFloat(hkd);
                if (hkd) {
                    let hkd_price = mark_cost / hkd;
                    hkd_price = hkd_price.toFixed(3)
                    $('#hkd_price').val(hkd_price);
                } else {
                    $('#hkd_price').val('');
                }
            }

        });


        $(document).ready(function () {

            $('#cost-form').validate();

            $('[name^="gold_cost"]').rules('add', {
                // required: true,
                number: true,
            });
            $('[name^="craftsmanship_cost"]').rules('add', {
                // required: true,
                number: true,
            });
            $('[name^="polishing"]').rules('add', {
                // required: true,
                number: true,
            });
            $('[name^="setting_cost"]').rules('add', {
                // required: true,
                number: true,
            });
            $('[name^="backing_cost"]').rules('add', {
                // required: true,
                number: true,
            });
            $('[name^="mark_up"]').rules('add', {
                required: true,
                number: true,
            });
            $('[name^="mark_up_usd"]').rules('add', {
                required: true,
                number: true,
            });
            $('[name^="mark_up_hkd"]').rules('add', {
                required: true,
                number: true,
            });
            $('[name^="usd"]').rules('add', {
                required: true,
                number: true,
            });
            $('[name^="hkd"]').rules('add', {
                required: true,
                number: true,
            });

            $('[name^="jewelleries"]').each(function () {
                $(this).rules('add', {
                    number: true,
                })
            });
        });

        // $('.datePicker').datetimepicker({
        //     timepicker: false,
        //     format: 'd-m-Y',
        //     minDate: new Date()
        // });
    </script>

@endsection
