@extends('layouts.admin.default')

@section('title',"Jewelleries")

@section('header', "Jewelleries")

@section('content')

    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            @php $cat_name  = \App\Models\Category::getCategoryNameById(request()->category_id) @endphp
            <div>
                <h4 class="mb-0">{{ __('content.'.strtolower($cat_name)) }}</h4>
                <p>This section displays the {{ $cat_name }} jewelleries in Sancy’s Inventory</p>
            </div>

            <div class="custom_filter">
                <ul class="nav">
                    <li class="nav-item">
                        <a href="{{ route('admin.jewelleries.indexByCategory', [ 'category_id'=> request()->category_id, 'tab' =>  \App\Models\Jewellery::ACTIVE ]) }}" class="nav-link {{ ( request()->tab  == \App\Models\Jewellery::ACTIVE || empty(request()->tab)   ) ? 'active' : '' }}"  >Active</a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('admin.jewelleries.indexByCategory', [ 'category_id'=> request()->category_id, 'tab' =>  \App\Models\Jewellery::ARCHIVED ]) }}" class="nav-link {{ ( request()->tab  == \App\Models\Jewellery::ARCHIVED) ? 'active' : '' }}" >Archived</a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="card-body">
            @php $placeholder = "Search Jewellery Based on Code or Description"; @endphp

            @include('admin.elements.search.common')
            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>{{ __('content.select') }}</th>
                        <th class="cus-w-1">@sortablelink('item_code', __('content.item_code')) </th>
                        <th>{{ __('content.image') }}</th>
                        <th>#</th>
                        <th style="width:310px;">{{ __('content.description') }}</th>
                        {{--  <th >CODE</th>  --}}
                        <th > @sortablelink('review_cost.total','W GST')</th>
                        {{--  <th style="width:70px;" class="mark-up">@sortablelink('review_cost.mark_up','MARK UP PRICE') </th>  --}}
                        {{--  <th style="width:174px;">{{ __('content.remarks') }}</th>  --}}
                        {{--  <th> @sortablelink('date', __('content.date'))</th>  --}}
                        {{--  <th>SOURCE</th>  --}}
                        <th>JOB CODE</th>
                        @canany(['jewellery-duplicate','jewellery-quotation','jewellery-update','jewellery-print','jewellery-delete'])
                            @if(request()->tab !== App\Models\Jewellery::ARCHIVED)
                               <th>{{ __('content.action') }}</th>
                            @endif
                        @endcanany
                    </tr>
                    </thead>
                    <tbody>

                    @if(!empty($records) && $records->count())
                        @php $slNo = $records->firstItem() @endphp

                        @foreach($records as $record)
                            <tr>
                                <td>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    </div>
                                </td>
                                <td><strong>{{ $record->item_code }}</strong></td>
                                <td>
                                    <a data-fancybox="gallery" href="{{ $record->first_image ? $record->first_image->image_url : \App\Models\Jewellery::defaultImage() }}"><img  width="70" src="{{ $record->first_image ? $record->first_image->image_url : \App\Models\Jewellery::defaultImage() }}"></a>
                                </td>
                                <td>{{$slNo++}}</td>
                                <td class="description">{{ ($record->description) ? \Illuminate\Support\Str::limit($record->description, 112, $end='...') : "-"}}</td>
                               {{--  @php $code = (!empty($record->review_cost->mark_up)) ?  refinedCode($record->review_cost->mark_up) : ""; @endphp
                                <td><strong>{{ (!empty($code) ? $code : "-") }}</strong></td>  --}}
                                <td>{{ !empty($record->review_cost->total) ? "S$".(float)$record->review_cost->total : "-" }}</td>
                                {{--  <td class="mark-up">{{ !empty($record->review_cost->mark_up) ? "$".(float)$record->review_cost->mark_up : "-" }}</td>  --}}
                                {{--  <td class="remark">
                                    @if(!empty($record->loose_pieces) && count($record->loose_pieces)>0)
                                        @foreach($record->loose_pieces as $key=>$value)
                                            @if($key == 0)
                                                {{ $value->stock_no }}-${{ $value->price }}
                                            @else
                                                {{ $value->stock_no }}-{{ $value->weight }}cts
                                                @${{ $value->unit_price }}
                                            @endif
                                        @endforeach
                                        G{{ $record->gold_weight }}
                                        /W${{ $record->craftsmanship_cost }}
                                        @else
                                        <p> - </p>
                                    @endif
                                </td>  --}}
                                {{--  <td>{{ date('d/m/y', strtotime($record->date))}}</td>  --}}
                                {{--  <td>WORKSHOP</td>  --}}
                                <td>{{ !empty($record->job) ?  $record->job->item_code : "-" }}</td>

                                @canany(['jewellery-duplicate', 'jewellery-quotation', 'jewellery-update', 'jewellery-print', 'jewellery-delete', 'jewellery-printTag'])
                                     @if(request()->tab !== App\Models\Jewellery::ARCHIVED)
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                    @can('jewellery-duplicate')
                                                        <li><a class="dropdown-item duplicate" href="{{route('admin.jewelleries.duplicate', ['category_id' => $record->category->id, 'id' =>$record->id ])}}"><img src="{{ asset('public/img/duplicate.png') }}">Duplicate</a></li>
                                                    @endcan

                                                    {{-- @can('jewellery-quotation') --}}
                                                        <!-- <li><a class="dropdown-item" href="javascript:void(0);"><img src="{{ asset('public/img/quotation.png') }}">Quotations</a></li> -->
                                                    {{-- @endcan --}}

                                                    @can('jewellery-update')
                                                        <li><a class="dropdown-item" href="{{ route('admin.jewelleries.edit', ['category_id' => $record->category->id, 'id' =>$record->id ]) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                                    @endcan

                                                    @can('jewellery-print')
                                                        <li><a class="dropdown-item btn btnprn" href="{{ route('admin.jewelleries.print', ['category_id' => $record->category->id, 'id' =>$record->id ]) }}"><img src="{{ asset('public/img/print.png') }}">Print</a></li>
                                                    @endcan

                                                    @can('jewellery-printTag')
                                                        <li>
                                                            <a class="dropdown-item btnprnfile btn" href="javascript:void(0);" download data-url="{{ route('admin.jewelleries.print.tag', ['category_id' => $record->category->id, 'id' =>$record->id ]) }}" data-id="{{ $record->id }}"><img src="{{ asset('public/img/print.png') }}">Print Tag</a>

                                                            {{-- <a style="display: none;" id="download_file-{{ $record->id }}" class="btnprn" href="" >Download Prn String</a> --}}
                                                            <a style="display: none;" id="download_file-{{ $record->id }}" class="" href="" download >Download Prn String</a>
                                                            <!-- style="visibility: hidden;" -->
                                                        </li>
                                                    @endcan

                                                    @can('jewellery-delete')
                                                        <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.jewelleries.destroy', $record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                                    @endcan
                                                </ul>
                                            </div>
                                        </td>
                                  @endif
                                @endcanany
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="13">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>
    <!-- Modal -->

    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body filter-options">

                    <form method="get" class="ajaxForm" action="{{ url()->current() }}" id="AjaxFilter"
                          autocomplete="off">
                        <input type="hidden" class="form-control" src="{{ asset('public/img/inventory-search.png') }}"
                               name="search" value="{{ request('search') }}">

                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Date</label>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" name="start_date" class=" datePicker cus_form_control" value="" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" name="end_date" class=" datePicker cus_form_control" value="" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">{{ __('content.jewellery_price_range') }}</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" class="cus_form_control" placeholder="$" name="total_cost_min" value="">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" class="cus_form_control"  placeholder="$" name="total_cost_max" value="">
                                </div>
                            </div>
                            {{-- <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">{{ __('content.worksmith_price_range') }}</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1" placeholder="$" name="workmanship_cost_min" value="{{ request('workmanship_cost_min')  }}">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1" placeholder="$" name="workmanship_cost_max" value="{{ request('workmanship_cost_max')}}">
                                </div>
                            </div> --}}
                            {{-- <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">{{ __('content.gold_price_range') }}</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1" placeholder="$" name="gold_cost_min" value="{{ request('gold_cost_min')}}">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" class="cus_form_control" placeholder="$" name="gold_cost_max" value="{{ request('gold_cost_max')}}">
                                </div>
                            </div> --}}
                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">{{ __('content.gold_colour') }}</label>
                                    <select class="form-select" aria-label="Default select example" name="gold_color_id" >
                                        <option value="" selected>Select One Option</option>
                                        @php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); @endphp
                                        @foreach($gold_colors as $key=>$value)
                                            <option value="{{ $key }}" {{-- (request('gold_color_id')==$key ? 'selected' : '' ) --}}>{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">{{ __('content.backing_type') }}</label>
                                    <select class="form-select" aria-label="Default select example" name="backing_type">
                                        <option value="" selected>Select One Option</option>
                                        @php $backing_types = \App\Models\Jewellery::backingTypeArray(); @endphp
                                        @foreach($backing_types as $key=>$value)
                                            <option value="{{ $key }}" {{ (request('backing_type')==$key ? 'selected' : '' ) }}>{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div> --}}
                            {{-- <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.claw') }}</label>
                                    <select class="form-select" aria-label="Default select example" name="claw">
                                        <option value="" selected>Select One Option</option>
                                        @php $claw = \App\Models\Jewellery::clawArray(); @endphp
                                        @foreach($claw as $key=>$value)
                                            <option value="{{ $key }}" {{ (request('claw')==$key ? 'selected' : '' ) }}>{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div> --}}
                            <div class="col-lg-12 col-md-12 mt-3">
                                <div class="filter-modal-btn m-0">
                                    <button type="submit" id="AjaxFilterButton" class="btn btn-filter" data-bs-dismiss="modal"><i class="icofont-filter"></i>Filter</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>

<!--// https://sancy.superfastech.com/sancy_erp/sample/index.html-->

<script type="text/javascript" src="{{ asset('public/zebra/BrowserPrint-3.0.216.min.js') }}"></script>
<script type="text/javascript">
var selected_device;
var devices = [];
function setup()
{
	//Get the default device from the application as a first step. Discovery takes longer to complete.
	BrowserPrint.getDefaultDevice("printer", function(device)
			{

				//Add device to list of devices and to html select element
				selected_device = device;
				devices.push(device);
				var html_select = document.getElementById("selected_device");
				var option = document.createElement("option");
				option.text = device.name;
				html_select.add(option);

				//Discover any other devices available to the application
				BrowserPrint.getLocalDevices(function(device_list){
					for(var i = 0; i < device_list.length; i++)
					{
						//Add device to list of devices and to html select element
						var device = device_list[i];
						if(!selected_device || device.uid != selected_device.uid)
						{
							devices.push(device);
							var option = document.createElement("option");
							option.text = device.name;
							option.value = device.uid;
							html_select.add(option);
						}
					}

				}, function(){alert("Error getting local devices")},"printer");

			}, function(er){
			    error("Unable to detect printer device", "Unable printer device");

				// alert(error);
			})
}
function getConfig(){
	BrowserPrint.getApplicationConfiguration(function(config){
		alert(JSON.stringify(config))
	}, function(error){
		alert(JSON.stringify(new BrowserPrint.ApplicationConfiguration()));
	})
}
function writeToSelectedPrinter(dataToWrite)
{
	selected_device.send(dataToWrite, undefined, errorCallback);
}
var readCallback = function(readData) {
	if(readData === undefined || readData === null || readData === "")
	{
		alert("No Response from Device");
	}
	else
	{
		alert(readData);
	}

}
var errorCallback = function(errorMessage){
	alert("Error: " + errorMessage);
}
function readFromSelectedPrinter()
{

	selected_device.read(readCallback, errorCallback);

}
function getDeviceCallback(deviceList)
{
	alert("Devices: \n" + JSON.stringify(deviceList, null, 4))
}

function sendImage(imageUrl)
{
	url = window.location.href.substring(0, window.location.href.lastIndexOf("/"));
	url = url + "/" + imageUrl;
	selected_device.convertAndSendFile(url, undefined, errorCallback)
}
function sendFile(fileUrl){
    url = window.location.href.substring(0, window.location.href.lastIndexOf("/"));
    url = url + "/" + fileUrl;
    selected_device.sendFile(url, undefined, errorCallback)
}
function onDeviceSelected(selected)
{
	for(var i = 0; i < devices.length; ++i){
		if(selected.value == devices[i].uid)
		{
			selected_device = devices[i];
			return;
		}
	}
}
window.onload = setup;
</script>

    <script>

        // $('.datePicker').datetimepicker({
        //     format: 'd-m-Y',
        //     timepicker: false
        // });

        // <!-----------------Print jewellery Stars Here ----------->
        // $('.btnprn').printPage();
        // <!-----------------Print jewellery Stars Here ----------->
        <!---------------------------- Print Tag Stars Here --------------------->
        $(document).on("click", ".btnprnfile", function (e) {
            var $_this = this;
            var id = $(this).attr('data-id');
            console.log('id : ', id);
            var URL = $(this).data('url');
            $.ajax({
                url: URL,
                type: "json",
                method: 'GET',
                cache: false,
                success: function (res) {


                    console.log('res', res);
                    if (res.status) {

                        writeToSelectedPrinter(res.data);
                       success(res.message, res.title);
                    } else {
                        error(res.message, res.title);
                    }


                },
            });
        });
        <!------------------------ Print Tag Ends Here ------------------------->

    </script>
@endsection


