@extends('layouts.admin.default')

@section('title',"Edit Jewellery")

@section('header', "Edit Jewellery")

<style>

    #drawingCanvas {
        position: absolute;
        left: 0;
        right: 0;
        border: none;
        color: #FFF;
        overflow: hidden;
        background-color: transparent;
        /*display: none;*/

    }

    #tempCanvas {
        position: absolute;
        left: 0;
        right: 0;
        overflow: hidden;
        border: none;
        /*display: none;*/
    }

    .kbw-signature {
        width: 100%;
        height: 82px;
    }

    #signatureCustomer canvas {
        width: 100% !important;
        height: 100%;
        /*height: auto;*/
    }
</style>

@section('content')

    <form action="{{ route('admin.jewelleries.update',$record->id) }}" method="post" autocomplete="off">
        @csrf
        @method('PUT')
        @php
            $is_error = $errors->any() ? 1 : 0;
            $x = $is_error ? old('jewelleries') ? count(old('jewelleries')) : '1' : 1;

            // ($errors->any()) ? pr($errors->all()) : pr('no error');
        @endphp
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Edit Jewellery <span>( Quantity: 1)</span></h4>
            </div>
            <div class="card-body">
                <input type="hidden" name="jewellery_id" value="{{$record->id}}"/>
                <div class="row">
                    <div class="col-lg-6 col-md-6 mb-4">
                        <div class="form-group cus_form_group">
                            <label  class="form-label cus_label">{{ __('content.item_code') }}</label>
                            <input type="text" class="cus_form_control" name="item_code"  value="{{ old('item_code',$record->item_code) }}" ><br>
                        </div>
                        @if ($errors->has('item_code'))
                            <span class="error-message">
                                    <strong>{{ $errors->first('item_code') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="col-lg-6 col-md-6 mb-4">
                        <div class="form-group cus_form_group">
                            <label  class="form-label cus_label">{{ __('content.date_created') }}</label>
                            <input type="text" class="cus_form_control datePicker" name="date" value="{{ old('date',date('d-m-Y', strtotime($record->date))) }}" readonly>
                        </div>
                        @if ($errors->has('date'))
                            <span class="error-message">
                                    <strong>{{ $errors->first('date') }}</strong>
                                </span>
                        @endif
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group cus_form_group">
                            <label  class="form-label cus_label pe-5">Item Type</label>
                            <div class="form-group d-flex">
                                @php $types = \App\Models\Type::getTypesList();@endphp
                                @foreach($types as $key=>$value)
                                    @if($value ==\App\Models\Type::PURCHASED )
                                        <div class="form-check">
                                            <input class="form-check-input jewellery_type cus-form-check-input"
                                                type="radio" name="type_id" value="{{ $key }}" {{ ($key) == 1 ? "checked": " "}} {{ old('type_id',$record->type_id) == $key ? "checked": " "}} id="type_id-{{$key}}">
                                            <label class="form-check-label cus_form_check_label" for="type_id-{{$key}}">{{ __('content.'.trim(lcfirst($value))) }}
                                            </label>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">Details</h4>
            </div>
            <div class="card-body">
                <div class="row">

                    <div class="col-lg-12">
                        <div class="category jobs_edit">
                            <div class="form-group">
                                <label  class="form-label">Category</label>
                            </div>
                            <ul class="">
                                @php $categories = \App\Models\Category::getCategories(); @endphp
                                @foreach($categories as $key=>$value)
                                    <li class="{{ old('category_id', $record->category_id) == $value->id ? 'active_category' : '' }}">
                                        <a class="category_id" data-id="{{ $value->id }}">
                                            <img src="{{ $value->image }}" height="60" width="60"/>{{ __('sidebar.'.strtolower($value->name)) }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                            <input id="category_id" type="hidden" name="category_id" value="{{ old('category_id', $record->category_id) }}"/>
                            @if ($errors->has('category_id'))
                                <span class="error-message">
                                   <strong>{{ $errors->first('category_id') }}</strong>
                                </span>
                            @endif
                        </div>

                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label  class="form-label">{{ __('content.gold_colour') }}</label>
                            <select class="form-select" name="gold_color_id" aria-label="Default select example">
                                <option value=" ">Select One Option</option>
                                @php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); @endphp
                                @foreach($gold_colors as $key=>$value)
                                    <option value="{{ $key }}" {{ old('gold_color_id', $record->gold_color_id) ==  $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                        @if ($errors->has('gold_color_id'))
                            <span class="error-message">
                                <strong>{{ $errors->first('gold_color_id') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label  class="form-label">{{ __('content.size') }}</label>
                            <input type="text" name="size" class="form-control" value="{{ old('size', isset($record->size) ? (float)$record->size : '') }}">
                        </div>
                        @if ($errors->has('size'))
                            <span class="error-message">
                                <strong>{{ $errors->first('size') }}</strong>
                            </span>
                        @endif
                    </div>

                    <div class="col-lg-6 inventory_inputs">
                        <div class="form-group">
                            <label  class="form-label">Airway bill</label>
                            <input type="text" name="awb_no" class="form-control" value="{{ old('awb_no',$record->awb_no) }}">
                        </div>
                        @if ($errors->has('awb_no'))
                            <span class="error-message">
                                <strong>{{ $errors->first('awb_no') }}</strong>
                            </span>
                        @endif
                    </div>

                    <div class="col-lg-12">
                        <div class="form-group">
                            <label  class="form-label">{{ __('content.description') }}</label>
                            <textarea class="form-control" name="description"  placeholder="Description" rows="2" value="">{{ old('description', $record->description) }}</textarea>
                            @if ($errors->has('description'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('description') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-lg-12 mt-3">
                        <label class="form-label">
                            {{ __('content.draw_upload') }}
                            <img src="{{ asset('public/img/folder.png') }}" class="folder"></label>
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-group pt-0">
                                    <div class="drop-zone">

                                        <div class="dropzone" id="dropZoneimageUpload">
                                            <span class="drop-zone__prompt dz-default dz-message text-start">Drop Photo here <br>
                                            {{ __('content.drop_photo_only') }}
                                            <p style="text-align: left;margin-top: 10px;">Photo Requiement:</p>
                                            <ul>
                                                <li>File type PNG or JPG</li>
                                                <li>Maximum Size: 2 MB</li>
                                            </ul>
                                                {{--<input type="file" name="file" class="fileimage drop-zone__input">--}}
                                                {{--<input type="hidden" class="imageFile" name="images[]">--}}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-8">
                                <div class="form-group pt-0">
                                    <div class="start-drawing" id="blackboardPlaceholder">
                                        <p id="drawing-place-holder">{{ __('content.start_drawing') }}</p>
                                        <canvas id="drawingCanvas" width="500" height="230"></canvas>
                                        <div class="pen-eraser">
                                            <span class="pen" onclick="togglePenPointer();"><img src="{{ asset('public/img/pen.png') }}"/></span>
                                            <span class="erase" onclick="eraserHandler();"><img src="{{ asset('public/img/eraser.png') }}"/></span>
                                        </div>
                                    </div>
                                    <input type="hidden" id="drawing_textarea_base64" name="drawing_textarea_base64">
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="preview-droped-images">

                                    @foreach($record->images as  $key=>$value)
                                        <div class="dz-preview dz-processing dz-image-preview dz-complete">

                                            <div class="dz-image">
                                                <img data-dz-thumbnail="" height="60" alt="bracelet.png" src="{{ $value->image_url  }}">
                                            </div>
                                            <a class="dz-remove remove_button" href="javascript:undefined;"
                                               data-dz-remove="">X</a>
                                            <input type="hidden" value="{{ $value->image }}" name="images[]">
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="bespoke_inputs">
                        <div class="col-lg-12">
                            <div class="sample">
                                <div class="col-lg-12">
                                    <div class="form-group d-flex align-items-center pt-0">
                                        <label  class="form-label mb-0 pe-5">{{ __('content.sample_provided') }}</label>
                                        <div class="form-check">
                                            <input class="form-check-input cus-form-check-input" type="radio"
                                                   name="is_sample_provided" id="flexRadioDefault1"
                                                   value="1" {{ old("is_sample_provided",$record->is_sample_provided) == 1 ? 'checked' : '' }} >
                                            <label class="form-check-label cus_form_check_label"
                                                   for="flexRadioDefault1">
                                                {{ __('content.yes') }}
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input cus-form-check-input" type="radio"
                                                   name="is_sample_provided"
                                                   value="0" {{ old("is_sample_provided",$record->is_sample_provided) == 0 ? 'checked' : '' }}>
                                            <label class="form-check-label cus_form_check_label"
                                                   for="flexRadioDefault1">
                                                {{ __('content.no_') }}
                                            </label>
                                        </div>
                                    </div>
                                    @if ($errors->has('is_sample_provided'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('is_sample_provided') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.sample_description') }}</label>
                                        <textarea class="form-control" name="sample_description" placeholder="Description" rows="2">{{ old('sample_description',$record->sample_description) }}</textarea>
                                    </div>
                                    @if ($errors->has('sample_description'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('sample_description') }}</strong>
                                </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.gold_cost') }}</label>
                                        <input type="text" class="form-control" name="gold_cost"  value="{{ old('gold_cost',$record->gold_cost) }}">
                                    </div>
                                    @if ($errors->has('gold_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('gold_cost') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.gold_weight') }}</label>
                                        <input type="text" class="form-control" name="gold_weight"  value="{{ old('gold_weight', $record->gold_weight) }}">
                                    </div>
                                    @if ($errors->has('gold_weight'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('gold_weight') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.workmanship_cost') }}</label>
                                        <input type="text" class="form-control"  name="workmanship_cost" value="{{ old('workmanship_cost',$record->workmanship_cost) }}">
                                    </div>
                                    @if ($errors->has('workmanship_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('workmanship_cost') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.polishing_cost') }}</label>
                                        <input type="text" class="form-control"  name="pollising_cost" value="{{ old('pollising_cost',$record->pollising_cost) }}">
                                    </div>
                                    @if ($errors->has('pollising_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('pollising_cost') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.setting_cost') }}</label>
                                        <input type="text" class="form-control"  name="setting_cost" value="{{ old('setting_cost',$record->setting_cost) }}">
                                    </div>
                                    @if ($errors->has('setting_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('setting_cost') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.earing_pin') }}</label>
                                        <input type="text" class="form-control"  name="earing_pin" value="{{ old('earing_pin',$record->earing_pin) }}">
                                    </div>
                                    @if ($errors->has('earing_pin'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('earing_pin') }}</strong>
                                </span>
                                    @endif
                                </div>

                                <div class="col-lg-6 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_type') }}</label>
                                        <select class="form-select" aria-label="Default select example" name="backing_type">
                                            <option value=" ">Select One Option</option>
                                            @php $backing_types = \App\Models\Jewellery::backingTypeArray(); @endphp
                                            @foreach($backing_types as $key=>$value)
                                                <option value="{{ $key }}" {{ old('backing_type',$record->backing_type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if ($errors->has('backing_type'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_type') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-6 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_cost') }}</label>
                                        <input type="text" class="form-control" name="backing_cost" value="{{ old('backing_cost',$record->backing_cost) }}">
                                    </div>
                                    @if ($errors->has('backing_cost'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_cost') }}</strong>
                                </span>
                                    @endif
                                </div>

                                <div class="col-lg-3 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_size') }}</label>
                                        <input type="text" class="form-control"  name="backing_size" value="{{ old('backing_size',$record->backing_size) }}">
                                    </div>
                                    @if ($errors->has('backing_size'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_size') }}</strong>
                                </span>
                                    @endif
                                </div>
                                <div class="col-lg-3 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.backing_quantity') }}</label>
                                        <input type="text" class="form-control"  name="backing_quantity" value="{{ old('backing_quantity',$record->backing_quantity) }}">
                                    </div>
                                    @if ($errors->has('backing_quantity'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('backing_quantity') }}</strong>
                                </span>
                                    @endif
                                </div>

                            </div>
                        </div>
                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.claw') }} </label>
                                        <select class="form-select" aria-label="Default select example" name="claw">
                                            <option value=" ">Select One Option</option>
                                            @php $claw = \App\Models\Jewellery::clawArray(); @endphp
                                            @foreach($claw as $key=>$value)
                                                <option value="{{ $key }}" {{ old('claw',$record->claw) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if ($errors->has('claw'))
                                        <span class="error-message"><strong>{{ $errors->first('claw') }}</strong></span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons">
                    <button class="btn btn-primary btn-create" type="submit">{{ __('content.input_cost') }}</button>
                    <a href="{{ route('admin.jewelleries.indexByCategory',request()->category_id) }}" class="btn btn-primary btn-reset-form w-auto ps-3 pe-3"
                       type="button">Cancel Editing</a>
                </div>
                <div class="col-lg-5 note pt-2">
                    {{--<p>Note:--}}
                    {{--<span class="d-block">Upon creating a jewellery successfully, a job order for a worksmith will be automatically created. Go to Job Order to assign a worksmith to the newly job order.</span>--}}
                    {{--</p>--}}
                </div>
            </div>
        </div>
    </form>

    @include('admin.jewelleries.script')

@endsection
