@extends('layouts.admin.default')

@section('title',"Add Invoice")

@section('header', "Add Invoice")

@section('content')

<form id="invoiceCost" method="post" action="{{ route('admin.invoices.updateCost',$invoice->id)}}">
  @csrf
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">Create Invoice</h4>
        </div>
        <div class="card-body table-preview">
            <a href="{{  url()->previous() }}" class="btn previous-page"><img src="{{ asset('public/img/back.png')}}" class="me-2"/> To Previous Page</a>
          <div class="invoice_corner">
            <div class="table-responsive">
                <table class="table mb-0">
                  <thead>
                    <tr>
                      <th scope="col">Item coDE</th>
                      <th scope="col">Description</th>
                      <th scope="col" class="text-center" style="width:139px;">Image</th>
                      <th scope="col" class="text-center" style="width:160px;">price</th>
                      <th scope="col" class="text-center" style="width:120px;">Gold Colour</th>
                    </tr>
                  </thead>
                  <tbody>
                   @if(!empty($invoice))
                   @foreach ($invoice->invoice_item as $key=>$item)
                      @php 
                          if($item->job_id){
                             $image_url =  (@$item->job->first_image) ? @$item->job->first_image->image_url : getDefaultImage();
                          }
                          if($item->jewellery_id){
                             $image_url = (@$item->jewellery->first_image) ? @$item->jewellery->first_image->image_url : getDefaultImage();
                          }
                     @endphp
                      <tr>
                          <input type="hidden" name="invoice[{{ $key }}][invoice_item_id]" value="{{$item->id}}">
                          <td class="text-nowrap">{{ $item->item_code }}</td>
                          <td><div class="create-invoice-preview">{{ ( $item->description)?? "-" }}</div></td>
                          <td class="text-center"><img src="{{ $image_url }}" class="img-fluid"/></td>
                          <td class="text-center"><input type="text" name=" invoice[{{ $key }}][price]" class="form-control item_price" value="{{ (float)$item->sub_total }}" oninput="onInputPrice()"/></td>
                          <td class="text-center">{{ ($item->gold_color) ? $item->gold_color->name : "-" }}</td>
                      </tr>
                    @endforeach
                    @endif

                  </tbody>
                </table>
            </div>
          </div>
            <div class="total_amount">
              @php
                  $setting   =   \App\Models\Setting::price_settings();           
                  $gst_percent = $setting['gst_percent'];
              @endphp
                <p><span>Subtotal</span> <strong id="sub_total">SGD {{ $invoice->sub_total }}</strong></p>
                <p><span>GST</span> <strong id="gst_amount">SGD {{$invoice->gst_amount}}</strong></p>
                <h4><span>Total</span> <strong id="total">SGD {{ $invoice->total}}</strong></h4>
            </div>
            <div class="total_amount">
                <div class="form-check">
                  <input class="form-check-input" name="layaway" type="checkbox" value="1" {{ (!empty($invoice->layaway) ? "checked" : " ") }}>
                  <label class="form-check-label ms-3" for="flexCheckDefault">
                    Layaway Payment
                  </label>
                </div>
            </div>
            <div class="buttons buttons_1 mt-4">
                <button class="btn btn-primary btn-create" type="submit">Create</button>
                <a href="" class="btn btn-primary btn-reset-form">Reset Form</a>
            </div>
        
        </div>
    </div>
</form>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.min.js"></script>

<script>

  var gst_percent = {!! $gst_percent !!}

        $("#invoiceCost").validate({
            rules: {
              price: {
                    required: true,
                    number: true,
                },
            }
        });

      function onInputPrice() {
       let price  = (event.target.value) ? event.target.value : 0;
       let subtotal = 0;
          $(".item_price").each(function(){
                let $_this = $(this);
                let price = 0;
                price =  $_this.val();
                subtotal = parseFloat(subtotal) + parseFloat(price);
        }); 

        // console.log(subtotal ,"main subtotal")
        calculate(subtotal);
      }

        function calculate(subtotal) {
            let sub_total = Math.round(subtotal * 100) / 100;
            $('#sub_total').html(sub_total);
            let gst_cost = (subtotal* gst_percent)/100;
            gst_cost = Math.round(gst_cost * 100) / 100;

            $("#gst_amount").html(gst_cost);
            let total = parseFloat(sub_total) + parseFloat(gst_cost);
                total = Math.round(total * 100) / 100;
            $("#total").html(total);
        }

     
 
</script>
@endsection





