@php
use App\Models\Invoice;
@endphp

@extends('layouts.admin.default')
@section('title',"Invoice")
@section('header', "Invoice")

@section('content')


    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Invoice</h4>
            <p>This section displays all invoice.</p>
        </div>
        <div class="card-body">
            @php $placeholder = "Search Invoice Number, Phone Number..."; @endphp

            @include('admin.elements.search.common')
            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>@sortablelink('reference_date', __('content.date'))</th>
                        <th>@sortablelink('id', __('content.invoice_id'))</th>
                        <th>@sortablelink('total', __('content.amount'))</th>
                        <th>{{ __('content.paid_amount') }}</th>
                        <th>@sortablelink('invoice.customer_name', __('content.customer'))</th>
                        <th>@sortablelink('invoice.customer_phone', __('content.phone_number'))</th>

                        @canany(['invoice-refund','invoice-print','invoice-sendEmailPDF'])    
                          <th>{{ __('content.action') }}</th>
                        @endcanany
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($records) && $records->count())
                        @php $slNo = $records->firstItem() @endphp
                        @foreach($records as $record)
                            <tr>
                                <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-' }}</td>
                                <td>{{ $record->invoice_no ?? '-' }}</td>
                                <td>{{ isset($record->total) ? '$'.$record->total : '-' }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <span id="paid_amount-{{ $record->id }}">${{ (($record->is_refund == Invoice::ONE)  && ($record->balance == Invoice::ZERO)) ? $record->balance :  ($record->paid_amount ?? 0) }}</span>

                                        @if($record->due > 0)
                                        <a  href="javascript:void(0);" id="invoicePaidAmount-{{ $record->id }}" class="return_edit" data-record_id="{{ $record->id }}"> 
                                            <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                                        </a> <!-- data-bs-toggle="modal" data-bs-target="#Layway_popup" -->
                                        @endif
                                    </div>
                                </td>
                                <td class="text-nowrap">
                                    {{ isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-') }}
                                </td>
                                <td class="text-nowrap">{{ $record->phone_with_code ?? '-' }}</td>
                                @canany(['invoice-refund','invoice-print','invoice-sendEmailPDF'])
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                           
                                            @can('invoice-refund')
                                                @if($record->balance > 0)
                                                    <li><a class="dropdown-item" href="{{ route('admin.invoices.refund', $record->id) }}"><img src="{{ asset('public/img/vector.png') }}">Refund</a></li>
                                                @endif
                                            @endcan

                                            @can('invoice-print')
                                                <li><a class="dropdown-item" href="{{ route('admin.invoices.printInvoice', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Invoice</a></li> <!-- btnprn -->
                                            @endcan

                                            @can('invoice-sendEmailPDF')
                                                <li><a class="dropdown-item sendEmailPDF" href="javascript:void(0); {{-- route('admin.invoices.sendEmailPDF', $record->id) --}}" id="sendEmailPDF-{{ $record->id }}" data-record_id="{{ $record->id }}" data-for="invoices"><img src="{{ asset('public/img/envelope.png') }}">Send email</a></li>
                                            @endcan

                                        </ul>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="7">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>

    @include('admin.elements.scripts.pdf_email_js')

    @include('admin.invoices.layway_popup')

@endsection

