@extends('layouts.admin.default')

@section('title',"Add Invoice")

@section('header', "Add Invoice")

@section('content')

@php
    $inventory = \App\Models\InvoiceItem::INVENTORY;
    $bespoke = \App\Models\InvoiceItem::BESPOKE;
    $repair = \App\Models\InvoiceItem::REPAIR;
@endphp

<form id="invoiceSubmit" method="post">

<div class="card details mb-4">
    <div class="card-header">
        <h4 class="mb-0">Create Invoice</h4>
    </div>
    <div class="card-body create_quotation add_item_from_main">
        {{--<div class="add_item">--}}
            <div class="items items_new">
                <div class="align-items-center">
                    <label class="add_itemm">Add Item From*:</label>
                    <ul class="nav nav-tabs tabbing-0" id="myTab" role="tablist">
                        <li class="nav-item m-0 me-3" role="presentation">
                            <button class="nav-link inventory" data-key="0" data-bs-toggle="tab" data-bs-target="#inventory-0" type="button" role="tab" aria-controls="home" aria-selected="true">{!! __('content.inventory_with_br') !!}</button>
                        </li>
                        <li class="nav-item m-0 me-3" role="presentation">
                            <button class="nav-link bespoke" data-key="0" data-bs-toggle="tab" data-bs-target="#bespoke-0" type="button" role="tab" aria-controls="profile" aria-selected="false">{!! __('content.bespoke_with_br') !!}</button>
                        </li>
                        <li class="nav-item m-0 me-3" role="presentation">
                            <button class="nav-link repair" data-key="0" data-bs-toggle="tab" data-bs-target="#repair-0" type="button" role="tab" aria-controls="contact" aria-selected="false">{!! __('content.repair_with_br') !!}</button>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent-0">
                        <div class="tab-pane fade show" id="inventory-0" role="tabpanel" aria-labelledby="home-tab">
                            <div class="position-relative add_item_search">
                               <div class="search">
                                <span><img src="{{ asset('public/img/search.png') }}" class="display">
                                    <img src="{{ asset('public/img/search_foucs.png') }}" class="focus_search">
                                </span>
                                    <div class="d-flex align-items-center position-relative">
                                        <div class="input_div w-100">
                                            <input type="text" id="inventory_item_code-0" class="form-control cus_form_control jewelley_item_code"   name="inv[0][{{ $inventory }}][item_code]" placeholder="Search an item code or an scan item...">
                                            <label class="field_error" id="inventory_item_code_error-0" style="color:red"> </label>
                                        </div>
                                        <img src="{{ asset('public/img/cross.png') }}" class="cross cross_invent">

                                    </div>

                                    <div class="col-lg-12 button_div">
                                        <div class="d-flex mt-5">
                                            <button class="btn btn-primary btn-create btn-confirm inventory_confirm me-4" data-key="0" type="button">Confirm Add Item</button>
                                            <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-key="0" type="button">Reset Form</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="bespoke-0" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="position-relative add_item_search">
                                <div class="search">
                                <span><img src="{{ asset('public/img/search.png') }}" class="display">
                                    <img src="{{ asset('public/img/search_foucs.png') }}" class="focus_search">
                                </span>
                                    <div class="d-flex align-items-center position-relative">
                                        <div class="input_div w-100">
                                            <input type="text" id="bespoke_item_code-0" class="form-control cus_form_control job_item_code" value=""  name="inv[0][{{ $bespoke }}][item_code]" placeholder="Search an item code or an scan item...">
                                            <label class="field_error" id="bespoke_item_code_error-0" style="color:red"> </label>
                                        </div>
                                        <img src="{{ asset('public/img/cross.png') }}" class="cross cross_invent">

                                    </div>

                                    <div class="col-lg-12 button_div">
                                        <div class="d-flex mt-5">
                                            <button class="btn btn-primary btn-create btn-confirm bespoke_confirm me-4" data-key="0" type="button">Confirm Add Item</button>
                                            <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-key="0" type="button">Reset Form</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="repair-0" role="tabpanel" aria-labelledby="contact-tab">
                          <div class="position-relative add_item_search">
                             <div class="search">
                                <span>
                                    <img src="{{ asset('public/img/search.png') }}" class="display">
                                    <img src="{{ asset('public/img/search_foucs.png') }}" class="focus_search">
                                </span>
                                <div class="d-flex align-items-center position-relative">
                                    <div class="input_div w-100">
                                        <input type="text" id="repair_item_code-0" class="form-control cus_form_control job_item_code" value=""  name="inv[0][{{ $repair }}][item_code]" placeholder="Search an item code or an scan item...">
                                        <label class="field_error" id="repair_item_code_error-0" style="color:red"> </label>
                                    </div>
                                    <img src="{{ asset('public/img/cross.png') }}" class="cross cross_invent">
                                </div>

                            <div class="col-lg-12 button_div">
                                <div class="d-flex mt-5">
                                    <button class="btn btn-primary btn-create btn-confirm repair_confirm me-4" data-key="0" type="button">Confirm Add Item</button>
                                    <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-key="0" type="button">Reset Form</button>
                                </div>
                            </div>
                       </div>
                            </div>
                         </div>

                      </div>
                    </div>
                  </div>
                 <div class="append_btn"></div>
                </div>

                   <div class="card-body pt-0 pb-4">
                       <div class="form-check">
                           <input class="form-check-input layway_pay" name="layaway" type="checkbox" id="" value="1">
                           <label class="form-check-label" for="gridCheck">
                               Layaway Payment
                           </label>
                       </div>
                   </div>

               <div class="sample card-body mt-0">
                  <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="form-group pt-0">
                    <input type="hidden" name="invoice_item" id="invoice_item" val="">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.handle_by') }}</label>
                    @php $handledBy = \App\Models\Admin::handleBYArray();@endphp
                    <select class="form-select common_input" aria-label="Default select example" name="staff_id">
                        <option value="">Select One Option</option>
                        @foreach($handledBy as $key=>$value)
                            <option value="{{ $value->id }}">{{ ucwords($value->fullname) }}</option>
                        @endforeach
                    </select>
                    <span class="field_error" id="staff_id_error" style="color:red"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group pt-lg-0 pt-md-0 pt-sm-0 pt-3 position-relative">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_phone_no') }}</label>
                    <div class="search">
                        <img src="{{ asset('public/img/search.png') }}">
                        <input type="text" class="form-control" id="customer_phone" name="customer_phone" placeholder="Enter or Search Phone Number">
                    </div>
                    <span class="field_error" id="customer_phone_error" style="color:red"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_name') }}</label>
                    <input type="text" class="form-control" id="customer_name" name="customer_name">
                    <span class="field_error" id="customer_name_error" style="color:red"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_email') }}</label>
                    <input type="email" class="form-control" id="customer_email" name="customer_email" >
                    <span class="field_error" id="customer_email_error" style="color:red"> </span>
                </div>
              </div>
            </div>
        </div>
    </div>
    <div class="card details mb-4">
        <div class="card-body">
            <div class="buttons buttons_1">
                <button class="btn btn-primary btn-create" type="submit">{{ __('content.input_cost') }}</button>
                <a href="" class="btn btn-primary btn-reset-form" type="button">{{ __('content.reset_form') }}</a>
            </div>
            <div class="col-lg-8 note pt-2">
                <p>Note:
                    <span class="d-block">Upon creating a jewellery successfully, a job order for a worksmith will be automatically created. Go to Job Order to assign a worksmith to the newly job order.</span>
                </p>
            </div>
        </div>
</div>
</form>

@include('admin.elements.scripts.active_itemcode')
@include('admin.invoices.script')
@endsection



