@php
    use Illuminate\Support\Facades\Route;
    $routeName = Route::currentRouteName();
    $category = \App\Models\Category::getCategoriesList();
@endphp

<div class="dasboard-menu">
    <div class="d-flex align-items-start _inner-menu">
        <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
            <ul class="all-acc">
                <li class="nav-item {{in_array($routeName,['admin.dashboard.index']) ? 'active_l':''}}">
                    <a href="{{ route('admin.dashboard.index') }}" class="nav-link" id="v-pills-home-tab" type="button">
                        <img src="{{ asset('public/images/menu-icon/icon-1.png') }}"/>{{ __('sidebar.dashboard') }}
                    </a>
                </li>
            </ul>

            <ul class="all-acc">

                @canany(['jewellery-create', 'jewellery-read'])
                    <h4>{{ __('sidebar.inventory') }}</h4>
                @endcanany

                @can('jewellery-create')
                    <li class="nav-item {{in_array($routeName,['admin.jewelleries.create']) ? 'active_l':''}}">
                        <a class="nav-link" href="{{route('admin.jewelleries.create') }}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/> {{ __('sidebar.add_jewellery') }}</a>
                    </li>
                @endcan

                @can('jewellery-read')
                    @foreach($category as $key=>$value)
                        <li class="nav-item {{ (request()->category_id == $value->id) ? in_array($routeName,['admin.jewelleries.edit','admin.jewelleries.indexByCategory','admin.jewelleries.duplicate','admin.jewelleries.purchagedCostSummery']) ? 'active_l':'': '' }}">
                            <a class="nav-link" href="{{route('admin.jewelleries.indexByCategory',$value->id)}}"><img src="{{ $value->icon_image }}"/>{{ __('sidebar.'.strtolower($value->name)) }}</a>
                        </li>
                    @endforeach
                @endcan

            </ul>

            <ul class="all-acc">
                @canany(['job-create', 'job-read', 'job-dashboard'])
                    <h4>{{ __('sidebar.job_order') }} </h4>
                @endcanany

                @can('job-dashboard')
                <li class="nav-item {{ in_array($routeName,['admin.jobs.dashboard']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.jobs.dashboard') }}"><img src="{{ asset('public/images/menu-icon/icon-1.png') }}"/> {{ __('sidebar.dashboard') }}</a>
                </li>
                @endcan

                @can('job-create')
                    <li class="nav-item {{ in_array($routeName,['admin.jobs.create']) ? 'active_l':''}}">
                        <a class="nav-link" href="{{ route('admin.jobs.create')}}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/>{{ __('sidebar.create_job') }}</a>
                    </li>
                @endcan

                @can('job-read')
                    <li class="nav-item {{in_array($routeName,['admin.jobs.index','admin.jobs.edit','admin.jobs.duplicate','admin.jobs.bespokeCostSummery']) ? 'active_l':''}}">
                        <a class="nav-link" href="{{ route('admin.jobs.index') }} "><img src="{{ asset('public/images/menu-icon/icon-10.png') }}"/>{{ __('sidebar.all_job_order')  }}</a>
                    </li>
                @endcan
            </ul>

            <ul class="all-acc">
                @canany(['quotation-create','quotation-read'])
                <h4>{{ __('sidebar.sales') }}</h4>
                <!-- <li class="nav-item ">
                    <a class="nav-link" href="javascript:void(0);"><img src="{{ asset('public/images/menu-icon/icon-1.png')}}"/>{{-- __('sidebar.dashboard') --}}
                    </a>
                </li> -->
                @endcanany

                @canany(['quotation-create','quotation-read', 'invoice-create','invoice-read'])
                <li class="nav-item side-dropdown">
                    <a class="nav-link" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne" href="javascript:void(0);"><img src=" {{ asset('public/img/Library.png') }}"/>{{ __('sidebar.quotations')  }}</a>
                    <span>
                        @if(in_array($routeName,['admin.quotations.create','admin.quotations.index']))
                            <img src="{{ asset('public/img/arrow_down.png') }}" class="img_arrow_change" data-text="-"/>
                        @else
                            <img src="{{ asset('public/img/right_arrow.png') }}" class="img_arrow_change" data-text="+" />
                        @endif
                    </span>
                    <ul style="display: {{ in_array($routeName,['admin.quotations.create','admin.quotations.index','admin.quotations.edit' ]) ? 'block':'' }};">

                        @can('quotation-create')
                        <li class="nav-item {{ in_array($routeName,['admin.quotations.create']) ? 'active_l':'' }}">
                            <a class="nav-link" href="{{ route('admin.quotations.create') }}"><img src="{{ asset('public/img/Library.png') }}"/>{{ __('sidebar.create_quotations') }}</a>
                        </li>
                        @endcan

                        @can('quotation-read')
                        <li class="nav-item {{ in_array($routeName,['admin.quotations.index','admin.quotations.edit'] ) ? 'active_l':'' }}">
                            <a class="nav-link" href="{{ route('admin.quotations.index') }}"><img src="{{ asset('public/img/Library.png') }}"/>{{ __('sidebar.quotations_list') }}</a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany

                @canany(['invoice-create','invoice-read'])

                <li class="nav-item side-dropdown">
                    <a class="nav-link" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne" href="javascript:void(0);"><img src="{{ asset('public/img/Library.png') }}"/>{{ __('sidebar.invoice') }}</a><span>
                        @if(in_array($routeName,['admin.invoices.create','admin.invoices.index']))
                            <img src="{{ asset('public/img/arrow_down.png') }}"class="img_arrow_change" data-text="-" />
                        @else
                            <img src="{{ asset('public/img/right_arrow.png') }}" class="img_arrow_change" data-text="+" />
                        @endif
                     </span>
                    <ul style="display: {{ in_array($routeName,['admin.invoices.create','admin.invoices.index']) ? 'block':'none' }}">

                        @can('invoice-create')
                        <li class="nav-item {{ in_array($routeName,['admin.invoices.create']) ? 'active_l':'' }}">
                            <a class="nav-link" href="{{ route('admin.invoices.create') }}"><img src=" {{ asset('public/img/Library.png') }} "/>{{ __('sidebar.create_invoice') }}</a>
                        </li>
                        @endcan

                        @can('invoice-read')
                        <li class="nav-item {{ in_array($routeName,['admin.invoices.index']) ? 'active_l':'' }}">
                            <a class="nav-link" href="{{ route('admin.invoices.index') }}"><img src="{{ asset('public/img/Library.png') }}"/>{{ __('sidebar.invoice_list') }}</a>
                        </li>
                        @endcan
                    </ul>
                </li>
                @endcanany

            </ul>

            <ul class="all-acc">

                @canany(['customer-create','customer-read','customer-dashboard'])
                <h4>{{ __('sidebar.customers') }}</h4>
                @endcanany

                {{-- @can('customer-dashboard') --}}
                    <!-- <li class="nav-item">
                        <a class="nav-link" href="javascript:void(0);"><img src="{{ asset('public/images/menu-icon/icon-1.png') }}"/>{{-- __('sidebar.dashboard') --}}</a>
                    </li> -->
                {{-- @endcan --}}

                @can('customer-create')
                <li class="nav-item {{ in_array($routeName,['admin.customers.create']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.customers.create') }}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/>{{ __('sidebar.create_customer') }}</a>
                </li>
                @endcan

               @can('customer-read')
                <li class="nav-item {{ in_array($routeName,['admin.customers.index','admin.customers.edit']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.customers.index') }}"><img src="{{ asset('public/images/menu-icon/icon-10.png') }}"/>{{ __('sidebar.all_customer') }}</a>
                </li>
                @endcan
            </ul>

            <ul class="all-acc">
                @canany(['consignment-create','consignment-read'])
                <h4>{{ __('sidebar.consignment') }}</h4>
                @endcanany

                @can('consignment-create')
                <li class="nav-item {{ in_array($routeName,['admin.consignments.create']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.consignments.create') }}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/>{{ __('sidebar.create_new_consignment') }}</a>
                </li>
                @endcan

                @can('consignment-read')
                <li class="nav-item {{ in_array($routeName,['admin.consignments.index','admin.consignments.edit']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.consignments.index') }}"><img src="{{ asset('public/images/menu-icon/icon-10.png') }}"/>{{ __('sidebar.view_consignment_list') }}</a>
                </li>
                @endcan
            </ul>
            <ul class="all-acc">
                @canany(['role-create','role-read'])
                <h4>{{ __('sidebar.access_role') }}</h4>
                @endcanany

                @can('role-create')
                <li class="nav-item {{ in_array($routeName,['admin.roles.create']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.roles.create') }}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/>{{ __('sidebar.create_access_role') }}</a>
                </li>
                @endcan

                @can('role-read')
                <li class="nav-item {{ in_array($routeName,['admin.roles.index','admin.roles.edit']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.roles.index') }}"><img src="{{ asset('public/images/menu-icon/icon-10.png') }}"/>{{ __('sidebar.view_access_role') }}</a>
                </li>
                @endcan

            </ul>

            <ul class="all-acc">
                @canany(['staff-create','staff-read'])
                    <h4>{{ __('sidebar.staff_account') }}</h4>
                @endcanany

                @can('staff-create')
                    <li class="nav-item {{ in_array($routeName,['admin.staffs.create']) ? 'active_l':''}}">
                        <a class="nav-link" href="{{ route('admin.staffs.create') }}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/>{{ __('sidebar.create_staff_account') }}</a>
                    </li>
                @endcan

                @can('staff-read')
                    <li class="nav-item {{ in_array($routeName,['admin.staffs.index','admin.staffs.edit']) ? 'active_l':''}}">
                        <a class="nav-link" href="{{ route('admin.staffs.index') }}"><img src="{{ asset('public/images/menu-icon/icon-10.png') }}"/> {{ __('sidebar.all_staff_account') }}</a>
                    </li>
                @endcan

            </ul>

            <ul class="all-acc">

                @canany(['worksmith-create','worksmith-read'])
                <h4>Worksmith</h4>
                @endcanany

                @can('worksmith-create')
                <li class="nav-item {{ in_array($routeName,['admin.worksmiths.create']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.worksmiths.create') }}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/>{{ __('sidebar.create_worksmith') }}</a>
                </li>
                @endcan

                @can('worksmith-read')
                <li class="nav-item {{ in_array($routeName,['admin.worksmiths.index','admin.worksmiths.edit']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.worksmiths.index') }}"><img src="{{ asset('public/images/menu-icon/icon-10.png') }}"/>{{ __('sidebar.all_worksmith') }}</a>
                </li>
                @endcan

            </ul>

            <ul class="all-acc">

                @canany(['setting-shopSetting','setting-priceSetting'])
                <h4>Settings</h4>
                @endcanany

                @can('setting-shopSetting')

                <li class="nav-item {{ in_array($routeName,['admin.settings.shopSettings']) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.settings.shopSettings') }}"><img src="{{ asset('public/images/menu-icon/icon-2.png') }}"/>Shop Settings</a>
                </li>
                @endcan

                @can('setting-priceSetting')
                <li class="nav-item {{ in_array($routeName,['admin.settings.priceSettings',]) ? 'active_l':''}}">
                    <a class="nav-link" href="{{ route('admin.settings.priceSettings') }}"><img src="{{ asset('public/images/menu-icon/icon-10.png') }}"/>Price Settings</a>
                </li>
                @endcan

            </ul>

        </ul>
    </div>

</div>

<script type="text/javascript">
    $(document).ready(function(){
        $(".side-dropdown span").click(function(){

        var arrowText = $(this).children().attr('data-text');

        $(this).siblings("ul").slideToggle();
        if(arrowText == '+'){
            $(this).children().attr('src',"{{ asset('public/img/arrow_down.png') }}");
            $(this).children().attr('data-text','-');
        }else{
            $(this).children().attr('src',"{{ asset('public/img/right_arrow.png') }}");
            $(this).children().attr('data-text','+');
        }
    });
    });
</script>

