@php
    use Illuminate\Support\Facades\Route;
    $routeName = Route::currentRouteName();
@endphp

{{-- count(Auth::user()->unreadNotifications) --}}

<header>
    <div class="container-fluid">
        <nav class="navbar_custom jewellery ">
            <a class="navbar-brand" href="{{ route('admin.dashboard.index') }}">
                <img src="{{ asset('public/img/logo.png') }}"/> 
            </a>
            <div class="dashboard">
                <div class="form-group">
                    <select class="form-select" id="dashboardDropdown" value="">
                        <option class="switchDashboard {{ (request()->routeIs('admin.*')) ? 'active' : '' }}" 
                            {{ (request()->routeIs('admin.*')) ? 'selected' : '' }} value="admin" id="adminDashboard">Admin Dashboard</option>
                        <option class="switchDashboard {{ (!request()->routeIs('admin.*')) ? 'active' : '' }}" {{  (!request()->routeIs('admin.*')) ? 'selected' : '' }} value="web" id="frontDashboard">Front Dashboard</option>
                    </select>
                </div>
            </div>
            <div class="ms-auto items d-flex">
                <div class="d-flex align-items-center">
                    <div class="add-jewellery">
                        @can('jewellery-read')
                        <a href="{{ route('admin.jewelleries.create') }}">Add Jewellery<img src="{{ asset('public/img/plus.png') }}"/></a>
                        @endcan
                    </div>
                    <!-- <div class="add-noti">
                        <a href="javascript:void(0);">Notification<img src="{{ asset('public/img/bell.png') }}"/></a>
                    </div> -->
                    <div class="add-noti dropdown add-noti-content">
                        <a href="javascript:void(0);" id="notification_box" role="button">
                            <span class="d_non_1">Notification</span>
                            <img src="{{ asset('public/img/bell.png') }}">
                        </a>
                        
                        <div class="drop_1 dropdown-menu">
                            <div class="box_n1">
                                <a href="javascript:void(0);">Show All Notifications</a>
                            </div>
                            
                            @forelse(Auth::user()->unreadNotifications as $notification)
                            <!--<div style="background-color:cyan;">{{-- dd($notification) --}}</div>-->
                            @php 
                                // dd(is_array($notification->data) ? 'array' : 'not array' );
                                $notificationData = $notification->data['data']; 
                                // dd($notificationData);
                            @endphp
                            <div class="box_n1 box_text" id="notification-{{ $notification->id }}">
                                <h6><span>{{ $notificationData['item_code'] ?? 'item_code' }}</span> {{ $notificationData['message'] ?? 'message' }}</h6>
                                <div class="text-danger">
                                    <small>{{ $notificationData['date_time'] ?? 'date_time' }}</small>
                                </div>
                                <a href="javascript:void(0);" class="markAsRead" id="hide_noti-{{ $notification->id }}" data-record_id="{{ $notification->id }}">
                                    <i class="icofont-close-line"></i>
                                </a>
                            </div>
                            @empty
                            <div class="box_n1 box_text">
                                <!-- <h6><span>J123450</span> due tomorrow</h6> -->
                                <div class="text-danger">
                                    <small>No record found!</small>
                                </div>
                                <a href="javascript:void(0);" id="hide_noti">
                                    <i class="icofont-close-line"></i>
                                </a>
                            </div>
                            @endforelse
                        </div>
                    </div>
                    <div class="name-of-user">
                        <div class="btn-group">
                            <button type="button" class="dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                <label>{{ auth()->user()->fullname }}<span>{{ !empty(auth()->user()->role) ? auth()->user()->role->name : \App\Models\Admin::SUBADMIN  }}</span></label>
                                @php $fullname = auth()->user()->fullname @endphp
                                <i>{{ ucfirst($fullname[0]) }}</i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item {{ in_array($routeName,['admin.showPasswordForm']) ? 'active_l':'' }}"
                                   href="{{ route('admin.showPasswordForm') }}">
                                    Change Password
                                </a>
                                <a class="dropdown-item {{ in_array($routeName,['admin.showProfileForm']) ? 'active_l':'' }}"
                                   href="{{ route('admin.showProfileForm') }}">
                                    My Profile
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nav_right_content d-flex align-items-center">
                    <div class="d-flex align-items-center ps-2">
                        {{-- <p href="javascript:void(0);">Get Help</p>
                        <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#exampleModal" class="help">?</a> --}}
                    </div>
                    <div class="d-flex align-items-center log">
                        <a href="{{ route('admin.logout') }}"
                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><p>Log Out<img class="ms-2" src="{{ asset('public/img/logout.png') }}"/></p></a>
                        <form id="logout-form" action="{{ route('admin.logout') }}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</header>

<script>
    $(document).ready(function () {
        //---------------------- Notification JS Starts --------------------
        $('#notification_box').click(function () {
            $('.drop_1').slideToggle();
        });
        
        // $("#hide_noti").click(function () {
        //     $('.box_text').hide();
        // });

        $('#hide_noti').on('click', function(){
            $('.drop_1.dropdown-menu').hide();
        });

		$('.markAsRead').on('click', function(e){
			e.preventDefault();
			var record_id = $(this).data("record_id");
            console.log('record_id :', record_id);

	        $.ajax({
	            url: "{{ route('admin.markNotificationAsRead') }}",
	            type: "POST",
	            cache: false,
	            data: {"_token":"{{csrf_token()}}", id:record_id},
	            dataType: 'json',
	            success:function(res){
		            console.log(res);
		            if (res.status == 0) {
		                error(res.message, res.title); 
		            }else if (res.status == 1) {
		                $('#notification-'+record_id).remove();
		                success(res.message, res.title);
		            }
	            },
	            error: function(response) {
	            	$('#message-error').text(response.responseJSON.errors.message);
	            }
	        });
		});
        //------------------------ Notification JS Ends --------------------

        //---------------------- Switch Dashboard JS Starts ----------------
        $('#dashboardDropdown').change(function(){
            _this = $(this);
            var selectedVal = _this.val();
            // _this.children().removeClass('active');
            // $('#'+selectedVal+'Dashboard').addClass('active');

            var requestedUrl = '{{ route("switchDashboard", ":requestFor") }}';
            requestedUrl = requestedUrl.replace(':requestFor', selectedVal);
            console.log('requestedUrl', requestedUrl);

            $.ajax({
                type:'GET',
                url: requestedUrl,
                success: function(res){
                    console.log('res :'+res);

                    if(res.status==0){
                        error(res.message, res.title);
                    }else if(res.status==1){
                        window.open(res.data, '_blank');
                        success(res.message, res.title);  
                        location.reload(true); 
                    }
                },
            });
        });
        //---------------------- Switch Dashboard JS Ends ------------------
    });
</script>