<script>
/**
 * ---------------------------------------
 * This demo was created using amCharts 4.
 *
 * For more information visit:
 * https://www.amcharts.com/
 *
 * Documentation is available at:
 * https://www.amcharts.com/docs/v4/
 * ---------------------------------------
 */

// var data = {
//   "set1": [{
//     "monthname": "2022-01",
//     "count": 450
//   }, {
//     "monthname": "2022-02",
//     "count": 1200
//   }, {
//     "monthname": "2022-03",
//     "count": 1850
//   }],
//   "set2": [{
//     "monthname": "2022-01-05",
//     "count": 950
//   }, {
//     "monthname": "2022-01-10",
//     "count": 850
//   }, {
//     "monthname": "2022-01-15",
//     "count": 1200
//   }],
//   "set3": [{
//     "monthname": "2022-02",
//     "count": 300
//   }, {
//     "monthname": "2022-04",
//     "count": 489
//   }, {
//     "monthname": "2022-09",
//     "count": 100
//   }],
// }

var data1 = {!! json_encode($saleData) !!};
var data2 = {!! json_encode($quotationData) !!};
var data3 = {!! json_encode($invoiceData) !!};

am4core.useTheme(am4themes_animated);

// Create chart instance
var chart1 = am4core.create("saleColumnChart", am4charts.XYChart);
var chart2 = am4core.create("quotationColumnChart", am4charts.XYChart);
var chart3 = am4core.create("invoiceColumnChart", am4charts.XYChart);

drawXYChart(chart1, data1, 'sale', 'viewDropdownSale');
drawXYChart(chart2, data2, 'quotation', 'viewDropdownQuatition');
drawXYChart(chart3, data3, 'invoice', 'viewDropdownInvoice');
// chart.dateFormatter.inputDateFormat = "yyyy-MM";

function drawXYChart(chart, data, chartName, list_options){
    // Add data
    // chart.data = data.set1;
    chart.data = data.monthly;

    // Add some spacing on top
    chart.paddingTop = 40;

    // Create axes
    // var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
    // dateAxis.dataFields.category = getXAxisVariableName('monthly');
    // getMinGridDistance('monthly');
    // dateAxis.renderer.grid.template.location = 0.0001;  // To make DateAxis distinguish from user-set zero from default zero, set it to a value that is very close to zero, say, 0.0001
    // dateAxis.renderer.grid.template.disabled = true; 

    // dateAxis.renderer.minLabelPosition = 0; // 0    0.05;
    // dateAxis.renderer.maxLabelPosition = 1; // 1    0.95;
    // // dateAxis.renderer.labels.locationX = 0.5;

    // dateAxis.renderer.inside = false; 
    // dateAxis.renderer.labels.template.horizontalCenter = "middle";
    // dateAxis.renderer.labels.template.verticalCenter = "middle";
    // dateAxis.tooltip.disabled = true;

    // // dateAxis.renderer.labels.template.fontWeight = "bold"; //font weight
    // dateAxis.renderer.labels.template.fontSize = 12; //font size

    var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
    getXAxisFieldName(chartName, 'monthly');
    getMinGridDistance(chartName, 'monthly');
    categoryAxis.renderer.grid.template.location = 0.0001;  // To make DateAxis distinguish from user-set zero from default zero, set it to a value that is very close to zero, say, 0.0001
    categoryAxis.renderer.grid.template.disabled = true; 

    categoryAxis.renderer.minLabelPosition = 0; // 0    0.05;
    categoryAxis.renderer.maxLabelPosition = 1; // 1    0.95;
    // dateAxis.renderer.labels.locationX = 0.5;

    categoryAxis.renderer.inside = false; 
    categoryAxis.renderer.labels.template.horizontalCenter = "middle";
    categoryAxis.renderer.labels.template.verticalCenter = "middle";
    categoryAxis.renderer.labels.template.fill = am4core.color('#00000099'); // hex code for rgba(0, 0, 0, 0.6) 
    categoryAxis.tooltip.disabled = true;

    // dateAxis.renderer.labels.template.fontWeight = "bold"; //font weight
    categoryAxis.renderer.labels.template.fontSize = 12; //font size
    getNoOfTicks(chartName, 'monthly');

    // getDateFormat('monthly');
    // // PERIOD CHANGE FORMAT
    // getPeriodChangeDateFormat('monthly');

    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

    // Set up axis title
    valueAxis.title.text = getYAxisTitle(chartName);
    valueAxis.title.rotation = 0; // display horizontally 
    valueAxis.title.align = "center";
    valueAxis.title.valign = "top";
    valueAxis.title.dy = -40; // -25
    valueAxis.title.dx = 60;
    // valueAxis.title.fontWeight = 600;

    valueAxis.renderer.labels.template.fill = am4core.color('#00000099'); // hex code for rgba(0, 0, 0, 0.6) 

    // Create series
    var series = chart.series.push(new am4charts.ColumnSeries());
    series.dataFields.valueY = "count";
    // series.dataFields.dateX = getXAxisVariableName('monthly');
    getSeriecCategoryAxisFieldName(chartName, 'monthly');

    var tooltipTextPrefix = ((chartName !== 'sale')) ? "$" : "";
    // console.log('tooltipTextPrefix', tooltipTextPrefix);
    series.name = "counts";
    series.columns.template.tooltipText = "{categoryX}: [bold]"+tooltipTextPrefix+" {valueY}[/]";
    series.columns.template.fillOpacity = 1;

    series.columns.template.stroke = am4core.color('#DAB198'); // Border Color
    series.columns.template.fill = '#DAB198'; // Background Color
    let columnWidth = (chartName == 'sale') ? 23 : 10;
    series.columns.template.width = am4core.percent(columnWidth);

    var columnTemplate = series.columns.template;
    columnTemplate.strokeWidth = 1; // 2
    columnTemplate.strokeOpacity = 1;

    var label = columnTemplate.createChild(am4core.Label);
    //Set text color
    // https://www.amcharts.com/docs/v4/concepts/formatters/formatting-strings/
    label.dx = 50;  // margin
    label.align = "left"; // middle
    label.valign = "middle";
    label.py = 15;
    label.dx = -120;

    // Disable Mouse Wheel Over Chart
    chart.chartContainer.wheelable = false;

    // Create Cursor
    // chart.cursor = new am4charts.XYCursor();

    // Disable Scrolling Grip Icon
    // grip.icon.disabled = true;

    // Disable scrolling
    // chart.scrollbarX = new am4core.Scrollbar();
    // chart.scrollbarX.startGrip.disabled = true;
    // chart.scrollbarX.endGrip.disabled = true;

    // chart.scrollbarY = new am4core.Scrollbar();
    // chart.scrollbarY.startGrip.disabled = true;
    // chart.scrollbarY.endGrip.disabled = true;



    $('#'+list_options+' li a').on('click', function()
    {
        var _this = $(this);
        var name = $(this).data('name');
        var interval = $(this).data('interval');

        $('#'+name+'Btn').html(interval.charAt(0).toUpperCase()+interval.slice(1)+' View');
        var start_date= $(this).parent().parent().parent().parent().find('.d-flex.align-items-center .chartDateFilter .start_date').val();
        var end_date= $(this).parent().parent().parent().parent().find('.d-flex.align-items-center .chartDateFilter .end_date').val();
        selectDataset(interval,start_date,end_date);
        // getDateFormat(interval);
        // getPeriodChangeDateFormat(interval);
        getXAxisFieldName(name, interval);
        getSeriecCategoryAxisFieldName(name, interval);
    });


    function getXAxisFieldName(name, interval)
    {
        if(name == 'sale'){
            categoryAxis.dataFields.category = 'name'; 
        }else{
            if(interval == 'monthly'){
                categoryAxis.dataFields.category = 'monthname'; 
            }else if(interval == 'daily'){
                categoryAxis.dataFields.category = 'dayname';
            }
        }
    }

    function getMinGridDistance(name, interval)
    {
        if(name == 'sale'){
            categoryAxis.renderer.minGridDistance = 7;
        }else{
            if(interval == 'monthly'){
                categoryAxis.renderer.minGridDistance = 12;
            }else if(interval == 'daily'){ 
                categoryAxis.renderer.minGridDistance = 30; 
            } 
        }
    }

    function getNoOfTicks(name, interval)
    {
        if(name == 'sale'){
            categoryAxis.renderer.ticks.template.length = 6; // No. of ticks
        }else{
            if(interval == 'monthly'){
                categoryAxis.renderer.ticks.template.length = 11; // No. of ticks
            }else if(interval == 'daily'){
                categoryAxis.renderer.ticks.template.length = 6; // No. of ticks
            }
        }
    }

    function getSeriecCategoryAxisFieldName(name, interval)
    {
        if(name == 'sale'){
            series.dataFields.categoryX = 'name'; 
        }else{
            if(interval == 'monthly'){
                series.dataFields.categoryX = 'monthname'; 
            }else if(interval == 'daily'){
                series.dataFields.categoryX = 'dayname';
            } 
        }
    }

    function getYAxisTitle(name)
    {
        if(name == 'sale'){
            return 'Quantity';
        }else{
            return '$/dollars';
        }
    }

    function selectDataset(set,start_date='', end_date='') 
    {
        console.log(set, data[set]);
        // https://stackoverflow.com/questions/39515607/how-can-i-filter-an-array-of-objects-between-two-dates
        sd = new Date(start_date+"T00:00:00.000Z");
        ed = new Date(end_date+"T23:59:59.000Z"); 
        if((start_date=='') && (end_date=='')){
            chart.data = data[set];
        }else{  
            result = data[set].filter(d => {var time = new Date(d.created_at);
                if(start_date==''){
                    return (time <= ed);
                }else if(end_date==''){
                    return (sd <= time);
                }else{
                    return (sd <= time && time <= ed);
                } 
            });
            chart.data=result;
        }
        console.log(chart.data); 
    }
    
    $('#'+list_options+'_date_start,#'+list_options+'_date_end').datetimepicker({
        format: 'Y-m-d',
        timepicker: false,
        scrollMonth : false,
        scrollInput : false,
    }).on('change', function(date) {  
        // console.log(e.format()); 
        $(this).datetimepicker('hide'); 
        var start_date = $(this).parent().parent().find('.chartDateFilter .start_date').val();
        var end_date = $(this).parent().parent().find('.chartDateFilter .end_date').val(); 
        var interval = $(this).parent().parent().parent().find('.viewDropdown button').html();
        var name = $(this).parent().parent().parent().find('.viewDropdown button').attr('id');
        if(interval.trim()=='Monthly View'){
            interval='monthly';
        }else{
            interval='daily';
        }
        name= name.replace("Btn", ""); 
        selectDataset(interval,start_date, end_date);
    }); 
}
 
  
// function getDateFormat(interval){
//     if(interval == 'monthly'){
//         dateAxis.dateFormats.setKey("month", "MMM");
//     }else if(interval == 'daily'){
//         dateAxis.dateFormats.setKey("day", "eee");
//     } 
// }

// function getPeriodChangeDateFormat(interval){
//     if(interval == 'monthly'){
//         dateAxis.periodChangeDateFormats.setKey("month", "MMM"); 
//     }else if(interval == 'daily'){
//         dateAxis.periodChangeDateFormats.setKey("day", "eee"); 
//     } 
// }
</script>