<div class="earring-table sale_detail_main table-responsive">
    <table class="table stock-detail sale-detail">
        <thead>
            <tr>
                <th>@sortablelink('Date', __('content.date'))</th>
                <th>{{ __('content.invoice_id') }}</th>
                <th>{{ __('content.description') }}</th>
                <th>{{ __('content.amount') }}</th>
                <th>{{ __('content.customer') }}</th>
                <th>{{ __('content.action') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($invoiceListings as $invoiceItem)
            <tr>
                <td>{{ ($invoiceItem->invoice->reference_date) ? date('d/m/Y', strtotime($invoiceItem->invoice->reference_date)) : '-' }}</td>
                <td>{{ $invoiceItem->invoice_id ?? '-' }}</td>
                <td>{{ $invoiceItem->description ?? '-' }}</td>
                <td>{{ isset($invoiceItem->sub_total) ? '$'.$invoiceItem->sub_total : '-' }}</td>
                <td>{{ isset($invoiceItem->invoice->customer_name) ? ucwords($invoiceItem->invoice->customer_name) : (isset($invoiceItem->invoice->customer_id) ? $invoiceItem->invoice->customer->fullname : '-') }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary down" type="button"
                            id="dropdownMenuButton1" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            Action
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">
                            <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                            <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                            <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                            </li>
                        </ul>
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td class="text-center" colspan="6">No Record Found!</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>