@extends('layouts.admin.default')

@section('title',"Dashboard")

@section('header',"Dashboard")

@section('breadcrumb')
    @parent
    <li class="breadcrumb-item active" aria-current="page"> Dashboard</li>
@endsection

@section('content')


<div class="card mb-4 border_rd_12">
    <div class="card-header Job-dash ">
        <h4 class="mb-0">Dashboard</h4>
        <p>This section shows an overview of Sancy ERP System</p>
    </div>
</div>

<div class="card mb-4 report">
    <div class="row">
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Jobs</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getTotalJobsCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportTotalJobs') }}" data-heading="All Jobs">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Completed Jobs</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getCompletedJobsCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportCompletedJobs') }}" data-heading="Completed Jobs">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Quotation</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getTotalQuotationsCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportTotalQuotations') }}" data-heading="Total Quotations">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Invoice</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getTotalInvoicesCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportTotalInvoices') }}" data-heading="Total Invoices">Report</button>
            </div>
        </div>
    </div>
</div>

<div class="card details mb-4 report job_conversion">
    <div class="row">
        <div class="col-lg-6 ">
            <div class="card-header Job-dash border_rd_12">
                <h4 class="mb-0">Quotation Conversion</h4>
                <div class="row justify-content-between">
                    <div class="col-lg-7 pt-4 align-self-center">
                        <div class="conversion d-flex align-items-center justify-content-between">
                            <div class="conversion_quot"></div>
                            <h6 class="m-0">All Quotaion</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div>
                        <div class="conversion d-flex align-items-center justify-content-between pt-5">
                            <div class="conversion_quot invoice"></div>
                            <h6 class="m-0">Invoice</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div id="quotationPieChart" class="job_conversion_chart">
                            <!-- <img src="{{ asset('public/img/Pie Chart_job.png') }}" class="img-fluid ms-auto"> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card-header Job-dash border_rd_12">
                <h4 class="mb-0">Job Completion</h4>
                <div class="row justify-content-between">
                    <div class="col-lg-7 pt-4 align-self-center">
                        <div class="conversion d-flex align-items-center justify-content-between">
                            <div class="conversion_quot"></div>
                            <h6 class="m-0">All Jobs</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div>
                        <div class="conversion d-flex align-items-center justify-content-between pt-5">
                            <div class="conversion_quot invoice"></div>
                            <h6 class="m-0">Completed</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="job_conversion_chart">
                            <img src="{{ asset('public/img/Pie Chart_job.png') }}" class="img-fluid">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card details mb-4 report graph_chart">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Sales By Category</h4>
            <div class="dropdown quotation_dropdown">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                Monthly View
                </button>
                <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#">Monthly view</a></li>
                <li><a class="dropdown-item" href="#">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">From</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">To</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="graph_chart_detail">
            <img src="{{ asset('public/img/Chart Container.png') }}" class="img-fluid w-100">
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Quotation</h4>
            <div class="dropdown quotation_dropdown viewDropdown">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="quotationBtn">
                Monthly View
                </button>
                <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="javascript:void(0);" id="monthlyQuotations" data-interval="monthly" data-name="quotation">Monthly view</a></li>
                <li><a class="dropdown-item" href="javascript:void(0);" id="dailyQuotations" data-interval="daily" data-name="quotation">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">From</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">To</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="graph_chart_detail" id="quotationColumnChart">
            <!-- <img src="{{-- asset('public/img/Chart Container.png') --}}" class="img-fluid w-100"> -->
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart border_rd_12">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Recent Invoice</h4>
            <div class="dropdown quotation_dropdown">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                Monthly View
                </button>
                <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#">Monthly view</a></li>
                <li><a class="dropdown-item" href="#">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">From</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">To</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="recent_invoice">
            <div class="today_sale_detail">
                <div class="card-body">
                    <div class="earring-table sale_detail_main table-responsive">
                        <table class="table stock-detail sale-detail">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Invoice # 发票 ID</th>
                                    <th>Description</th>
                                    <th>Amount</th>
                                    <th>Customer</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>11/02/2022</td>
                                    <td>20938022</td>
                                    <td>18k White Girl Diamond Pendant (Small) Link chain</td>
                                    <td>$1000,00</td>
                                    <td>Thomas Shelby</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button"
                                                id="dropdownMenuButton1" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">
                                                <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>11/02/2022</td>
                                    <td>20938022</td>
                                    <td>18k White Girl Diamond Pendant (Small) Link chain</td>
                                    <td>$1000,00</td>
                                    <td>Thomas Shelby</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button"
                                                id="dropdownMenuButton1" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">
                                                <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>11/02/2022</td>
                                    <td>20938022</td>
                                    <td>18k White Girl Diamond Pendant (Small) Link chain</td>
                                    <td>$1000,00</td>
                                    <td>Thomas Shelby</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button"
                                                id="dropdownMenuButton1" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">
                                                <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>11/02/2022</td>
                                    <td>20938022</td>
                                    <td>18k White Girl Diamond Pendant (Small) Link chain</td>
                                    <td>$1000,00</td>
                                    <td>Thomas Shelby</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button"
                                                id="dropdownMenuButton1" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">
                                                <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>11/02/2022</td>
                                    <td>20938022</td>
                                    <td>18k White Girl Diamond Pendant (Small) Link chain</td>
                                    <td>$1000,00</td>
                                    <td>Thomas Shelby</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button"
                                                id="dropdownMenuButton1" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">
                                                <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>  
</div>


@include('admin.elements.exports.common_report_modal')

@include('admin.elements.exports.common_reports_script')

<!-- amchart -->
<script src="https://cdn.amcharts.com/lib/4/core.js"></script>
<script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
<script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
<script src="https://www.amcharts.com/lib/4/themes/amcharts.js"></script>

<script>
    /**
 * ---------------------------------------
 * This demo was created using amCharts 4.
 *
 * For more information visit:
 * https://www.amcharts.com/
 *
 * Documentation is available at:
 * https://www.amcharts.com/docs/v4/
 * ---------------------------------------
 */

// Set theme
am4core.useTheme(am4themes_animated);

// Create chart instance
var quotationPiechart = am4core.create("quotationPieChart", am4charts.PieChart);

// Let's cut a hole in our Pie chart the size of 40% the radius
quotationPiechart.innerRadius = am4core.percent(40);

// Add data
quotationPiechart.data = [
{
  "country": "Dummy",
  "litres": 100,
  "bottles": 100,
  "disabled": true,
  "color": am4core.color("#dadada"), // #dadada
  "opacity": 0.3,
  "strokeDasharray": "4,4",
  "tooltip": ""
},
{
  "country": "Lithuania",
  "litres": 100,
  "bottles": 100,
}
// , {
//   "country": "Czechia","litres": 301.9,"bottles": 990
// }, {"country": "Ireland","litres": 201.1,"bottles": 785
// }, {
//   "country": "Germany","litres": 165.8,"bottles": 255
// }, {
//   "country": "Australia","litres": 139.9,"bottles": 452
// }, {
//   "country": "Austria","litres": 128.3,"bottles": 332
// }, {
//   "country": "UK","litres": 99,"bottles": 150
// }, {
//   "country": "Belgium","litres": 60,"bottles": 178
// }, {
//   "country": "The Netherlands","litres": 50,"bottles": 50
// }
];

// Add and configure Series
var pieSeries = quotationPiechart.series.push(new am4charts.PieSeries());
pieSeries.dataFields.value = "litres";
pieSeries.dataFields.category = "country";
pieSeries.slices.template.stroke = am4core.color("#0F172A");
pieSeries.slices.template.strokeWidth = 2;
pieSeries.slices.template.strokeOpacity = 1;

pieSeries.labels.template.disabled = true;
pieSeries.slices.template.fill = am4core.color('#0F172A');

// Disabling labels and ticks on inner circle
pieSeries.labels.template.disabled = false; // true
pieSeries.ticks.template.disabled = false; // true

// Disable sliding out of slices
pieSeries.slices.template.states.getKey("hover").properties.shiftRadius = 0;
pieSeries.slices.template.states.getKey("hover").properties.scale = 0.9;

// Add second series
var pieSeries2 = quotationPiechart.series.push(new am4charts.PieSeries());
pieSeries2.dataFields.value = "bottles";
pieSeries2.dataFields.category = "country";
pieSeries2.slices.template.stroke = am4core.color("#CBD5E1"); // 0F172A
pieSeries2.slices.template.strokeWidth = 2;
pieSeries2.slices.template.strokeOpacity = 1;
pieSeries2.slices.template.states.getKey("hover").properties.shiftRadius = 0;
pieSeries2.slices.template.states.getKey("hover").properties.scale = 1.1;

pieSeries2.labels.template.disabled = true;
pieSeries2.slices.template.fill = am4core.color('#CBD5E1');

//--------------------- Placeholder Starts Here --------------------
/* Set up slice1 appearance */
var slice1 = pieSeries.slices.template;
slice1.propertyFields.fill = "color"; // am4core.color("#dadada");
slice1.propertyFields.fillOpacity = "opacity"; // 0.3;
slice1.propertyFields.stroke = "color";
slice1.propertyFields.strokeDasharray = "strokeDasharray"; // "4,4";
slice1.propertyFields.tooltipText = "tooltip";

// pieSeries.labels.template.propertyFields.disabled = "disabled";
// pieSeries.ticks.template.propertyFields.disabled = "disabled";

// Hiding dummy slice from legend
pieSeries.dataFields.hiddenInLegend = "disabled";

/* Set up slice2 appearance */
var slice2 = pieSeries2.slices.template;
slice2.propertyFields.fill = "color"; // am4core.color("#dadada");
slice2.propertyFields.fillOpacity = "opacity"; // 0.3;
slice2.propertyFields.stroke = "color";
slice2.propertyFields.strokeDasharray = "strokeDasharray"; // "4,4";
slice2.propertyFields.tooltipText = "tooltip";

// pieSeries2.labels.template.propertyFields.disabled = "disabled";
// pieSeries2.ticks.template.propertyFields.disabled = "disabled";

// Hiding dummy slice from legend
pieSeries2.dataFields.hiddenInLegend = "disabled";
// ---------------------- Placeholder Ends Here --------------------
</script>


<script>
// https://www.amcharts.com/demos-v4/simple-column-chart-v4/
// am4core.ready(function() {

    // Themes begin
    am4core.useTheme(am4themes_animated);
    // Themes end

    // Create chart instance
    var chart = am4core.create("quotationColumnChart", am4charts.XYChart);

    chart.dateFormatter.inputDateFormat = "yyyy-MM";

    // Add data
    chart.data = getChartData();

    // Create axes

    var categoryAxis = chart.xAxes.push(new am4charts.DateAxis());
    categoryAxis.dataFields.category = "month";
    categoryAxis.renderer.grid.template.location = 0;
    categoryAxis.renderer.minGridDistance = 2; //30
    categoryAxis.renderer.grid.template.disabled = true; 


    categoryAxis.dateFormats.setKey("month", "MMM");
    // PERIOD CHANGE FORMAT
    categoryAxis.periodChangeDateFormats.setKey("month", "MMM"); 

    categoryAxis.renderer.labels.template.adapter.add("dy", function(dy, target) {
      if (target.dataItem && target.dataItem.index & 2 == 2) {
        return dy + 25;
      }
      return dy;
    });

    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

    // Create series
    var series = chart.series.push(new am4charts.ColumnSeries());
    series.dataFields.valueY = "counts";
    series.dataFields.dateX = "month";
    series.name = "counts";
    series.columns.template.tooltipText = "{categoryX}: [bold]{valueY}[/]";
    series.columns.template.fillOpacity = .8;

    series.columns.template.stroke = am4core.color('#DAB198'); // Border Color
    series.columns.template.fill = '#DAB198'; // Background Color

    var columnTemplate = series.columns.template;
    columnTemplate.strokeWidth = 1; // 2
    columnTemplate.strokeOpacity = 1;

// }); // end am4core.ready()

function getChartData($interval=null){
    if(interval = 'monthly'){
        return  [{
          "month": "2022-01",
          "counts": 550
        }, {
          "month": "2022-02",
          "counts": 1000
        }];
    }else if(interval == 'daily'){
        return[{
          "month": "2022-01",
          "counts": 2025
        }];
    }else{
        return [{
          "month": "2022-01",
          "counts": 2025
        }, {
          "month": "2022-02",
          "counts": 1809
        }, {
          "month": "2022-03",
          "counts": 1114
        }, {
          "month": "2022-04",
          "counts": 7110
        }, {
          "month": "2022-05",
          "counts": 8580
        }];
    }
}
</script>

<script>
$('.viewDropdown li a').on('click', function(){
    var _this=$(this);
    var name = $(this).data('name');
    alert('name : '+name);
    var interval = $(this).data('interval');
    alert('interval : '+interval);

    if(name == 'quotation'){
        $('#quotationBtn').html(interval.charAt(0).toUpperCase()+interval.slice(1)+' View');
        // chart.data = data1;
        // if(interval == 'daily'){
            getChartData(interval);
        // }else if(interval == 'monthly'){
        //     cgetChartData();
        // }
    }
    // $("#dropdownMenuButton1").text(selected_val);
    // $(_this).parent('li').siblings().removeClass("active_select");
    // $(_this).parent('li').addClass("active_select");
});
</script>
@endsection
