@extends('layouts.admin.default')

@section('title',"Dashboard")

@section('header',"Dashboard")

@section('breadcrumb')
    @parent
    <li class="breadcrumb-item active" aria-current="page"> Dashboard</li>
@endsection

@section('content')


<div class="card mb-4 border_rd_12">
    <div class="card-header Job-dash ">
        <h4 class="mb-0">Dashboard</h4>
        <p>This section shows an overview of Sancy ERP System</p>
    </div>
</div>

<div class="card mb-4 report">
    <div class="row">
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Jobs</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getTotalJobsCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportTotalJobs') }}" data-heading="All Jobs">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Completed Jobs</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getCompletedJobsCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportCompletedJobs') }}" data-heading="Completed Jobs">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Quotation</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getTotalQuotationsCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportTotalQuotations') }}" data-heading="Total Quotations">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Invoice</label>
                    <a href="#"><img src="{{ asset('public/img/up-down.png') }}" />+2.0%</a>
                </div>
                <h4>{{ getTotalInvoicesCount() }}</h4>
                <!-- <button class="btn cus_btn">Report</button> -->
                <button class="btn cus_btn" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="{{ route('admin.dashboard.exportTotalInvoices') }}" data-heading="Total Invoices">Report</button>
            </div>
        </div>
    </div>
</div>

<div class="card details mb-4 report job_conversion">
    <div class="row">
        <div class="col-lg-6 ">
            <div class="card-header Job-dash border_rd_12">
                <h4 class="mb-0">Quotation Conversion</h4>
                <div class="row justify-content-between">
                    <div class="col-lg-7 pt-4 align-self-center" id="quotationDonutChartLegend">
                        <!-- <div class="conversion d-flex align-items-center justify-content-between">
                            <div class="conversion_quot"></div>
                            <h6 class="m-0">All Quotaion</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div>
                        <div class="conversion d-flex align-items-center justify-content-between pt-5">
                            <div class="conversion_quot invoice"></div>
                            <h6 class="m-0">Invoice</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div> -->
                    </div>
                    <div class="col-lg-5">
                        <div id="quotationDonutChart" class="job_conversion_chart">
                            <!-- <img src="{{ asset('public/img/Pie Chart_job.png') }}" class="img-fluid ms-auto"> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card-header Job-dash border_rd_12">
                <h4 class="mb-0">Job Completion</h4>
                <div class="row justify-content-between">
                    <div class="col-lg-7 pt-4 align-self-center" id="jobDonutChartLegend">
                       <!--  <div class="conversion d-flex align-items-center justify-content-between">
                            <div class="conversion_quot"></div>
                            <h6 class="m-0">All Jobs</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div>
                        <div class="conversion d-flex align-items-center justify-content-between pt-5">
                            <div class="conversion_quot invoice"></div>
                            <h6 class="m-0">Completed</h6>
                            <p>200</p>
                            <p>100%</p>
                        </div> -->
                    </div>
                    <div class="col-lg-5">
                        <div id="jobDonutChart" class="job_conversion_chart">
                            <!-- <img src="{{-- asset('public/img/Pie Chart_job.png') --}}" class="img-fluid"> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card details mb-4 report graph_chart">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Sales By Category</h4>
            <div class="dropdown quotation_dropdown viewDropdown" id="viewDropdownSale">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="saleBtn" >
                Monthly View
                </button>
                <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="javascript:void(0);" id="monthlySales" data-interval="monthly" data-name="sale">Monthly view</a></li>
                <li><a class="dropdown-item" href="javascript:void(0);" id="dailySales" data-interval="daily" data-name="sale">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">From</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">To</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="graph_chart_detail" id="saleColumnChart">
            <!-- <img src="{{-- asset('public/img/Chart Container.png') --}}" class="img-fluid w-100"> -->
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Quotation</h4>
            <div class="dropdown quotation_dropdown viewDropdown" id="viewDropdownQuatition">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="quotationBtn">
                Monthly View
                </button>
                <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="javascript:void(0);" id="monthlyQuotations" data-interval="monthly" data-name="quotation">Monthly view</a></li>
                <li><a class="dropdown-item" href="javascript:void(0);" id="dailyQuotations"  data-interval="daily" data-name="quotation">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">From</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">To</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="graph_chart_detail" id="quotationColumnChart">
            <!-- <img src="{{-- asset('public/img/Chart Container.png') --}}" class="img-fluid w-100"> -->
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Invoice</h4>
            <div class="dropdown quotation_dropdown viewDropdown" id="viewDropdownInvoice">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="invoiceBtn" >
                Monthly View
                </button>
                <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="javascript:void(0);" id="monthlyInvoices" data-interval="monthly" data-name="invoice">Monthly view</a></li>
                <li><a class="dropdown-item" href="javascript:void(0);" id="dailyInvoices" data-interval="daily" data-name="invoice">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">From</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">To</label>
                    <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="graph_chart_detail" id="invoiceColumnChart">
            <!-- <img src="{{-- asset('public/img/Chart Container.png') --}}" class="img-fluid w-100"> -->
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart border_rd_12">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Recent Invoice</h4>
            <div class="dropdown quotation_dropdown">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                Monthly View
                </button>
                <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#">Monthly view</a></li>
                <li><a class="dropdown-item" href="#">Daily View</a></li>
                </ul>
            </div>
            <form method="get" class="ajaxForm" action="{{ url()->current() }}" id="AjaxFilter" autocomplete="off">
                <div class="d-flex align-items-center quotation_date">
                    <div class="d-flex align-items-center pe-3">
                        <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">From</label>
                        <input type="date" name="invoice_start_date" class="form-control dateFilter" id="invoice_start_date" placeholder="mm/yyyy">
                    </div>
                    <div class="d-flex align-items-center">
                        <label for="exampleFormControlInput1" class="form-label pe-2 mb-0">To</label>
                        <input type="date" name="invoice_end_date" class="form-control dateFilter" id="invoice_end_date" placeholder="mm/yyyy">
                    </div>
                </div>
            </form>
        </div>
        <div class="recent_invoice">
            <div class="today_sale_detail">
                <div class="card-body">
                    <div class="earring-table sale_detail_main table-responsive">
                        <table class="table stock-detail sale-detail">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Invoice # 发票 ID</th>
                                    <th>Description</th>
                                    <th>Amount</th>
                                    <th>Customer</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoiceListings as $invoiceItem)
                                <tr>
                                    <td>{{ ($invoiceItem->invoice->reference_date) ? date('d/m/Y', strtotime($invoiceItem->invoice->reference_date)) : '-' }}</td>
                                    <td>{{ $invoiceItem->invoice->invoice_no ?? '-' }}</td>
                                    <td>{{ $invoiceItem->description ?? '-' }}</td>
                                    <td>{{ isset($invoiceItem->price) ? '$'.$invoiceItem->price : '-' }}</td>
                                    <td>{{ isset($invoiceItem->invoice->customer_name) ? ucwords($invoiceItem->invoice->customer_name) : (isset($invoiceItem->invoice->customer_id) ? $invoiceItem->invoice->customer->fullname : '-') }}</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button"
                                                id="dropdownMenuButton1" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">
                                                <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                                                <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td class="text-center" colspan="6">No Record Found!</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>  
</div>


@include('admin.elements.exports.common_report_modal')

@include('admin.elements.exports.common_reports_script')

<!-- amchart -->
<script src="https://cdn.amcharts.com/lib/4/core.js"></script>
<script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
<script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
<script src="https://www.amcharts.com/lib/4/themes/amcharts.js"></script>

<script>
    /**
 * ---------------------------------------
 * This demo was created using amCharts 4.
 *
 * For more information visit:
 * https://www.amcharts.com/
 *
 * Documentation is available at:
 * https://www.amcharts.com/docs/v4/
 * ---------------------------------------
 */

// Set theme
am4core.useTheme(am4themes_animated);

// Add data
donutChartData1 = [
    {
      "name": "Dummy",
      "all_quotation": 100,
      "invoice": 100,
      "disabled": true,
      "color": am4core.color("#dadada"), // #dadada
      "opacity": 0.3,
      "strokeDasharray": "4,4",
      "tooltip": ""
    },
    {
      "name": "Quotation Conversion",
      "all_quotation": '{{ getTotalQuotationsCount() }}',
      "invoice": '{{ getConvertedInvoicesCount() }}',
    }
    // , {
    //   "country": "Czechia","litres": 301.9,"bottles": 990
    // }
];


donutChartData2 = [
    {
      "name": "Dummy",
      "all_jobs": 100,
      "completed_jobs": 100,
      "disabled": true,
      "color": am4core.color("#dadada"), // #dadada
      "opacity": 0.3,
      "strokeDasharray": "4,4",
      // "tooltip": ""
    },
    {
      "name": "Job Completion",
      "all_jobs": '{{ getTotalJobsCount() }}',
      "completed_jobs": '{{ getCompletedJobsCount() }}',
    }
    // , {
    //   "country": "Czechia","litres": 301.9,"bottles": 990
    // }
];
console.log('donutChartData1', donutChartData1);
console.log('donutChartData2', donutChartData2);

// Create chart instance
var donutChart1 = am4core.create("quotationDonutChart", am4charts.PieChart);
var donutChart2 = am4core.create("jobDonutChart", am4charts.PieChart); 

drawNestedDonutChart(donutChart1, donutChartData1, 'quotation');
drawNestedDonutChart(donutChart2, donutChartData2, 'job');

function drawNestedDonutChart(chart, data, chart_for){
    // Let's cut a hole in our Pie chart the size of 40% the radius
    chart.innerRadius = am4core.percent(40);

    chart.data = data;

    // Add and configure Series
    var donutChartSeries1 = chart.series.push(new am4charts.PieSeries());
    donutChartSeries1.dataFields.value = getValue1Name(chart_for);
    donutChartSeries1.dataFields.category = getCategoryName(chart_for);
    donutChartSeries1.slices.template.stroke = am4core.color("#0F172A");
    donutChartSeries1.slices.template.strokeWidth = 2;
    // donutChartSeries1.slices.template.strokeOpacity = 1;

    donutChartSeries1.labels.template.disabled = true;
    donutChartSeries1.slices.template.fill = am4core.color('#0F172A');

    // Disabling labels and ticks on inner circle
    donutChartSeries1.labels.template.disabled = false; // true
    donutChartSeries1.ticks.template.disabled = false; // true

    // Disable sliding out of slices
    donutChartSeries1.slices.template.states.getKey("hover").properties.shiftRadius = 0;
    donutChartSeries1.slices.template.states.getKey("hover").properties.scale = 0.9;


    // Add second series
    var donutChartSeries2 = chart.series.push(new am4charts.PieSeries());
    donutChartSeries2.dataFields.value = getValue2Name(chart_for);
    donutChartSeries2.dataFields.category = getCategoryName(chart_for);
    donutChartSeries2.slices.template.stroke = am4core.color("#CBD5E1"); // 0F172A
    donutChartSeries2.slices.template.strokeWidth = 2;
    // donutChartSeries2.slices.template.strokeOpacity = 1;
    donutChartSeries2.slices.template.states.getKey("hover").properties.shiftRadius = 0;
    donutChartSeries2.slices.template.states.getKey("hover").properties.scale = 1.1;

    donutChartSeries2.labels.template.disabled = true;
    donutChartSeries2.slices.template.fill = am4core.color('#CBD5E1');

    //--------------------- Placeholder Starts Here --------------------
    /* Set up slice1 appearance */
    var slice1 = donutChartSeries1.slices.template;
    slice1.propertyFields.fill = "color"; // am4core.color("#dadada");
    slice1.propertyFields.fillOpacity = "opacity"; // 0.3;
    slice1.propertyFields.stroke = "color";
    slice1.propertyFields.strokeDasharray = "strokeDasharray"; // "4,4";
    slice1.propertyFields.tooltipText = `{category}[/]
                                        ----
                                        ${getValue1Name(chart_for)}: {percent}%`;
    // getValue1Name(chart_for)+": {percent}%"; // "tooltip";

    // donutSeries.labels.template.propertyFields.disabled = "disabled";
    // donutSeries.ticks.template.propertyFields.disabled = "disabled";

    // Hiding dummy slice from legend
    donutChartSeries1.dataFields.hiddenInLegend = "disabled";

    /* Set up slice2 appearance */
    var slice2 = donutChartSeries2.slices.template;
    slice2.propertyFields.fill = "color"; // am4core.color("#dadada");
    slice2.propertyFields.fillOpacity = "opacity"; // 0.3;
    slice2.propertyFields.stroke = "color";
    slice2.propertyFields.strokeDasharray = "strokeDasharray"; // "4,4";
    // slice2.propertyFields.tooltipText = "{getValue2Name(chart_for)}: {percent}%"; // "tooltip";
    // slice2.propertyFields.tooltipHTML = `<center>
    //                                         <strong>{category}</strong>
    //                                     </center>
    //                                     <hr />
    //                                     <table>
    //                                         <tr>
    //                                           <th align="left">${getValue2Name(chart_for)}</th>
    //                                           <td>{percent}%</td>
    //                                         </tr> 
    //                                     </table>
    //                                     <hr />`;
    // slice2.template.tooltipText = `<center>
    //                                         <strong>{category}</strong>
    //                                     </center>
    //                                     <hr />
    //                                     <table>
    //                                         <tr>
    //                                           <th align="left">${getValue2Name(chart_for)}</th>
    //                                           <td>{percent}%</td>
    //                                         </tr> 
    //                                     </table>
    //                                     <hr />`;

    // donutChartSeries2.labels.template.propertyFields.disabled = "disabled";
    // donutChartSeries2.ticks.template.propertyFields.disabled = "disabled";

    // Hiding dummy slice from legend
    donutChartSeries2.dataFields.hiddenInLegend = "disabled";


    //-------------------------------------------------------
    // chart.legend.dispose();
    /* Create legend */
    chart.radius = am4core.percent(100); // 95

    // Create custom legend
    chart.events.on("ready", function(event) {
        // populate our custom legend when chart renders
        var legendName = chart_for+'DonutChartLegend';
        console.log('legendName', legendName);
        legendName.html = '';
        chart.customLegend = document.getElementById(legendName);
        // chart.customLegend.innerHTML = '<p>Hiiiiiiiiiiiiiiiiiiiii</p>';

        console.log('series : '+chart.series);
        console.log('series counts : '+Object.keys(chart.series).length);

        donutChartSeries1.dataItems.each(function(row, i) {
            console.log('i : '+i);
            console.log('row : '+row);

            var percent = Math.round(row.values.value.percent * 100) / 100;
            var value = row.value;
            console.log('value', value);

            chart.customLegend.innerHTML += `<div id="legend-item-${i}" class="conversion d-flex align-items-center justify-content-between">
                <div id="color-${i}" class="conversion_quot" style="background-color:pink;"></div>
                <h6 class="m-0">${row.category}</h6>
                <p>${value}</p>
                <p>${percent}%</p>
            </div>`;
        });
    });

    //-------------------------------------------------------

    // // Create custom legend
    // chart.events.on("ready", function(event) {
    //   // populate our custom legend when chart renders
    //   chart.customLegend = document.getElementById(chart_for+'DonutChartLegend');

    //     chart.dataItems.each(function(row, i) {
    //         console.log('i : '+i);
    //         console.log('row : '+row);

    //         // var percent = Math.round(row.values.value.percent * 100) / 100;
    //         // var value = row.value;

    //         // legend.innerHTML += `<div id="legend-item-${i}" class="conversion d-flex align-items-center justify-content-between">
    //         //     <div id="color-${i}" class="conversion_quot" style="background-color:${color};"></div>
    //         //     <h6 class="m-0">${row.category}</h6>
    //         //     <p>${value}</p>
    //         //     <p>${percent}%</p>
    //         // </div>`;
    //     });
    // });

    function getCategoryName(chart_for){
        if(chart_for == 'quotation'){
            return 'name'; 
        }else if(chart_for == 'job'){
            return 'name';
        } 
    } 

    function getValue1Name(chart_for){
        if(chart_for == 'quotation'){
            return 'all_quotation'; 
        }else if(chart_for == 'job'){
            return 'all_jobs'; 
        } 
    }

    function getValue2Name(chart_for){
        if(chart_for == 'quotation'){
            return 'invoice'; 
        }else if(chart_for == 'job'){
            return 'completed_jobs'; 
        } 
    }

    // ---------------------- Placeholder Ends Here --------------------
}
</script>


<script>
/**
 * ---------------------------------------
 * This demo was created using amCharts 4.
 *
 * For more information visit:
 * https://www.amcharts.com/
 *
 * Documentation is available at:
 * https://www.amcharts.com/docs/v4/
 * ---------------------------------------
 */

// var data = {
//   "set1": [{
//     "monthname": "2022-01",
//     "count": 450
//   }, {
//     "monthname": "2022-02",
//     "count": 1200
//   }, {
//     "monthname": "2022-03",
//     "count": 1850
//   }],
//   "set2": [{
//     "monthname": "2022-01-05",
//     "count": 950
//   }, {
//     "monthname": "2022-01-10",
//     "count": 850
//   }, {
//     "monthname": "2022-01-15",
//     "count": 1200
//   }],
//   "set3": [{
//     "monthname": "2022-02",
//     "count": 300
//   }, {
//     "monthname": "2022-04",
//     "count": 489
//   }, {
//     "monthname": "2022-09",
//     "count": 100
//   }],
// }

var data1 = {!! json_encode($saleData) !!};
var data2 = {!! json_encode($quotationData) !!};
var data3 = {!! json_encode($invoiceData) !!};

am4core.useTheme(am4themes_animated);

// Create chart instance
var chart1 = am4core.create("saleColumnChart", am4charts.XYChart);
var chart2 = am4core.create("quotationColumnChart", am4charts.XYChart);
var chart3 = am4core.create("invoiceColumnChart", am4charts.XYChart);

drawXYChart(chart1, data1, 'sale', 'viewDropdownSale');
drawXYChart(chart2, data2, 'quotation', 'viewDropdownQuatition');
drawXYChart(chart3, data3, 'invoice', 'viewDropdownInvoice');
// chart.dateFormatter.inputDateFormat = "yyyy-MM";

function drawXYChart(chart, data, chartName, list_options){
    // Add data
    // chart.data = data.set1;
    chart.data = data.monthly;

    // Create axes
    // var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
    // dateAxis.dataFields.category = getXAxisVariableName('monthly');
    // getMinGridDistance('monthly');
    // dateAxis.renderer.grid.template.location = 0.0001;  // To make DateAxis distinguish from user-set zero from default zero, set it to a value that is very close to zero, say, 0.0001
    // dateAxis.renderer.grid.template.disabled = true; 

    // dateAxis.renderer.minLabelPosition = 0; // 0    0.05;
    // dateAxis.renderer.maxLabelPosition = 1; // 1    0.95;
    // // dateAxis.renderer.labels.locationX = 0.5;

    // dateAxis.renderer.inside = false; 
    // dateAxis.renderer.labels.template.horizontalCenter = "middle";
    // dateAxis.renderer.labels.template.verticalCenter = "middle";
    // dateAxis.tooltip.disabled = true;

    // // dateAxis.renderer.labels.template.fontWeight = "bold"; //font weight
    // dateAxis.renderer.labels.template.fontSize = 12; //font size

    var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
    getXAxisFieldName(chartName, 'monthly');
    getMinGridDistance(chartName, 'monthly');
    categoryAxis.renderer.grid.template.location = 0.0001;  // To make DateAxis distinguish from user-set zero from default zero, set it to a value that is very close to zero, say, 0.0001
    categoryAxis.renderer.grid.template.disabled = true; 

    categoryAxis.renderer.minLabelPosition = 0; // 0    0.05;
    categoryAxis.renderer.maxLabelPosition = 1; // 1    0.95;
    // dateAxis.renderer.labels.locationX = 0.5;

    categoryAxis.renderer.inside = false; 
    categoryAxis.renderer.labels.template.horizontalCenter = "middle";
    categoryAxis.renderer.labels.template.verticalCenter = "middle";
    categoryAxis.tooltip.disabled = true;

    // dateAxis.renderer.labels.template.fontWeight = "bold"; //font weight
    categoryAxis.renderer.labels.template.fontSize = 12; //font size
    getNoOfTicks(chartName, 'monthly');

    // getDateFormat('monthly');
    // // PERIOD CHANGE FORMAT
    // getPeriodChangeDateFormat('monthly');

    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

    // Create series
    var series = chart.series.push(new am4charts.ColumnSeries());
    series.dataFields.valueY = "count";
    // series.dataFields.dateX = getXAxisVariableName('monthly');
    getSeriecCategoryAxisFieldName(chartName, 'monthly');

    series.name = "counts";
    series.columns.template.tooltipText = "{categoryX}: [bold]{valueY}[/]";
    series.columns.template.fillOpacity = 1;

    series.columns.template.stroke = am4core.color('#DAB198'); // Border Color
    series.columns.template.fill = '#DAB198'; // Background Color
    let columnWidth = (chartName == 'sale') ? 23 : 10;
    series.columns.template.width = am4core.percent(columnWidth);

    var columnTemplate = series.columns.template;
    columnTemplate.strokeWidth = 1; // 2
    columnTemplate.strokeOpacity = 1;

    $('#'+list_options+' li a').on('click', function(){
        var _this = $(this);
        var name = $(this).data('name');
        // alert('name : '+name);
        var interval = $(this).data('interval');
        //  alert('interval : '+interval);

        $('#'+name+'Btn').html(interval.charAt(0).toUpperCase()+interval.slice(1)+' View');
        // if(interval == 'monthly'){
        //     selectDataset('set1');
        // }else{
        //     selectDataset('set2'); 
        // }
        
        selectDataset(interval);
        // getDateFormat(interval);
        // getPeriodChangeDateFormat(interval);
        getXAxisFieldName(name, interval);
        getSeriecCategoryAxisFieldName(name, interval);
    });

    function getXAxisFieldName(name, interval){
        if(name == 'sale'){
            categoryAxis.dataFields.category = 'name'; 
        }else{
            if(interval == 'monthly'){
                categoryAxis.dataFields.category = 'monthname'; 
            }else if(interval == 'daily'){
                categoryAxis.dataFields.category = 'dayname';
            }
        }
    }

    function getMinGridDistance(name, interval){
        if(name == 'sale'){
            categoryAxis.renderer.minGridDistance = 7;
        }else{
            if(interval == 'monthly'){
                // dateAxis.renderer.minGridDistance = 12;
                categoryAxis.renderer.minGridDistance = 12;
            }else if(interval == 'daily'){
                // dateAxis.renderer.minGridDistance = 30; 
                categoryAxis.renderer.minGridDistance = 30; 
            } 
        }
    }

    function getNoOfTicks(name, interval){
        if(name == 'sale'){
            categoryAxis.renderer.ticks.template.length = 6; // No. of ticks
        }else{
            if(interval == 'monthly'){
                // dateAxis.renderer.ticks.template.length = 11; // No. of ticks
                categoryAxis.renderer.ticks.template.length = 11; // No. of ticks
            }else if(interval == 'daily'){
                // dateAxis.renderer.ticks.template.length = 6; // No. of ticks
                categoryAxis.renderer.ticks.template.length = 6; // No. of ticks
            }
        }
    }

    function getSeriecCategoryAxisFieldName(name, interval){
        if(name == 'sale'){
            series.dataFields.categoryX = 'name'; 
        }else{
            if(interval == 'monthly'){
                series.dataFields.categoryX = 'monthname'; 
            }else if(interval == 'daily'){
                series.dataFields.categoryX = 'dayname';
            } 
        }
    }

    function selectDataset(set) {
        console.log(set, data[set])
        chart.data = data[set];
    }
}


// function getDateFormat(interval){
//     if(interval == 'monthly'){
//         dateAxis.dateFormats.setKey("month", "MMM");
//     }else if(interval == 'daily'){
//         dateAxis.dateFormats.setKey("day", "eee");
//     } 
// }

// function getPeriodChangeDateFormat(interval){
//     if(interval == 'monthly'){
//         dateAxis.periodChangeDateFormats.setKey("month", "MMM"); 
//     }else if(interval == 'daily'){
//         dateAxis.periodChangeDateFormats.setKey("day", "eee"); 
//     } 
// }
</script>

<script>
    $(document).on('ready', function(){
        $('.dateFilter').on('blur', function(){ // input change
            // e.preventDefault();
            alert('date : '+$(this).val());
            $("#AjaxFilter").submit();
        });
    });
</script>
@endsection
