<div class="earring-table sale_detail_main table-responsive">
    <table class="table stock-detail sale-detail">
        <thead>
            <tr>
                <th>@sortablelink('reference_date', __('content.date'))</th>
                <th>@sortablelink('id', __('content.invoice_id'))</th>
                <th>@sortablelink('total', __('content.amount'))</th>
                <th>{{ __('content.paid_amount') }}</th>
                <th>@sortablelink('customer_name', __('content.customer'))</th>
                <th>@sortablelink('customer_phone', __('content.phone_number'))</th> <th>{{ __('content.action') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($records as $record)
            <tr>
                <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-' }}</td>
                <td>{{ $record->invoice_no ?? '-' }}</td>
                <td>{{ isset($record->total) ? '$'.$record->total : '-' }}</td>
                <td>
                    <div class="d-flex align-items-center">
                        <span id="paid_amount-{{ $record->id }}">${{ (($record->is_refund == Invoice::ONE)  && ($record->balance == Invoice::ZERO)) ? $record->balance :  ($record->paid_amount ?? 0) }}</span>

                        @if($record->due > 0)
                        <a  href="javascript:void(0)" id="invoicePaidAmount-{{ $record->id }}" class="return_edit" data-record_id="{{ $record->id }}"> 
                            <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                        </a> <!-- data-bs-toggle="modal" data-bs-target="#Layway_popup" -->
                        @endif
                    </div>
                </td>
                <td class="text-nowrap">
                    {{ isset($record->customer_name) ? ucwords($record->customer_name) : ((isset($record->customer_id) ? ucwords($record->customer->fullname) : '-')) }}
                </td>
                <td class="text-nowrap">{{ $record->phone_with_code ?? '-' }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                            Action
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                            @if((($record->is_refund == Invoice::ONE) &&  ($record->balance == Invoice::ZERO)) ? $record->balance : ($record->paid_amount ?? 0))
                                <li><a class="dropdown-item" href="{{ route('admin.invoices.refund', $record->id) }}"><img src="{{ asset('public/img/vector.png') }}">Refund</a></li>
                            @endif

                            {{-- @can('invoice-print') --}}
                                <li><a class="dropdown-item btnprn" href="{{ route('admin.invoices.printInvoice', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Invoice</a></li>
                            {{-- @endcan --}}

                            <li><a class="dropdown-item" href="{{ route('admin.invoices.sendEmailPDF', $record->id) }}"><img src="{{ asset('public/img/envelope.png') }}">Send email</a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td class="text-center" colspan="7">No Record Found!</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>