@extends('layouts.admin.default')

@section('title',"Transactions")

@section('header', "Transactions")
@section('content')
    <a class="top_title" href="{{ route('admin.customers.index') }}"><img src="{{ asset('public/img/icon.png') }}" class="me-2" />Back to All Customers</a> {{-- URL::previous() --}}

    <div class="card mb-4 mt-3 card_custom">
        <div class="card-header">
            <h4 class="mb-0">Transactions</h4>
            <p>This section displays all transaction by {{ $customer->fullname }}.</p>
        </div>
        <div class="card-body">
            @php
                $placeholder = "Search Customers";             
            @endphp
            @include('admin.elements.search.common')

            <div class="earring-table table-responsive no_crack" >
                <table class="table stock-detail table_custom">
                    <thead>
                        <tr>
                            <th>{{ __('content.date') }}</th>
                            <th>@sortablelink('id', __('content.invoice_id'))</th>
                            <th>@sortablelink('total', __('content.amount'))</th>
                            <th>{{ __('content.paid_amount') }}</th>
                            
                            {{-- @canany(['customer-invoice-refund','customer-invoice-print','customer-invoice-sendEmailPDF'])  --}}
                            @canany(['invoice-refund','invoice-print','invoice-sendEmailPDF']) 
                            <th>{{ __('content.action') }}</th>
                            @endcanany 
                        </tr>
                    </thead>
                    <tbody>  
                        @forelse($records as $record)            
                        <tr>
                            <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-'}}</td>
                            <td>
                                @if(!empty($record->invoice_no))
                                    <a href="{{ route('admin.customers.invoiceItemsList', ['customer_id' => $customer->id, 'invoice_id' => $record->id]) }}" class="text-decoration-underline">{{ $record->invoice_no ?? '-' }}</a>
                                @else
                                    -
                                @endif
                            </td>
                            <td>{{ isset($record->total) ? '$'.$record->total : '-' }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span id="paid_amount-{{ $record->id }}">${{ $record->balance ?? 0 }}</span>

                                    @if($record->due > 0)
                                    <a  href="javascript:void(0)" id="invoicePaidAmount-{{ $record->id }}" class="return_edit" data-record_id="{{ $record->id }}"> 
                                        <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                                    </a> <!-- data-bs-toggle="modal" data-bs-target="#Layway_popup" -->
                                    @endif
                                </div>
                            </td>
                            {{-- @canany(['customer-invoice-refund','customer-invoice-print','customer-invoice-sendEmailPDF'])  --}}
                            @canany(['invoice-refund','invoice-print','invoice-sendEmailPDF']) 
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                        Action
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                        
                                        {{-- @can('customer-invoice-refund') --}}
                                        @can('invoice-refund')
                                            @if($record->balance > 0)
                                                <li><a class="dropdown-item" href="{{ route('admin.invoices.refund', $record->id) }}"><img src="{{ asset('public/img/vector.png') }}">To Refund</a></li>
                                            @endif
                                        @endcan

                                        {{-- @can('customer-invoice-print') --}}
                                        @can('invoice-print')
                                            <li><a class="dropdown-item btnprn" href="{{ route('admin.invoices.printInvoice', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Invoice</a></li>
                                        @endcan
                                       
                                        {{-- @can('customer-invoice-sendEmailPDF') --}}
                                        @can('invoice-sendEmailPDF')
                                            <li><a class="dropdown-item sendEmailPDF" href="javascript:void(0); {{-- route('admin.invoices.sendEmailPDF', $record->id) --}}" id="sendEmailPDF-{{ $record->id }}" data-record_id="{{ $record->id }}" data-for="invoices"><img src="{{ asset('public/img/envelope.png') }}">Send email</a></li>
                                        @endcan
                                    </ul>
                                </div>
                            </td>
                            @endcanany 
                        </tr>
                        @empty
                            <tr>
                                <td class="text-center" colspan="5">No Record Found!</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>
    
    @include('admin.elements.scripts.pdf_email_js')

    @include('admin.invoices.layway_popup')
@endsection

