@extends('layouts.admin.default')

@section('title',"Invoice")

@section('header', "Invoice")
@section('content')
    <a class="top_title" href="{{ route('admin.customers.transactionsList', $customer_id) }}"><img src="{{ asset('public/img/icon.png') }}" class="me-2" />Back to All Trancactions</a>

    <div class="card card_custom mb-4 mt-3">
        <div class="card-header">
            <h4 class="mb-0">Invoice {{ $invoice_id }}</h4>
            <p>This section displays all items in Invoice {{ $invoice_id }}.</p>
        </div>
        <div class="card-body">

            <div class="earring-table table-responsive no_crack" >
                <table class="table stock-detail table_custom">
                    <thead>
                        <tr>
                            <th>{{ __('content.date') }}</th>
                            <th>@sortablelink('item_code', __('content.item_code'))</th>
                            <th>{{ __('content.description') }}</th>
                            <th>@sortablelink('sub_total', __('content.amount'))</th>
                            <th>{{ __('content.action') }}</th>
                        </tr>
                    </thead>
                    <tbody>  
                        @forelse($records as $record)            
                        <tr>
                            <td>{{ isset($record->invoice->reference_date) ? date('d/m/Y', strtotime($record->invoice->reference_date)) : '-'}}</td>
                            <td><a href="javascript:void(0);" class="text-decoration-underline">{{ $record->item_code ?? '-' }}</a></td>
                            <td class="description">{{ $record->description ? \Illuminate\Support\Str::limit($record->description, 50, $end='...') : '-'}}</td>
                            <td>{{ isset($record->sub_total) ? '$'.$record->sub_total : '-' }}</td>
                            <td>
                                <a href="javascript:void(0);" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip" data-bs-title="Refund Item" class="red-tooltip">
                                    <img src="{{ asset('public/img/vector.png') }}">
                                </a>
                            </td>
                        </tr>
                        @empty
                            <tr>
                                <td class="text-center" colspan="5">No Record Found!</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>
@endsection
