@extends('layouts.admin.default')

@section('title',"Customers")

@section('header', "Customers")
@section('content')
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Customers</h4>
            <p>This section displays all customers.</p>
        </div>
        <div class="card-body">
            @php
                $placeholder = "Search Customers";

                 $create = [
                     'route' => route('admin.customers.create'),
                     'name' => "Create Customer"
                      ];
            @endphp
            @include('admin.elements.search.common')
            
            <div class="earring-table table-responsive no_crack">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>Account ID 中文</th>
                        <th>@sortablelink('fullname','Full Name 中文')</th>
                        <th>@sortablelink('phone','Phone Number')</th>
                        <th>@sortablelink('email','Email 中文')</th>
                        <th>@sortablelink('is_vip','VIP')</th>
                        <th>Status 中文</th>
                        <th>Remarks 中文</th>
                        <th>ACTION 中文</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($records) && $records->count())
                        @foreach($records as $record)
                            <tr>
                                @php  $account_id = sprintf("%03d", $record->id); @endphp
                                <td>{{ $account_id }}</td>
                                <td>{{ ucfirst($record->fullname) }}</td>
                                <td>{{ $record->phone_with_code }}</td>
                                <td>{{ $record->email }}</td>
                                <td>
                                    @if($record->is_vip) 
                                        <span class="badge badge-info">VIP</span>
                                    @else 
                                        -
                                    @endif
                                </td>
                                <td>Active 4mins ago</td>
                                <td class="">{{ !empty($record->remarks) ? \Illuminate\Support\Str::limit($record->remarks, 50, $end='...') : "-" }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            @can('customer-update')
                                                <li><a class="dropdown-item" href="{{ route('admin.customers.edit',$record->id ) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                            @endcan
                                            @can('customer-delete')
                                                <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.customers.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                            @endcan
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="8">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>

            @include('admin.elements.pagination.common')
        </div>
    </div>
    <!-- Modal -->

    <div class="modal fade model-custom-1" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body filter-options">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Jewellery Price Range
                                    (W GST)</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Worksmith Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Colour</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Backing Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Claw Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 mt-3">
                            <div class="filter-modal-btn m-0">
                                <button type="button" class="btn btn-filter" data-bs-dismiss="modal"><i
                                            class="icofont-filter"></i>Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    {{--    @include('admin.cutomers.script')--}}
@endsection
