@php use App\Models\User; @endphp

@extends('layouts.admin.default')

@section('title',"Customers")

@section('header', "Customers")
@section('content')
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">{{ __('content.all_customers')}}</h4>
            <p>This section displays all customers.</p>
        </div>
        <div class="card-body">
            @php
                $placeholder = "Search Customers";
            @endphp
            @can('customer-create')
            @php
                $create = [
                    'route' => route('admin.customers.create'),
                    'name' => "Create Customer"
                ];
            @endphp
            @endcan

            @include('admin.elements.search.common')

             <div class="card-body create_quotation">
                <div class="add_item">
                    <div class="items all_accounts">
                        @php
                            $activeTab =  !empty(request()->tab) ? request()->tab : null ;
                            $tabAll  = User::TAB_ALL;
                            $tabVip   = User::TAB_VIP;
                        @endphp

                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item ms-0" role="presentation">
                                <!-- <button class="nav-link all {{-- (($activeTab == $tabAll) || ($activeTab == null)) ? 'active' : '' --}}" data-tab={{-- $tabAll --}} id="all-tab" data-bs-toggle="tab" data-bs-target="#all-tab-pane" type="button" role="tab" aria-controls="all-tab-pane" aria-selected="true">All</button> -->

                                <a href="{{route('admin.customers.index', [ 'tab' => User::TAB_ALL ]) }}" class="nav-link text-center {{ ($tab == User::TAB_ALL) ? 'active' : '' }}" id="table-tab">All</a>
                            </li>
                            <li class="nav-item ms-0" role="presentation">
                                <!-- <button class="nav-link vip {{-- ($activeTab) == $tabVip ? 'active' : '' --}}" id="vip-tab" data-tab="{{-- $tabVip --}}" data-bs-toggle="tab" data-bs-target="#vip-tab-pane" type="button" role="tab" aria-controls="vip-tab-pane" aria-selected="false">VIP</button> -->

                                <a href="{{route('admin.customers.index', [ 'tab' => User::TAB_VIP ]) }}" class="nav-link text-center {{ ($tab == User::TAB_VIP) ? 'active' : '' }}" id="table-tab">VIP</a>
                            </li>
                        </ul>

                        <div class="tab-content" id="myTabContent">
                            @if($tab == $tabAll)
                            <!-- <div class="tab-pane fade {{-- ($activeTab)== $tabAll || ($activeTab == null)  ? 'show active' : '' --}}" id="all-tab-pane" role="tabpanel" aria-labelledby="all-tab" tabindex="0"> -->
                            <div class="">
                                <div class="earring-table table-responsive no_crack">
                                    <table class="table stock-detail">
                                        <thead>
                                            <tr>
                                                <th>{{ __('content.account_id') }}</th>
                                                <th>@sortablelink('fullname', __('content.full_name'))</th>
                                                <th>@sortablelink('phone', __('content.phone_number'))</th>
                                                <th>@sortablelink('email', __('content.email'))</th>
                                                <th>@sortablelink('is_vip','VIP')</th>
                                                <th>{{ __('content.transaction') }}</th>
                                                <th>{{ __('content.remarks') }}</th>
                                               
                                                @canany(['customer-update','customer-delete'])
                                                <th>{{ __('content.action') }}</th>
                                                @endcanany
                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @if(!empty($all) && $all->count())
                                            @foreach($all as $record)
                                                @php  // $account_id = sprintf("%03d", $record->id); @endphp
                                                <tr>
                                                    <td>
                                                        {{ getItemCode(3, $record->id) }}
                                                        {{-- $account_id --}}
                                                    </td>
                                                    <td>{{ ucfirst($record->fullname) }}</td>
                                                    <td>{{ $record->phone_with_code }}</td>
                                                    <td>{{ $record->email }}</td>
                                                    <td>
                                                        <input class="form-check-input" style="border: 2px solid #555;" type="checkbox" name="makeVIP" value="{{ $record->is_vip }}" id="makeVIP-{{ $record->id }}" data-id="{{ $record->id }}" {{ ($record->is_vip == 1) ? 'checked' : '' }}>
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('admin.customers.transactionsList', $record->id) }}" class="view_link">View</a>
                                                    </td>
                                                    <td class="">{{ !empty($record->remarks) ? \Illuminate\Support\Str::limit($record->remarks, 50, $end='...') : "-" }}</td>
                                                   @canany(['customer-update','customer-delete']) 
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                                Action
                                                            </button>
                                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                                @can('customer-update') 
                                                                    <li><a class="dropdown-item" href="{{ route('admin.customers.edit',$record->id ) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                                                 @endcan

                                                                @can('customer-delete')
                                                                    <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.customers.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li> 
                                                                @endcan 

                                                            </ul>
                                                        </div>
                                                    </td>
                                                 @endcanany 
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td class="text-center" colspan="8">No Record Found!</td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                </div>

                                <div class="row mt-4">
                                    <div class="col-sm-12 col-md-5 pl-4 d-flex justify-content-start">
                                        <div class="dataTables_info" id="bs4-table_info" role="status" aria-live="polite">
                                            Page {{ $all->currentPage() }} of {{ $all->lastPage() }}, showing {{ $all->count() }} record(s) out of {{ $all->total() }} total
                                        </div>
                                    </div>

                                    <div class="col-sm-12 col-md-7 d-flex justify-content-end">
                                        <div class="dataTables_paginate paging_simple_numbers float-right" id="bs4-table_paginate">
                                            {!! $all->appends(Request::except('page'))->links() !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @elseif($tab == $tabVip)
                            <!-- <div class="tab-pane fade {{-- ($activeTab) == $tabVip  ? 'show active' : '' --}}"
                                 id="vip-tab-pane" role="tabpanel" aria-labelledby="vip-tab" tabindex="0"> -->
                            <div class="">                                
                                <div class="earring-table table-responsive no_crack">
                                    <table class="table stock-detail">
                                        <thead>
                                            <tr>
                                                <th>{{ __('content.account_id') }}</th>
                                                <th>@sortablelink('fullname', __('content.full_name'))</th>
                                                <th>@sortablelink('phone', __('content.phone_number'))</th>
                                                <th>@sortablelink('email', __('content.email'))</th>
                                                <th>@sortablelink('is_vip','VIP')</th>
                                                <th>{{ __('content.transaction') }}</th>
                                                <!-- <th>Status 中文</th> -->
                                                <th>{{ __('content.remarks') }}</th>
                                                @canany(['customer-update','customer-delete']) 
                                                <th>{{ __('content.action') }}</th>
                                                @endcanany
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @if(!empty($vip) && $vip->count())
                                            @foreach($vip as $record)
                                                <tr>
                                                    @php  $account_id = sprintf("%03d", $record->id); @endphp
                                                    <td>{{ $account_id }}</td>
                                                    <td>{{ ucfirst($record->fullname) }}</td>
                                                    <td>{{ $record->phone_with_code }}</td>
                                                    <td>{{ $record->email }}</td>
                                                    <td>
                                                        @if($record->is_vip) 
                                                            <span class="badge badge-info">VIP</span>
                                                        @else 
                                                            -
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('admin.customers.transactionsList', $record->id) }}" class="view_link">View</a>
                                                    </td>
                                                    <!-- <td>Active 4mins ago</td> -->
                                                    <td class="">{{ !empty($record->remarks) ? \Illuminate\Support\Str::limit($record->remarks, 50, $end='...') : "-" }}</td>
                                                    @canany(['customer-update','customer-delete']) 
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1"
                                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                                Action
                                                            </button>
                                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                                @can('customer-update')
                                                                    <li><a class="dropdown-item" href="{{ route('admin.customers.edit',$record->id ) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                                                @endcan
                                                                @can('customer-delete')
                                                                    <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.customers.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                                                @endcan
                                                            </ul>
                                                        </div>
                                                    </td>
                                                    @endcanany
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td class="text-center" colspan="7">No Record Found!</td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                </div>

                                <div class="row mt-4">
                                    <div class="col-sm-12 col-md-5 pl-4 d-flex justify-content-start">
                                        <div class="dataTables_info" id="bs4-table_info" role="status" aria-live="polite">
                                            Page {{ $vip->currentPage() }} of {{ $vip->lastPage() }}, showing {{ $vip->count() }} record(s) out of {{ $vip->total() }} total
                                        </div>
                                    </div>

                                    <div class="col-sm-12 col-md-7 d-flex justify-content-end">
                                        <div class="dataTables_paginate paging_simple_numbers float-right" id="bs4-table_paginate">
                                            {!! $vip->appends(Request::except('page'))->links() !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            
            {{-- @include('admin.elements.pagination.common') --}}
        </div>
    </div>
    <!-- Modal -->

    <div class="modal fade model-custom-1" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body filter-options">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Jewellery Price Range
                                    (W GST)</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Worksmith Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Colour</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Backing Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Claw Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 mt-3">
                            <div class="filter-modal-btn m-0">
                                <button type="button" class="btn btn-filter" data-bs-dismiss="modal"><i class="icofont-filter"></i>Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    @include('admin.customers.script')

@endsection
