@php 
    use App\Models\Consignment;
    $shopSettings = \App\Models\Setting::shop_settings(); 
@endphp

@extends('layouts.print')

@section('title',"Consignment Receipt")

@section('header', "Consignment Receipt")

@section('content')

<table style="max-width:500px;width:100%;margin:0 auto;padding:40px;">
        <tbody>
            <tr style="">
                <td>
                    <div style="display: flex;justify-content: space-between; margin-bottom:60px;align-items: flex-start;">
                        <img style="" src="{{ asset('public/img/print_order_voucher.png') }}" alt="logo">
                        <div style="width: fit-content;">
                            <h5 style="margin:0px;font-size:14px;font-weight:600;color:#BE1E2D;opacity: 0.6;">Consignment No. {{ empty($consignment->consignment_no) ? getItemCode(Consignment::ZEROES, $consignment->id, Consignment::CONSIGNMENT) : $consignment->consignment_no }}</h5>
                            <p style="margin:0px; margin-top:10px;font-weight: 300;font-size:12px;color:#000;">Date {{ date('d/m/Y', strtotime($consignment->reference_date)) }}</p>
                        </div>
                    </div>
                </td>
            </tr>
            <tr style="display: flex;justify-content: space-between;margin-top:20px;">
                <td style="font-size:12px;display: flex;align-items: center;">
                    <p style="color:#64748B;margin:0px;">Sales Person:</p><h4 style="margin:0px;"><span style="color:#BE1E2D;opacity: 0.6;font-weight: 600;padding-left:15px;margin:0px;">
                        {{ ucwords($consignment->staff_name) ?? $consignment->staff ? ucwords($consignment->staff->fullname) : '-' }}</span></h4><p></p>
                </td>
                <td style="font-size:12px;display: flex;align-items: center;">
                    <p style="color:#64748B;margin:0px;">Received From:</p><h4 style="margin:0px;"><span style="color:#BE1E2D;opacity: 0.6;font-weight: 600;padding-left:15px;">
                        {{ ucwords($consignment->customer_name) ?? ucwords($consignment->customer->fullname) ?? '-' }}</span></h4><p></p>
                </td>
            </tr>
            <tr style="">
                <td style="display: flex;justify-content: space-between;">
                    <p style="font-size:10px;font-weight:300;color:#000;{{-- margin:0px; --}} margin-top:10px;">{{ $shopSettings['email'] }}</p>
                    <p style="font-size:10px;font-weight:300;color:#000;{{-- margin:0px; --}} margin-top:10px;">{{ $consignment->customer_email ?? $consignment->customer->email ?? '' }}</p>
                </td>
            </tr>
            <tr style="">
                <td style="display: flex;justify-content: space-between;">
                    <p style="font-size:10px;font-weight:300;color:#000;">{{ $shopSettings['address_line1'] }}
                        <span style="display: block;">{{ $shopSettings['address_line2'] }}</span>
                        <span style="display: block; margin-top:10px; margin-bottom:10px;">{{ $shopSettings['phone'] }}</span>
                    </p>
                    <p style="font-size:10px;font-weight:300;color:#000;">{{ $consignment->customer_phone ?? $consignment->customer->phone ?? '' }}</p>
                </td>
            </tr>
            <tr style="">
                <td style="">
                    <table cellpadding="0" cellspacing="0" style="width:100%;">
                        <tr>
                            <thead>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">Date
                                </th>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Previous Weight
                                </th>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Used
                                </th>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Remainder
                                </th>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Unit
                                </th>
                            </tr>
                        </thead>
                        @php $counter = 1; @endphp
                        @if($consignment->consignment_item)
                            @php $consignmentItem= $consignment->consignment_item @endphp
                            <tr style="">
                                <td style="margin-top:10px;vertical-align: top;border-top: 1px solid rgb(0 0 0 / 10%);border-bottom: 1px solid rgb(0 0 0 / 10%);padding: 5px 21px;">
                                    <h4 style="margin:0px; text-align:start;font-size:12px;font-weight:400;color:#000000;line-height: 18px;">{{ !empty($consignment->reference_date) ? date('d/m/Y', strtotime($consignment->reference_date)) : '-' }}</h4>
                                </td>
                                <td style="margin-top:10px;vertical-align: top;border-bottom: 1px solid rgb(0 0 0 / 10%);border-top: 1px solid rgb(0 0 0 / 10%);padding: 5px 21px;">
                                    <div style="width:216px;">
                                        <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height: 18px;">{{ $consignmentItem->weight ?? ' ' }}</p>
                                    </div>
                                </td>
                                <td style="margin-top:10px;vertical-align: top;border-bottom: 1px solid rgb(0 0 0 / 10%); border-top: 1px solid rgb(0 0 0 / 10%);padding: 5px 21px;">
                                    <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height:18px;">{{ $consignmentItem->used ?? ' ' }}</p>
                                </td>
                                <td style="margin-top:10px;vertical-align: top;border-bottom: 1px solid rgb(0 0 0 / 10%); border-top: 1px solid rgb(0 0 0 / 10%);padding: 5px 21px;">
                                    <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height: 18px;">{{ $consignmentItem->remainder ?? ' ' }}</p>
                                </td>
                                <td style="margin-top:10px;vertical-align: top;border-bottom: 1px solid rgb(0 0 0 / 10%);border-top: 1px solid rgb(0 0 0 / 10%);padding: 5px 21px;">
                                    <div style="width:216px;">
                                        <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height: 18px;">{{ ucwords($consignmentItem->unit) ?? ' ' }}</p>
                                    </div>
                                </td>
                            </tr>
                        @else
                            <tr style="">
                                <td colspan="4">No record found!</td>
                            </tr>
                        @endif
                    </table>
                    <table cellpadding="0" cellspacing="0" style="width: 100%; margin-top:40px;">
                        <tr>
                            <td style="margin-top:10px;vertical-align: top;">
                                <p style="font-weight:300; font-size:6px; line-height:9px;">ITEM IN UNWORN AND IN RESLEABLE CONDITION ARE RETURNABLE FOR A 7 DAY PERIOD FROM THE DATE OF PURCHASE (AS DATED ON THE RECEIPT), IN EXCHANGE FOR IN-STORE CREDIT. ALL REFUNDS FOR CUSTOM ORDERS WILL BE RETURNABLE AT LESS 25% AFTER THE COST OF THE WORKMANSHIP, MANUFACTURING LOSS, GST AND CARD CHARGES (IF APPLICABLE) HAVE BEEN DEDUCTED. DIAMOND, JADE, PEARL, PRECIOUS & SEMI-PRECIOUS GEMS ARE NOT RETURNABLE. ALL AFOREMENTIONED CONDITIONS ARE SUBJECTED TO CHANGES WITHOUT FURTHER NOTICE.</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>

@endsection