@extends('layouts.admin.default')

@section('title',"Consignments")

@section('header', "Consignments")
@section('content')
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Consignment</h4>
            <p>This section displays all consignments.</p>
        </div>
        <div class="card-body">
            @php $placeholder = "Search Consignment Id...";
            @endphp
            @can('consignment-create')
                @php
                    $create = [
                        'route' => route('admin.consignments.create'),
                        'name' => "Create Consignment"
                    ];
                @endphp
            @endcan

            @include('admin.elements.search.common')
            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>{{ __('content.date') }}</th>
                        <th>{{ __('content.consignment_id')}}</th>
                        <th style="width:310px;">{{ __('content.description') }}</th>
                        <th>@sortablelink('weight', __('content.weight'))</th>
                        <th>{{ __('content.unit') }}</th>
                        <th>@sortablelink('price_per_unit', __('content.price'))</th>
                        <th>@sortablelink('price_per_unit',__('content.used'))</th>
                        <th>@sortablelink('price_per_unit',__('content.remainder'))</th>
                        @canany(['consignment-update','consignment-delete'])
                        <th>{{ __('content.action') }}</th>
                        @endcanany
                        {{--<th>@sortablelink('status','Status')</th>--}}
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($records) && $records->count())
                        @php $slNo = $records->firstItem() @endphp
                        @foreach($records as $record)
                            <tr>
                                <td>{{ date('d/m/Y',strtotime($record->reference_date)) }}</td>
                                <td>{{ $record->consignment_no ?? $record->id ?? '-' }}</td>
                                <td class="description">{{ !empty($record->consignment_item->description) ? \Illuminate\Support\Str::limit($record->consignment_item->description, 112, $end='...') : '-' }}</td>
                                <td>{{ $record->consignment_item->weight ?? '-' }}</td>
                                <td>{{ ucwords($record->consignment_item->unit) ?? '-' }}</td>
                                <td>{{ isset($record->consignment_review_cost->total) ? '$'.$record->consignment_review_cost->total : '-' }}</td>
                                <td>
                                    <!-- <div class="d-flex">
                                        <input class="return_input" type="text" name="" value="40.44" />{{-- $record->consignment_item->return ?? '-' --}}
                                        <a href="javascript:void(0)" class="return_edit">
                                            <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                                            <img class="return_second" src="{{ asset('public/img/icon-check.png') }}">
                                        </a>
                                    </div> -->

                                    <div class="d-flex align-items-center">
                                        <span id="used-{{ $record->id }}">{{ $record->consignment_item->used ?? '0' }}</span> 
                                        
                                        @if($record->consignment_item->remainder > 0) 
                                        <a href="javascript:void(0)" class="return_edit" id="amountUsed-{{ $record->id }}" data-consignment_id="{{ $record->id }}" data-consignment_item_id="{{ $record->consignment_item->id }}">
                                            <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                                        </a><!-- data-bs-toggle="modal" data-bs-target="#usedModal" -->
                                        @endif 
                                    </div>
                                </td>
                                <td id="remainder-{{ $record->id }}">{{ $record->consignment_item->remainder ?? '-' }}</td>
                               @canany(['consignment-update','consignment-delete'])
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            @canany('consignment-update')
                                            <li><a class="dropdown-item" href="{{ route('admin.consignments.edit',$record->id) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                            @endcan
                                            @can('consignment-delete')
                                            <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.consignments.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                            @endcan
                                            @can('consignment-printReceipt')
                                            <li><a class="dropdown-item btnprn" href="{{ route('admin.consignments.printReceipt',$record->id) }}"><img src=" {{ asset('public/img/print.png') }} ">Print Receipt</a></li>
                                            @endcan
                                        </ul>
                                    </div>
                                </td>
                               @endcanany  
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="9">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>
    
    <!-- Modal -->
    <div class="modal fade model-custom-1" id="usedModal" tabindex="-1" aria-labelledby="usedModalLabel"
     aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option download_option sm_download_modal">
            <div class="modal-content">
                <div class="modal-header">
                   <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close_model"></button>
                </div>
                <div class="modal-body filter-options">
                    <h5 class="modal-title"></h5>
                    <form class="amountUsedForm" id="consignmentAmountUsedForm" action="{{ route('admin.consignments.updateAmountUsed') }}" method="POST">
                    @csrf

                        <div class="loader-bg" id="loader" style="display:none;z-index:9999;">
                            <div class="loader"></div>
                        </div>
                        <input type="hidden" name="consignment_id" id="hidden_consignment_id"/>
                        <input type="hidden" name="consignment_item_id" id="hidden_consignment_item_id"/>
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group me-2">
                                    <label style="text-align:center; font-weight:600; font-size:14px;">Amount Used</label>
                                    <input type="text" name="used" id="used" class="cus_form_control w-100" value="" placeholder="0.00">
                                    <span class="error-message">
                                        <strong id="usedError" class="error_msg"></strong>
                                    </span>
                                </div>
                            </div>
                        </div>
                    
                            <div class="col-lg-12 col-md-12 mt-3">
                                <div class="m-0">
                                    <button type="submit" class="btn btn_download w-50 d-block mx-auto submit_report" name="submit">Update
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // $(document).ready(function(){
        //     $('.return_edit').click(function(){
        //         $(this).parent().toggleClass('return_value')
        //     });
        // });
    </script>

    <script> 
        $(document).ready(function(){
            // alert('ready');
            $('.return_edit').click(function(){
                var consignment_id = $(this).data('consignment_id');
                console.log('consignment_id :',consignment_id);
                $('#hidden_consignment_id').val(consignment_id);

                var consignment_item_id = $(this).data('consignment_item_id');
                console.log('consignment_item_id :',consignment_item_id);
                $('#hidden_consignment_item_id').val(consignment_item_id);

                $('#usedModal').modal('show');

                $('.amountUsedForm').submit(function(e){
                    e.preventDefault(); 
                    var _this = $(this);

                    var action = $(this).attr('action');
                    console.log('action : ',action);

                    var formData = new FormData();
                    formData.append("consignment_id", $("#hidden_consignment_id").val());
                    formData.append("consignment_item_id", $("#hidden_consignment_item_id").val());
                    formData.append("used", $("#used").val());
                    formData.append("_token", "{{csrf_token()}}");

                    $('#loader').show();
                    $.ajax({
                        type:'POST',
                        url: action,
                        data: formData,
                        contentType: false,
                        processData: false,
                        dataType: 'json',
                        success: function(res){

                            $('#loader').hide();
                            console.log('res :'+res);
                            console.log('res message :'+res.message);

                            (_this).find(':input[type=submit]').prop('disabled', false);

                            if(res.errors) {
                                $.each(res.errors, function(key, value) {
                                    key2=key.replace(".", "_");
                                    $('#'+key2+'Error').html(value[0]);  
                                });
                            }

                            if(res.status==0){
                                error(res.message, res.title);
                            }else if(res.status==1){
                                if(res.data.remainder == 0){
                                    $('#amountUsed-'+consignment_id).css('display','none');
                                }
                                if(res.data.used.includes('.') == true){
                                    $('#used-'+consignment_id).html(res.data.used);
                                    $('#remainder-'+consignment_id).html(res.data.remainder);
                                }else{
                                    $('#used-'+consignment_id).html(res.data.used+'.00');
                                    $('#remainder-'+consignment_id).html(res.data.remainder+'.00');
                                }
                                $('#usedModal form')[0].reset();
                                $('#usedModal').modal('hide');
                                // $('#used-'+consignment_id).html(res.data.used);
                                // $('#remainder-'+consignment_id).html(res.data.remainder);
                                success(res.message, res.title);
                            }
                        },
                    });
                });
            });
        });
    </script>

@endsection
