@extends('layouts.admin.default')

@section('title',"Add Consignment")

@section('header', "Add Consignment")


@section('content')
    <form action="{{ route('admin.consignments.store') }}" method="post" autocomplete="off">
        @csrf
        @php
            $is_error = $errors->any() ? 1 : 0;
            $x = $is_error ? old('jewelleries') ? count(old('jewelleries')) : '1' : 1;
        @endphp
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Create Consignment</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group cus_form_group">
                            <label class="form-label cus_label">{{ __('content.date_created') }}</label>
                            <!-- <input type="date" name="reference_date" class="cus_form_control w-100" value="{{-- old('reference_date',$record->reference_date) --}}" > -->
                            <input type="text" name="reference_date" class="cus_form_control minDatePicker" value="{{ old('reference_date',$record->reference_date) }}" readonly>
                        </div>
                        @if ($errors->has('reference_date'))
                            <span class="error-message">
                                <strong>{{ $errors->first('reference_date') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">Details</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="category jobs_edit">
                            <div class="form-group">
                                <label class="form-label">Category</label>
                            </div>
                            <ul class="">
                                @php $categories = \App\Models\Category::getCategories(); @endphp
                                @foreach($categories as $key=>$value)
                                    <li class="{{ old('category_id',$record->category_id) == $value->id ? 'active_category' : '' }}">
                                        <a class="category_id" data-id="{{ $value->id }}">
                                            <img src="{{ $value->image }}" height="60" width="60"/>{{ $value->name }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                            <input id="category_id" type="hidden" name="category_id" value="{{ old('category_id', $record->category_id) }}"/>
                            @if ($errors->has('category_id'))
                                <span class="error-message">
                                   <strong>{{ $errors->first('category_id') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="form-group">
                            <label  class="form-label">{{ __('content.description') }} </label>
                            <textarea class="form-control" name="description"  placeholder="Description" rows="2"> {{ old('description',$record->description) }}  </textarea>
                            @if ($errors->has('description'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('description') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="bespoke_inputs">
                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('Weight') }}</label>
                                        <input type="text" class="form-control" id="0" name="weight" value="{{ old('weight', $record->weight) }}" oninput="onInputweight()">
                                    </div>
                                    @if ($errors->has('weight'))
                                    <span class="error-message">
                                        <strong>{{ $errors->first('weight') }}</strong>
                                    </span>
                                    @endif
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('Unit') }}</label>
                                        <!-- <input type="text" class="form-control" id="0" name="unit" value="{{-- old('unit') --}}" oninput="onInputUnitPrice()"> --> 
                                        @php 
                                        $units = \App\Models\MaterialUnit::getMaterialUnitsList(); 
                                        @endphp
                                        <select class="form-select" aria-label="Default select example" name="unit" value="{{ old('unit', $record->unit) }}">
                                            <option value="">Select One Option</option>
                                            @foreach($units as $key=>$value)
                                                <option value="{{ strtolower($value) }}" {{ (old('unit', $record->unit) == strtolower($value)) ? 'selected' : '' }}>{{ $value  }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if ($errors->has('unit'))
                                    <span class="error-message">
                                        <strong>{{ $errors->first('unit') }}</strong>
                                    </span>
                                    @endif
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('Price Per Unit($)') }}</label>
                                        <input type="text" class="form-control" id="0" name="unit_price" value="{{ old('unit_price', $record->unit_price) }}" oninput="onInputUnitPrice()">
                                    </div>
                                    @if ($errors->has('unit_price'))
                                    <span class="error-message">
                                        <strong>{{ $errors->first('unit_price') }}</strong>
                                    </span>
                                    @endif
                                </div>
                                <!-- <div id="append_fields">
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group plus pt-0">
                                        <a id="addPlus"><i class="icofont-plus"></i></a>
                                    </div>
                                </div>  -->
                            </div>
                        </div>

                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group pt-0">
                                        <label  class="form-label">{{ __('content.handle_by') }}</label>
                                        @php $handledBy = \App\Models\Admin::handleBYArray();@endphp
                                        <select class="form-select" aria-label="Default select example" name="staff_id" value="{{ old('staff_id', $record->staff_id) }}">
                                            <option value="">Select One Option</option>
                                            @foreach($handledBy as $key=>$value)
                                                <option value="{{ $value->id }}" {{ old('staff_id', $record->staff_id) == $value->id ? 'selected' : '' }}>{{ ucwords($value->fullname) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if ($errors->has('staff_id'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('staff_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group pt-0 position-relative">
                                        <label  class="form-label">{{ __('content.customer_phone_no') }}</label>
                                        <div class="search">
                                            <img src="{{ asset('public/img/search.png') }}"/>
                                            <input type="text" class="form-control" id="customer_phone" placeholder="Enter or Search Phone Number" name="customer_phone" value="{{ old('customer_phone', $record->customer_phone) }}">
                                        </div>
                                        @if ($errors->has('customer_phone'))
                                            <span class="error-message">
                                                <strong>{{ $errors->first('customer_phone') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label"> {{ __('content.customer_name') }}</label>
                                        <input type="text" class="form-control" tabindex="1" id="customer_name" name="customer_name" value="{{ old('customer_name', $record->customer_name) }}">
                                    </div>
                                    @if ($errors->has('customer_name'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('customer_name') }}
                                            </strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label">{{ __('content.customer_email') }}</label>
                                        <input type="text" tabindex="2" class="form-control" id="customer_email" name="customer_email" value="{{ old('customer_email', $record->customer_email) }}">
                                    </div>
                                    @if ($errors->has('customer_email'))
                                        <span class="error-message">
                                    <strong>{{ $errors->first('customer_email') }}</strong>
                                </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons">
                    <button class="btn btn-primary btn-create" type="submit">{{ __('content.input_cost') }}</button>
                    <a href="{{-- route('admin.jewelleries.index') --}}" class="btn btn-primary btn-reset-form w-auto ps-3 pe-3"
                       type="button">{{ __('content.reset_form') }}</a>
                </div>
                <div class="col-lg-5 note pt-2">
                    <!-- <p>Note:
                        <span class="d-block">Upon creating a jewellery successfully, a job order for a worksmith will be automatically created. Go to Job Order to assign a worksmith to the newly job order.</span>
                    </p> -->
                </div>
            </div>
        </div>
    </form>

    @include('admin.jewelleries.script')

@endsection

