@extends('layouts.admin.default')

@section('title',"Categories")

@section('header', "Categories")
@section('content')


    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">Categories</h4>
            <p>This section displays the categories in Sancy’s Inventory</p>
        </div>
        <div class="card-body">
            @php
                $data=[
                    'route' => route('admin.categories.create'),
                    'name' => "Add Category"
                ]
            @endphp
            @include('admin.elements.search.common')

            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>Select</th>
                        <th>#</th>
                        <th class="cus-w-1">@sortablelink('name','Name')</th>
                        <th>IMAGE</th>
                        <th> @sortablelink('created_at','DATE')</th>
                        <th>@sortablelink('status','Status')</th>
                        <th>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($records) && $records->count())
                        @php $slNo = $records->firstItem() @endphp
                        @foreach($records as $record)
                            <tr>
                                <td>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    </div>
                                </td>
                                <td>{{$slNo++}}</td>
                                <td class="description">{{ ucfirst($record->name) }}</td>
                                <td>
                                    <a data-fancybox="gallery" href="{{$record->image}}"><img src="{{$record->image}}" class="img-fluid" width="60" height="60"></a>
                                </td>
                                <td>{{ date('d/m/y', strtotime($record->created_at))}}</td>
                                <td class="align_center">{!! CommonHelper::getStatusUrl('admin.categories.changeStatus',$record->status,$record->id) !!}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            {{--<li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/duplicate.png') }}">Duplicate</a></li>--}}
                                            {{--<li><a class="dropdown-item" href=""><img src=" {{ asset('public/img/quotation.png') }} ">Quotations</a></li>--}}
                                            <li><a class="dropdown-item"
                                                   href="{{ route('admin.categories.edit',$record->id) }}"><img
                                                            src=" {{ asset('public/img/edit.png') }} ">Edit</a></li>
                                            {{--<li><a class="dropdown-item" href="#"><img src=" {{ asset('public/img/print.png') }}  ">Print</a></a></li>--}}
                                            <li><a class="dropdown-item confirmDelete" href="javascript:void(0);"
                                                   data-action="{{ route('admin.categories.destroy',$record->id) }}"><img
                                                            src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                        </ul>
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="7">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body filter-options">

                    <form method="get" class="ajaxForm" action="{{ url()->current() }}" id="AjaxFilter"
                          autocomplete="off">
                        <input type="hidden" class="form-control" src="{{ asset('public/img/inventory-search.png') }}"
                               name="search"  value="{{ request('search') }}">
                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Date</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" name="start_date" class="cus_form_control datePicker"
                                           placeholder="From" value="{{ request('start_date') }}">
                                </div>
                                <div class="errorTxt"></div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" name="end_date" class="cus_form_control datePicker"
                                           placeholder="To" value="{{ request('end_date') }}">
                                </div>
                            </div>

                        </div>
                        <div class="col-lg-12 col-md-12 mt-3">
                            <div class="filter-modal-btn m-0">
                                <button type="submit" id="AjaxFilterButton" type="button" class="btn btn-filter"
                                        data-bs-dismiss="modal"><i
                                            class="icofont-filter"></i>Filter
                                </button>
                            </div>
                        </div>

                    </form>

                </div>

            </div>
        </div>
    </div>

    <script>
        $('.datePicker').datetimepicker({
            format: 'd-m-Y',
            timepicker: false
        });

    </script>
@endsection