@extends('layouts.admin.default')

@section('title',"Edit Category")

@section('header', "Edit Category")

@section('content')

    <div class="card details mb-4">
        <div class="card-header">
            <h4 class="mb-0">Edit Category</h4>
        </div>
        <div class="card-body">
            <form method="POST" class="sign-in-form" class="sign-in-form" enctype="multipart/form-data"
                  action="{{ route('admin.categories.update', $record->id)}}" autocomplete="off">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="modal-login pb-0">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Category Name</label>
                                    <input type="text" name="name" class="form-control"
                                           id="exampleInputEmail1" placeholder="Enter Category Name"
                                           value="{{ old('name',$record->name) }}">
                                    @if ($errors->has('name'))
                                        <span class="error-message"><strong>{{ $errors->first('name') }}</strong></span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-0">
                                    <label for="exampleFormControlInput1"
                                           class="form-label">Status</label>
                                    <select name="status" class="form-select"
                                            value="{{ old('status',$record->status) }}">
                                        @php $options = CommonHelper::getStatusOption(); @endphp
                                        @foreach($options as $key=>$value)
                                            <option {{ old('status',$record->status) == $key ? 'selected' : '' }} value="{{ $key }}"> {{ $value }}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('status'))
                                        <span class="error-message">
								<strong>{{ $errors->first('status') }}</strong>
							</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Image</label>
                                    <input type="file" name="image" class="form-control"
                                           id="exampleInputEmail1">
                                    @if ($errors->has('image'))
                                        <span class="error-message"><strong>{{ $errors->first('image') }}</strong></span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Image</label>
                                    <div><a data-fancybox="gallery" href="{{$record->image}}"><img
                                                    src="{{$record->image}}" class="img-fluid" width="80"
                                                    height="80"></a></div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Image Icon</label>
                                    <input type="file" name="icon_image" class="form-control"
                                           id="exampleInputEmail1">
                                    @if ($errors->has('icon_image'))
                                        <span class="error-message"><strong>{{ $errors->first('icon_image') }}</strong></span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Image Icon</label>
                                    <div><a data-fancybox="gallery" href="{{$record->icon_image}}"><img
                                                    src="{{$record->icon_image}}" class="img-fluid" width="80"
                                                    height="80"></a></div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="buttons mt-5">
                    <button class="btn btn-primary btn-create" type="submit">Update</button>
                    <a href="{{ route('admin.categories.index') }}" class="btn btn-primary btn-reset-form"
                       type="submit">Cancel</a>
                </div>
            </form>
        </div>
    </div>

@endsection
