@extends('layouts.admin.app')
@section('title',"Admin Reset Password")
@section('content')
    <div class="login login_crm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-5 p-0">
                    <div class="jewellery remove_bg justify-content-center p-0">
                        <div>
                            <a href="{{ route('admin.login')}}">
                              <img src="{{ asset('public/img/sancy-crm-logo.png') }}" class="img-fluid"/>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 p-0 align-self-center">
                    <div class="login_page align-self-center justify-content-center align-items-center">
                        <form method="POST" class="sign-in-form" class="sign-in-form"
                              action="{{ route('admin.password.email') }}" autocomplete="off">
                            @csrf
                            <div class="row">
                                <div class="modal-login forgot-p pb-0">
                                    <div class="row">
                                        <h2>Forgotten Password?</h2>
                                        <p>Enter your email to reset your password</p>
                                        <div class="col-lg-12 pt-4">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label fw-bold">Email</label>
                                                <input type="text" name="email" class="form-control" value="{{ old('email') }}"
                                                       id="exampleInputEmail1" placeholder="Email address">
                                                @if ($errors->has('email'))
                                                    <span class="error-message">
                                                    <strong>{{ $errors->first('email') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group mb-0 text-center">
                                            <button class="btn login-btn" data-bs-target="#exampleModalToggle2"
                                                    data-bs-toggle="modal">Send to mail
                                            </button>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
