@extends('layouts.admin.app')

@section('content')
    <div class="login login_crm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-5 p-0">
                    <div class="jewellery remove_bg justify-content-center p-0">
                        <div>
                            <a href="{{ route('admin.login')}}">
                               <img src="{{ asset('public/img/sancy-crm-logo.png') }}" class="img-fluid"/>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 p-0 align-self-center">
                    <div class="login_page align-self-center justify-content-center align-items-center">
                        {{-- <h3>Having issues? <a href="#">Get Help</a></h3> --}}
                        <form method="POST" class="sign-in-form" class="sign-in-form"
                              action="{{ route('admin.login') }}" autocomplete="off">
                            @csrf
                            <div class="row">
                                <div class="modal-login mt-0 pb-0">
                                    <h2>Log In</h2>
                                    <p>Log in to Sancy CRM</p>
                                    <div class="row">
                                        <div class="col-lg-12 pt-4">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label fw-bold">Email</label>
                                                <input type="text" name="email" class="form-control"
                                                       id="exampleInputEmail1" placeholder="Email address" value="{{ old('email') }}">
                                                @if ($errors->has('email'))
                                                    <span class="error-message">
                                                    <strong>{{ $errors->first('email') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="form-group mb-0 position-relative">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <label for="exampleFormControlInput1"
                                                           class="form-label fw-bold">Password</label>
                                                    @if (Route::has('admin.password.request'))
                                                        <label for="exampleFormControlInput1" class="form-label forgot"><a
                                                                    href="{{ route('admin.password.request') }}">Forgot
                                                                Password?</a></label>
                                                    @endif
                                                </div>
                                                <input type="password" name="password" class="form-control class_password"  placeholder="Password">
                                                <i class="icofont-eye-blocked password_eye togglePassword"></i>
                                                @if ($errors->has('password'))
                                                    <span class="error-message">
                                                   <strong>{{ $errors->first('password') }}</strong>
                                                   </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="form-group mb-0 text-center">
                                            <button class="btn login-btn" data-bs-target="#exampleModalToggle2"
                                                    data-bs-toggle="modal">Log In
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
