<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\MaterialUnit;

class MaterialUnitSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $material_units = [
            [
                'name'   => 'Piece',
                'status' => MaterialUnit::ACTIVE,
            ],
            [
                'name'   => 'Biscuit',
                'status' => MaterialUnit::ACTIVE,
            ],
            [
                'name'   => 'Brick',
                'status' => MaterialUnit::ACTIVE,
            ],
            [
                'name'   => 'Gram',
                'status' => MaterialUnit::ACTIVE,
            ],
            [
                'name'   => 'Kilogram',
                'status' => MaterialUnit::ACTIVE,
            ],
            [
                'name'   => 'Litre',
                'status' => MaterialUnit::ACTIVE,
            ],
        ];
  
        foreach ($material_units as $key => $value) {
            MaterialUnit::create($value);
        }
    }
}
