<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $setting = [
            [
                'key'     => 'email',
                'value'   => 'example@sancy.com',
                'group'   => 'Shop_Settings'  
            ],
            [
                'key'     => 'phone',
                'value'   => '6734 6832',
                'group'   => 'Shop_Settings'
            ],
            [
                'key'     => 'address_line1',
                'value'   => '304 Orchard Road, B1, #102',
                'group'   => 'Shop_Settings'
            ],
            [
                'key'     => 'address_line2',
                'value'   => 'Lucky Plaza, 238863',
                'group'   => 'Shop_Settings'
            ],
            [
                'key'     => 'print_ip_address',
                'value'   => '192.168.0.0',
                'group'   => 'Shop_Settings'  
            ],
            [
                'key'     => 'print_port',
                'value'   => '9100',
                'group'   => 'Shop_Settings'  
            ],
            
            [
                'key'     => 'gst_percent',
                'value'   => 7,
                'group'   => 'Price_Settings'  
            ],
            [
                'key'     => 'usd_unit',
                'value'   => '1.37',
                'group'   => 'Price_Settings'
            ],
            [
                'key'     => 'hkd_unit',
                'value'   => 0.17,
                'group'   => 'Price_Settings'
            ],
            
        ];
  
        foreach ($setting as $key => $value) {
            Setting::create($value);
        }
    }
}
