<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use App\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        Role::truncate();
        Schema::enableForeignKeyConstraints();

        $roles = [
            [
                'name'       => 'Super Admin',
                'guard_name' => Role::GUARD_ADMIN,
            ],
            [
                'name'       => 'Sub Admin',
                'guard_name' => Role::GUARD_ADMIN,
            ],
            [
                'name'       => 'Staff',
                'guard_name' => Role::GUARD_ADMIN,
            ], 
            [
                'name'       => 'Worksmith',
                'guard_name' => Role::GUARD_ADMIN,
            ],
            [
                'name'       => 'Customer',
                'guard_name' => Role::GUARD_ADMIN,
            ],
        ];
  
        foreach ($roles as $key => $value) {
            Role::create($value);
        }
    }
}
