<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Schema;


class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        Permission::truncate();
        Schema::enableForeignKeyConstraints();

        $permissions = [

             /*   Role Permission */
            [
                'name' => 'role-create', 'module_name' => 'role','guard_name' => 'Admin',
                'route_name' => 'admin.roles.create|admin.roles.store'
                
            ],
            [
                'name' => 'role-read', 'module_name' => 'role', 'guard_name' => 'Admin',
                'route_name' => 'admin.roles.index'
            ],
            [
                'name' => 'role-update', 'module_name' => 'role', 'guard_name' => 'Admin',
                'route_name' => 'admin.roles.edit|admin.roles.update'
            ],
            [
                'name' => 'role-delete', 'module_name' => 'role', 'guard_name' => 'Admin',
                'route_name' => 'admin.roles.destroy'
            ],
             /*   Jewellery Permission */
            [
                'name' => 'jewellery-create', 'module_name' => 'jewellery', 'guard_name' => 'Admin',
                'route_name' => 'admin.jewelleries.create|admin.jewelleries.store|admin.jewelleries.dropzoneStore|admin.jewelleries.purchagedCostSummery|admin.jewelleries.bespokeCostSummery|admin.jewelleries.updateCost|
                admin.jewelleries.bespokeCostSummery|admin.jewelleries.bespokeCostSummery|admin.jewelleries.jobUpdateCost',
            ],

            [
                'name' => 'jewellery-update', 'module_name' => 'jewellery', 'guard_name' => 'Admin',
                'route_name' => 'admin.jewelleries.edit|admin.jewelleries.update|admin.jewelleries.dropzoneStore|admin.jewelleries.purchagedCostSummery|admin.jewelleries.bespokeCostSummery|admin.jewelleries.updateCost|admin.jewelleries.jobUpdateCost'

            ],
            [
                'name' => 'jewellery-read', 'module_name' => 'jewellery', 'guard_name' => 'Admin',
                'route_name' => 'admin.jewelleries.indexByCategory'
            ],
     
            [
                'name' => 'jewellery-delete', 'module_name' => 'jewellery', 'guard_name' => 'Admin',
                'route_name' => 'admin.jewelleries.destroy'
            ],
            [
                'name' => 'jewellery-duplicate', 'module_name' => 'jewellery', 'guard_name' => 'Admin',
                'route_name' => 'admin.jewelleries.duplicate|admin.jewelleries.addDuplicate'
            ],
            [
                'name' => 'jewellery-print', 'module_name' => 'jewellery', 'guard_name' => 'Admin',
                'route_name' => 'admin.jewelleries.print'
            ],  
            [
                'name' => 'jewellery-printTag', 'module_name' => 'jewellery', 'guard_name' => 'Admin',
                'route_name' => 'admin.jewelleries.print.tag'
            ], 
            /*   Job Permission */
            [
                'name' => 'job-create', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.create|admin.jobs.store|admin.jobs.dropzoneStore|admin.jobs.bespokeCostSummery|admin.jobs.repairCostSummery|admin.jobs.updateCost',
            ],
            [
                'name' => 'job-update', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.edit|admin.jobs.update|admin.jobs.dropzoneStore|admin.jobs.bespokeCostSummery|admin.jobs.repairCostSummery|admin.jobs.updateCost'
            ],
            [
                'name' => 'job-read', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.index|admin.jobs.changeStatus|admin.jobs.assignWorksmith'
            ],
            [
                'name' => 'job-delete', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.destroy'
            ],
            [
                'name' => 'job-restore', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.restore'
            ],
            [
                'name' => 'job-duplicate', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.duplicate|admin.jobs.addDuplicate'
            ],
            [
                'name' => 'job-print', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.print'
            ],
            [
                'name' => 'job-dashboard', 'module_name' => 'job', 'guard_name' => 'Admin',
                'route_name' => 'admin.jobs.dashboard|admin.jobs.exportTotal|admin.jobs.exportBespoke|admin.jobs.exportRepair|admin.jobs.exportDelayed'
            ],
             /*   Customer Permission */
            [
                'name' => 'customer-create', 'module_name' => 'customer', 'guard_name' => 'Admin',
                'route_name' => 'admin.customers.create|admin.customers.store'
            ],
            [
                'name' => 'customer-read', 'module_name' => 'customer', 'guard_name' => 'Admin',
                'route_name' => 'admin.customers.index|admin.customers.transactionsList|admin.customers.makeVIP|admin.customers.invoiceItemsList'
            ],
            [
                'name' => 'customer-update', 'module_name' => 'customer', 'guard_name' => 'Admin',
                'route_name' => 'admin.customers.edit|admin.customers.update'
            ],
            [
                'name' => 'customer-delete', 'module_name' => 'customer', 'guard_name' => 'Admin',
                'route_name' => 'admin.customers.destroy'
            ],
            // [
            //     'name' => 'customer-invoice-print', 'module_name' => 'customer', 'guard_name' => 'Admin',
            //     'route_name' => 'admin.invoices.printInvoice'
            // ],
            // [
            //     'name' => 'customer-invoice-sendEmailPDF', 'module_name' => 'customer', 'guard_name' => 'Admin',
            //     'route_name' => 'admin.invoices.sendEmailPDF'
            // ],
            // [
            //     'name' => 'customer-invoice-refund', 'module_name' => 'customer', 'guard_name' => 'Admin',
            //     'route_name' => 'admin.invoices.refund'
            // ],
           
             /*   Staff Permission */
            [
                'name' => 'staff-create', 'module_name' => 'staff', 'guard_name' => 'Admin',
                'route_name' => 'admin.staffs.create|admin.staffs.store'
            ],
            [
                'name' => 'staff-read', 'module_name' => 'staff', 'guard_name' => 'Admin',
                'route_name' => 'admin.staffs.index'
            ],
            [
                'name' => 'staff-update', 'module_name' => 'staff', 'guard_name' => 'Admin',
                'route_name' => 'admin.staffs.edit|admin.staffs.update'
            ],
            [
                'name' => 'staff-delete', 'module_name' => 'staff', 'guard_name' => 'Admin',
                'route_name' => 'admin.staffs.destroy' 
            ],
    
            [
                'name' => 'worksmith-create', 'module_name' => 'worksmith', 'guard_name' => 'Admin',
                'route_name' => 'admin.worksmiths.create|admin.worksmiths.store'
            ],
            [
                'name' => 'worksmith-read', 'module_name' => 'worksmith', 'guard_name' => 'Admin',
                'route_name' => 'admin.worksmiths.index'
            ],
            [
                'name' => 'worksmith-update', 'module_name' => 'worksmith', 'guard_name' => 'Admin',
                'route_name' => 'admin.worksmiths.edit|admin.worksmiths.update'
            ],
            [
                'name' => 'worksmith-delete', 'module_name' => 'worksmith', 'guard_name' => 'Admin',
                'route_name' => 'admin.worksmiths.destroy' 
            ],
            /*   Consignment Permission */
            [
                'name' => 'consignment-create', 'module_name' => 'consignment', 'guard_name' => 'Admin',
                'route_name' => 'admin.consignments.create|admin.consignments.store|admin.consignments.reviewCostSummary|admin.consignments.updateCost'
            ],
            [
                'name' => 'consignment-read', 'module_name' => 'consignment', 'guard_name' => 'Admin',
                'route_name' => 'admin.consignments.index|admin.consignments.updateAmountUsed'
            ],
            [
                'name' => 'consignment-update', 'module_name' => 'consignment', 'guard_name' => 'Admin',
                'route_name' => 'admin.consignments.edit|admin.consignments.update|admin.consignments.reviewCostSummary|admin.consignments.updateCost'
            ],
            [
                'name' => 'consignment-delete', 'module_name' => 'consignment', 'guard_name' => 'Admin',
                'route_name' => 'admin.consignments.destroy'
            ],
            [
                'name' => 'consignment-printReceipt', 'module_name' => 'consignment', 'guard_name' => 'Admin',
                'route_name' => 'admin.consignments.printReceipt'
            ],
            /*   Setting Permission */
            [
                'name' => 'setting-shopSetting', 'module_name' => 'setting', 'guard_name' => 'Admin',
                'route_name' => 'admin.settings.shopSettings|admin.settings.updateShopSettings'
            ],
            [
                'name' => 'setting-priceSetting', 'module_name' => 'setting', 'guard_name' => 'Admin',
                'route_name' => 'admin.settings.priceSettings|admin.settings.updatePriceSettings'
            ],
            /*  Admin Quotation Permission */
            [
                'name' => 'quotation-create', 'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.create|admin.quotations.store'
            ],
            [
                'name' => 'quotation-update', 'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.edit|admin.quotations.update'
            ],
            [
                'name' => 'quotation-read', 'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.index|admin.invoices.updatePayment'
            ],
            [
                'name' => 'quotation-delete', 'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.destroy'
            ],
            [
                'name' => 'quotation-print', 'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.printQuotation'
            ],
            [
                'name' => 'quotation-convertToInvoice',  'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.convertToInvoice'
             ],
            [
                'name' => 'quotation-printOrderVoucher', 'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.printOrderVoucher'
            ],
            [
                'name' => 'quotation-sendEmailPDF', 'module_name' => 'quotation', 'guard_name' => 'Admin',
                'route_name' => 'admin.quotations.sendEmailPDF'
            ],
            /*   Invoice Permission */
            [
                'name' => 'invoice-create', 'module_name' => 'invoice', 'guard_name' => 'Admin',
                'route_name' => 'admin.invoices.create|admin.invoices.store|admin.invoices.cost|admin.invoices.updateCost'
            ],
            [
                'name' => 'invoice-read', 'module_name' => 'invoice', 'guard_name' => 'Admin',
                'route_name' => 'admin.invoices.index|admin.invoices.details|admin.invoices.updatePaidAmount'
            ],
            [
                'name' => 'invoice-print', 'module_name' => 'invoice', 'guard_name' => 'Admin',
                'route_name' => 'admin.invoices.printInvoice'
            ],
            [
                'name' => 'invoice-sendEmailPDF', 'module_name' => 'invoice', 'guard_name' => 'Admin',
                'route_name' => 'admin.invoices.sendEmailPDF'
            ],
            [
                'name' => 'invoice-refund', 'module_name' => 'invoice', 'guard_name' => 'Admin',
                'route_name' => 'admin.invoices.refund'
            ],
            
            // /* Front Quotation Permission */
            [
                'name' => 'frontQuotation-create', 'module_name' => 'front_quotation', 'guard_name' => 'Admin',
                'route_name' => 'quotations.create|quotations.quotationsStore|quotations.printQuotation|quotations.printOrderVoucher|quotations.printBoth'
            ],
            [
                'name' => 'frontQuotation-read', 'module_name' => 'front_quotation', 'guard_name' => 'Admin',
                'route_name' => 'quotations.todaysOrders|quotations.showItemsList|quotation_items.detail|quotations.createInvoice|quotations.sendToJobOrder'
            ],
            // [
            //     'name' => 'frontQuotation-convertToInvoice', 'module_name' => 'front_quotation', 'guard_name' => 'Admin',
            //     'route_name' => 'quotations.convertToInvoice|'
            // ],
            [
                'name' => 'frontQuotation-printOrderVoucher', 'module_name' => 'front_quotation', 'guard_name' => 'Admin',
                'route_name' => 'quotations.printOrderVoucher|'
            ],
            [
                'name' => 'frontQuotation-print', 'module_name' => 'front_quotation', 'guard_name' => 'Admin',
                'route_name' => 'quotations.printQuotation|'
            ],
            [
                'name' => 'frontQuotation-sendEmailPDF', 'module_name' => 'front_quotation', 'guard_name' => 'Admin',
                'route_name' => 'quotations.sendEmailPDF'
            ],

            // /* Front Invoice Permission */
            [
                'name' => 'frontInvoice-create', 'module_name' => 'front_invoice', 'guard_name' => 'Admin',
                'route_name' => 'invoices.create|invoices.store|invoices.printInvoice|invoices.updatePayment'
            ],
            [
                'name' => 'frontInvoice-read', 'module_name' => 'front_invoice', 'guard_name' => 'Admin',
                'route_name' => 'invoices.todaysSales|invoices.details|invoices.updatePaidAmount'
            ],
            [
                'name' => 'frontInvoice-print', 'module_name' => 'front_invoice', 'guard_name' => 'Admin',
                'route_name' => 'invoices.printInvoice|'
            ],
            [
                'name' => 'frontInvoice-sendEmailPDF', 'module_name' => 'front_invoice', 'guard_name' => 'Admin',
                'route_name' => 'invoices.sendEmailPDF'
            ],
            [
                'name' => 'frontInvoice-refund', 'module_name' => 'front_invoice', 'guard_name' => 'Admin',
                'route_name' => 'invoices.refund'
            ],
            

            // /* Front Job Repair Permission */
            [
                'name' => 'frontRepairJob-create', 'module_name' => 'front_repair_job', 'guard_name' => 'Admin',
                'route_name' => 'jobs.repairCreate|jobs.store|jobs.bespokeReairData|jobs.printJob'
            ],

            // /* Front Bespoke Permission */
            [
                'name' => 'frontBespokeJob-create', 'module_name' => 'front_bespoke_job', 'guard_name' => 'Admin',
                'route_name' => 'jobs.bespokeCreate|jobs.store|jobs.bespokeReairData|jobs.printJob'
            ],


        ];

        foreach ($permissions as $key => $value) {
            Permission::create($value);
        }
    }
}
