<?php

namespace Database\Seeders;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Seeder;
use App\Models\GoldColor;

class GoldColorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        GoldColor::truncate();
        Schema::enableForeignKeyConstraints();

        $gold_colors = [
            [
                'name'   => 'White Gold',
                'status' => GoldColor::ACTIVE,
            ],
            [
                'name'   => 'Rose Gold',
                'status' => GoldColor::ACTIVE,
            ],
            [
                'name'   => 'Yellow Gold',
                'status' => GoldColor::ACTIVE,
            ],
            [
                'name'   => 'No Gold',
                'status' => GoldColor::ACTIVE,
            ],
        ];

        foreach ($gold_colors as $key => $value) {
            GoldColor::create($value);
        }
    }
}
