<?php

namespace Database\Seeders;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Seeder;
use App\Models\MaterialUnit;

class CreateMaterialUnitSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        MaterialUnit::truncate();
        Schema::enableForeignKeyConstraints();
    
        $materialUnit = [
            [
                'name'  => "Gram",
                'status' => MaterialUnit::ACTIVE
            ],
            [
                'name'  => "Kilogram",
                'status' => MaterialUnit::ACTIVE
            ],
            [
                'name'  => "Pieces",
                'status' => MaterialUnit::ACTIVE
            ],
            [
                'name'  => "Pairs",
                'status' => MaterialUnit::ACTIVE
            ],
            [
                'name'  => "Carot",
                'status' => MaterialUnit::ACTIVE
            ],
        ];


        foreach ($materialUnit as $key => $value) {
            MaterialUnit::create($value);
        }

    }
}
