<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use App\Models\Admin;

class CreateAdminsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        Admin::truncate();
        Schema::enableForeignKeyConstraints();

        $admins = [
            [
                'role_id'           => '1',
                'fullname'          => 'Vipin Paul',
                'email'             => 'vipin@braintechnosys.com',
                'email_verified_at' => date('Y-m-d h:i:s'),
                'phone'             => 9876543210,
                'password'          => bcrypt('admin123'),
                'image'             => NULL,
                'status'            => Admin::ACTIVE,
            ],
            [
                'role_id'           => '1',
                'fullname'          => 'Nigel Looi',
                'email'             => 'nigel@superfastech.com',
                'email_verified_at' => date('Y-m-d h:i:s'),
                'phone'             => 9876543211,
                'password'          => bcrypt('admin123'),
                'image'             => NULL,
                'status'            => Admin::ACTIVE,
            ],
            [
                'role_id'           => '2',
                'fullname'          => 'Shiwali Saraswat',
                'email'             => 'shiwali@braintechnosys.biz',
                'email_verified_at' => date('Y-m-d h:i:s'),
                'phone'             => 9876543212,
                'password'          => bcrypt('admin123'),
                'image'             => NULL,
                'status'            => Admin::ACTIVE,
            ],
            [
                'role_id'           => '3',
                'fullname'          => 'Vandana Dubey',
                'email'             => 'vandana@braintechnosys.biz',
                'email_verified_at' => date('Y-m-d h:i:s'),
                'phone'             => 9876543213,
                'password'          => bcrypt('admin123'),
                'image'             => NULL,
                'status'            => Admin::ACTIVE,
            ],
        ];

        foreach ($admins as $key => $value) {
            Admin::create($value);
        }
    }
}
