<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use \Spatie\Permission\Models\Permission;
use App\Models\Admin;

class CreateAdminsRolePermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $super_admin  = Admin::where('id',1)->first();
        if ($super_admin) {
            $super_admin->assignRole('Super Admin');
        }
        $role = Role::where('id',1)->firstOrFail();
        $permissions = Permission::pluck('id')->all();
        $role->syncPermissions($permissions);
    }
}
