<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\BackingType;

class BackingTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $backing_types = [
            [
                'name'   => 'Push Backs/Butterfly Backs',
                'status' => BackingType::ACTIVE,
            ],
            [
                'name'   => 'Screwbacks',
                'status' => BackingType::ACTIVE,
            ],
            [
                'name'   => 'French Wires',
                'status' => BackingType::ACTIVE,
            ],
            [
                'name'   => 'French Clips/Omega',
                'status' => BackingType::ACTIVE,
            ],
            [
                'name'   => 'Leverbacks',
                'status' => BackingType::ACTIVE,
            ],
            [
                'name'   => 'Ball Backs',
                'status' => BackingType::ACTIVE,
            ]
        ];
  
        foreach ($backing_types as $key => $value) {
            BackingType::create($value);
        }
    }
}
