<?php

namespace Database\Seeders;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Seeder;
use App\Models\Type;
use DB;

class AddTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        Schema::disableForeignKeyConstraints();
        Type::truncate();
        Schema::enableForeignKeyConstraints();
        $types = [
            [
                'name'   => 'Bespoke',
                'status' => Type::ACTIVE,
            ],
            [
                'name'   => 'Purchased',
                'status' => Type::ACTIVE,
            ],


        ];
        foreach ($types as $key => $value) {
            Type::create($value);
        }
    }
}
