<?php

namespace Database\Seeders;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Seeder;
use App\Models\JobType;
use DB;

class AddJobTypeSeeder extends Seeder
{
    public function run()
    {

        Schema::disableForeignKeyConstraints();
        JobType::truncate();
        Schema::enableForeignKeyConstraints();

        $jobTypes = [
            [
                'name'   => 'Bespoke',
                'status' => JobType::ACTIVE,
            ],
            [
                'name'   => 'Repair',
                'status' => JobType::ACTIVE,
            ],

        ];
        foreach ($jobTypes as $key => $value) {
            JobType::create($value);
        }
    }
}
