<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuotationItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotation_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('item_code', 10)->comment('unique alpha-numeric code');
            $table->unsignedBigInteger('quotation_id');
            $table->unsignedBigInteger('jewellery_id');
            $table->unsignedBigInteger('type_id')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->double('weight')->nullable();
            $table->double('quantity')->nullable();
            $table->timestamps();

            $table->foreign('id')->references('quotation_id')->on('quotations')->onDelete('cascade');
            $table->foreign('id')->references('jewellery_id')->on('jewelleries')->onDelete('cascade');
            $table->foreign('id')->references('type_id')->on('types')->onDelete('cascade');
            $table->foreign('id')->references('category_id')->on('categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('qoutation_items');
    }
}
