<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateConsignmentItemsTable1 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('consignment_items', function (Blueprint $table) {
            $table->decimal('weight', $precision = 10, $scale = 2)->nullable()->comment('Initially we have the overall weight')->change();
            $table->decimal('used', $precision = 10, $scale = 2)->nullable()->comment('Overall used weight')->after('total_price');
            $table->decimal('remainder', $precision = 10, $scale = 2)->nullable()->comment('Overall remainder weight')->after('used');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
