<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateJobsTable11 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('jobs', function (Blueprint $table) {
            $table->date('estimate_completion')->nullable()->change();
            $table->string('additional_material')->nullable()->after('gold_color_id');
            $table->integer('material_quantity')->nullable()->after('additional_material');
            $table->string('additional_information')->nullable()->after('material_quantity');
            $table->enum('is_jewellery_received',['0','1'])->default('0')->comment('0->No, 1->Yes')->after('backing_quantity');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
