<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateInvoicesTable3 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->decimal('paid_amount', $precision = 10, $scale = 2)->nullable()->comment('overall paid amount as subtotal')->after('total');
            $table->decimal('balance', $precision = 10, $scale = 2)->nullable()->comment('paid amount - refunded amount as overall')->after('paid_amount');
            $table->decimal('due', $precision = 10, $scale = 2)->nullable()->comment('overall remaining amount')->after('balance');
            $table->enum('is_refund', ['0','1'])->default('0')->comment('0->No, 1->Yes')->after('due');
            $table->decimal('refunded_amount', $precision = 10, $scale = 2)->nullable()->comment('amount returned back to customer')->after('is_refund');
            $table->enum('payment_status', ['0','1','2', '3'])->default('0')->comment('0->Pending, 1->In-Progress, 2->Completed, 3->Failed')->after('refunded_amount');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
