<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('invoice_id')->nullable();
            $table->unsignedBigInteger('consignment_id')->nullable();
            $table->decimal('total_amount', $precision = 10, $scale = 2);
            $table->decimal('paid_amount', $precision = 10, $scale = 2)->nullable()->comment('overall paid amount as subtotal');
            $table->decimal('balance', $precision = 10, $scale = 2)->nullable()->comment('paid amount - refunded amount as overall');
            $table->decimal('due', $precision = 10, $scale = 2)->nullable()->comment('overall remaining amount');
            $table->enum('is_refund', ['0','1'])->default('0')->comment('0->No, 1->Yes');
            $table->decimal('refunded_amount', $precision = 10, $scale = 2)->nullable()->comment('amount returned back to customer');
            $table->enum('payment_status', ['0','1','2', '3'])->default('0')->comment('0->Pending, 1->In-Progress, 2->Completed, 3->Failed');
            $table->enum('payment_mode', ['1','2', '3'])->nullable()->comment('1->Credit Card, 2->Cheque, 3->Cash (For this transaction only)');
            $table->timestamps();

            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
            $table->foreign('consignment_id')->references('id')->on('consignments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
