<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateQuotationsTable2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quotations', function (Blueprint $table) {
            $table->string('quotation_no', 50)->comment('unique alpha-numeric code')->nullable()->after('id');

            // Drop Foreign Key Job Id
            $table->dropForeign('quotations_job_id_foreign'); 
         //   $table->dropIndex('quotations_job_id_index');
            $table->dropColumn('job_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
